/*
 * $Id: SourceFileNode.java,v 1.8 2001/04/07 16:45:04 kuro Exp $
 *                 Copyright(C) 2001 Hiroyuki Kurokawa
 */
package jp.gr.java_conf.a0.jdh.gui;

import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.SourceCodeParser;
import jp.gr.java_conf.a0.jdh.parser.source.JavaDocHolder;
import jp.gr.java_conf.a0.jdh.parser.source.ClassDecl;
import jp.gr.java_conf.a0.jdh.parser.source.MethodDecl;
import jp.gr.java_conf.a0.jdh.parser.source.FieldDecl;

import java.io.IOException;
import java.io.FileNotFoundException;
import jp.gr.java_conf.a0.jdh.parser.ParseException;

import jp.gr.java_conf.a0.debug.Debug;
import jp.gr.java_conf.a0.debug.Logger;

/**
 * 
 */
class SourceFileNode extends ClassTreeNode implements PropertyChangeListener
{
	public SourceFileNode(File aFile)
	{
		super(aFile);
		//super(aFile.getAbsolutePath());
		if (CurrentProperties.parsesWhenLoaded()) {
			ParseThread.getInstance().pushNode(this);
		}
		CurrentProperties.addPropertyChangeListener(this);
		// XXX: SourceFileNodeTree폜ƂremovePropertyChangeListener()
	}
	public void notifyPropertyChanged()
	{
		Enumeration enum = children();
		while (enum.hasMoreElements()) {
			((ClassNode)enum.nextElement()).selectNodes(CurrentProperties.getTreeNodeAccess(),
														true,   // method
														CurrentProperties.displaysNodeField(),
														CurrentProperties.displaysInnerClass());
		}
	}
	
	/**
	 * ̃m[hȉ̑Sm[h̕ύXAJavaDocToken֔fB
	 * t@Cւ̕ۑ͍sȂB
	 */
	public void reflect()
	{
		Enumeration enum = this.changedNodes.elements();
		while (enum.hasMoreElements()) {
			// JavaDocRgTokenɔf
			((JavaDocNode)enum.nextElement()).reflect();
		}
	}
	/**
	 * JavaDocRg}[W\[Xt@Co͂B
	 * o̓t@C̓IvVŁu㏑vƁuʖۑi.jdhjv
	 * ؂ւ邱ƂłB
	 */
	public void save()
	{
Debug.println("SourceFileNode.save(): START");
		if (CurrentProperties.reflectsBeforeSave()) {
Debug.println("SourceFileNode.save(): CALL reflect()");
			reflect();
		}
		if (!this.isChanged()) {
Debug.println("SourceFileNode.save(): not changed...");
			// XVӏȂꍇsaveKvȂ̂łȂɂȂ
			return;
		}
		try {
Debug.println("SourceFileNode.save(): CALL writeTo()");
			this.firstClass.writeTo(this.getReflectFile());
		}
		catch (Exception ex) {
			Debug.warn(ex);
			// XXX
			//MsgDialog.show();
			return;
		}
		this.changed = false;
	}
	/**
	 * Serialize@\ɂ鏑ݎAStackOverflows̉̂߁A
	 * Token.next, Token.specialTokentransientɂAXg\̕ۑA
	 * 񕜂writeObject(), readObject()ɎB
	 */
	private void writeObject(ObjectOutputStream aStream) throws IOException
	{
		Debug.println("SourceFileNode.writeObject() START!");
		aStream.defaultWriteObject();
		
		// this.firstClass.getFirstToken()ȉ̃g[N̍\ۑ
		Token t = this.firstClass.getFirstToken();
		while (t != null) {
			aStream.writeObject(new TokenHolder(t));
			t = t.next;
		}
		aStream.writeObject(null);
	}
	private void readObject(ObjectInputStream aStream)
		throws IOException, ClassNotFoundException
	{
		Debug.println("SourceFileNode.readObject() START!");
		aStream.defaultReadObject();
		
		// this.firstClass.getFirstToken()ȉ̃g[N̍\
		TokenHolder prev = (TokenHolder)aStream.readObject();
		prev.setSpecials();
		TokenHolder holder = (TokenHolder)aStream.readObject();
		while (holder != null) {
			prev.setNext(holder);
			prev = holder;
			holder.setSpecials();
			holder = (TokenHolder)aStream.readObject();
		}
	}
	
	//public void parse() throws FileNotFoundException, ParseException
	public synchronized Exception parse()
	{
		Debug.println("SourceFileNode.parse(): " + this);
		SourceCodeParser parser = null;
		if (this.parsed) {
			return(null);
		}
		if (this.isParseFailed()) {
			return(this.parseFailed);
		}
		try {
			this.parsing = true;
			parser = new SourceCodeParser(new BufferedReader(
								 new FileReader((File)super.getUserObject())));

			ClassDecl[] classDecls = parser.CompilationUnit();
			ClassNode newNode = null;
			this.firstClass = classDecls[0];
		
			// p[X㐶 ClassNode ƓւH
			for (int i = 0; i < classDecls.length; i++) {
				newNode = new ClassNode(classDecls[i], this);
				this.add(newNode);
			}
			if (CurrentProperties.getParseAllWhenSourceOpened()) {
				this.checkState();
			}
		}
		catch (Exception ex) {
			//ex.printStackTrace();
			this.setParseFailed(ex);
			return(ex);
		}
		finally {
			this.parsing = false;
		}
		this.parsed = true;
		return(null);
	}
	protected void checkState()
	{
		Debug.println("SourceNode.checkState(): START");	
		this.invalidNodes.clear();
		this.changedNodes.clear();
		Enumeration enum = this.children();
		while (enum.hasMoreElements()) {
			((JavaDocNode)enum.nextElement()).checkState();
		}
	}
	
	protected void setInvalid(boolean aFlag, JavaDocNode aNode)
	{
		if (aFlag) {
			this.invalidNodes.put(aNode, aNode);
		} else {
			this.invalidNodes.remove(aNode);
		}
	}
	public boolean isInvalid() {return(this.invalidNodes.size() != 0);}
	protected void setChanged(boolean aChanged, JavaDocNode aNode)
	{
		if (aChanged) {
			this.changedNodes.put(aNode, aNode);
			MainWindow.getProject().notifyChanged();
		} else {
			this.changedNodes.remove(aNode);
		}
		this.changed = true;
		//Debug.println("SourceFileNode.setChanged(): changedNodes.size(): " + changedNodes.size());
		//Logger.LOG.record(new Throwable());
	}
	public boolean isChanged()
	{
		//Debug.println("SourceFileNode.isChanged(): changedNodes.size(): " + changedNodes.size());
		return(this.changed || this.changedNodes.size() != 0);
	}

	/**
	 * t@Ĉ݂c[ɕ\邽߂ɃI[o[Ch
	 */
	public String toString()
	{
		return(this.getFile().getName());
	}
	/**  false Ԃ悤ɃI[o[Ch */
	public boolean isLeaf() 	{return(false);}
	/** ΃pXԂ */
	public String getToolTipText()	{return(this.getFile().getAbsolutePath());}
	/** leafIconԂ */
	public Icon getIcon(boolean anExpanded)
	{
		if (this.isParseFailed()) {
			return(INVALID_LEAF_ICON);
		} else {
			return(LEAF_ICON);
		}
	}
	private File getReflectFile()
	{
		if (this.getFile().getName().endsWith(".jdh")) {
Debug.println("SourceFileNode.getReflectFile(): ends with jdh");
			if (!CurrentProperties.preservesOrginalFile()) {
Debug.println("SourceFileNode.getReflectFile(): origin mode ");
				String path = this.getFile().getAbsolutePath();
				this.setFile(new File(path.substring(0,  path.length() - 4)));
			}
		} else {
Debug.println("SourceFileNode.getReflectFile(): doesn't end with jdh");
			// doesn't end with .jdh
			if (CurrentProperties.preservesOrginalFile()) {
Debug.println("SourceFileNode.getReflectFile(): not origin mode ");
				// IWicꍇ́A".jdh"tt@CԂB
				this.setFile(new File(this.getFile().getAbsolutePath() + ".jdh"));
			}
		}
		Debug.println("SourceFileNode.getReflectFile(): " + this.getFile());
		return(this.getFile());
	}

	private File getFile()	{return((File)super.userObject);}
	private void setFile(File f) {super.userObject = f;}
	private boolean isParseFailed(){return(this.parseFailed != null);}
	protected void setParseFailed(Exception ex)
	{
		this.parseFailed = ex;
		this.setInvalid((ex != null), JavaDocNode.DUMMY_NODE);
	}
	protected boolean isParsing(){return(this.parsing);}

// Fields
	private boolean parsed = false;
	private boolean parsing = false;
	private Exception parseFailed;
	private final Hashtable invalidNodes = new Hashtable();
	private final Hashtable changedNodes = new Hashtable();
	private ClassDecl firstClass;
	private boolean changed = false;

// InnerClass
	/**
	 * g[ÑXg\ێ邽߂̃NXB
	 * ŌɂnullށiǍnullԂ܂ŏjB
	 */
	private static class TokenHolder implements Serializable
	{
		private TokenHolder(Token aToken)
		{
			this.token = aToken;
			Token t = aToken.specialToken;
			while (t != null) {
				this.specials.addElement(t);
				t = t.specialToken;
			}
		}
		private void setSpecials()
		{
			Token st = null;
			Token prev = this.token;
			Enumeration enum = this.specials.elements();
			while(enum.hasMoreElements()) {
				st = (Token)enum.nextElement();
				prev.specialToken = st;
				st.next = prev;
				prev = st;
			}
		}
		private void setNext(TokenHolder aNext)
		{
			this.token.next = aNext.token;
		}
		
		private final Token token;
		//private Token[] specials;
		private final Vector specials = new Vector();
	}
}



class ClassNode extends JavaDocNode
{
	public ClassNode(ClassDecl aClass, SourceFileNode aFileNode)
	{
		super(aClass, aFileNode);	// ̏ԂIvVŎwH
		int index = 0;
		this.methods = new MethodNode[aClass.getClassBlock().getMethods().size()];
		Enumeration enum = aClass.getClassBlock().getMethods().elements();
		while (enum.hasMoreElements()) {
			this.methods[index] = new MethodNode((MethodDecl)enum.nextElement(), aFileNode);
			index++;
		}
		index = 0;
		this.fields = new FieldNode[aClass.getClassBlock().getFields().size()];
		enum = aClass.getClassBlock().getFields().elements();
		while (enum.hasMoreElements()) {
			this.fields[index] = new FieldNode((FieldDecl)enum.nextElement(), aFileNode);
			index++;
		}
		index = 0;
		this.classes = new ClassNode[aClass.getClassBlock().getClasses().size()];
		enum = aClass.getClassBlock().getClasses().elements();
		while (enum.hasMoreElements()) {
			this.classes[index] = new ClassNode((ClassDecl)enum.nextElement(), aFileNode);
			index++;
		}
		this.selectNodes(CurrentProperties.getTreeNodeAccess(),
						 true,   // method
						 CurrentProperties.displaysNodeField(),
						 CurrentProperties.displaysInnerClass());
	}
	public String toString()
	{
		return(((ClassDecl)super.userObject).getClassName());
	}

	/**
	 * AccessFlag 0: public, 1: protected, 2: pkg, 3: private. 
	 * @see jp.gr.java_conf.a0.jdh.parser.source.JavaDocHolder#ACC_PUBLIC
	 * @see jp.gr.java_conf.a0.jdh.parser.source.JavaDocHolder#ACC_PROTECTED
	 * @see jp.gr.java_conf.a0.jdh.parser.source.JavaDocHolder#ACC_PKG
	 * @see jp.gr.java_conf.a0.jdh.parser.source.JavaDocHolder#ACC_PRIVATE
	 */
	public void selectNodes(int anAccessFlag, boolean aShowMethods, boolean aShowFields, boolean aShowClasses)
	{
		//Debug.println("flag: " + anAccessFlag + ", method: " +aShowMethods+ ", field: "+aShowFields+ ", classes: "+ aShowClasses);
		this.removeAllChildren();
		int i = 0;
		if (aShowMethods) {
			for (i = 0; i < this.methods.length; i++) {
				if (this.methods[i].getJavaDocHolder().getAccessFlag() <= anAccessFlag) {
					this.add(this.methods[i]);
				}
			}
		}
		if (aShowFields) {
			for (i = 0; i < this.fields.length; i++) {
				// FieldNode.getAccessFlag()ł 0x04 ƂORԂ
				if (this.fields[i].getJavaDocHolder().getAccessFlag() <= anAccessFlag) {
					this.add(this.fields[i]);
				}
			}
		}
		if (aShowClasses) {
			for (i = 0; i < this.classes.length; i++) {
				if (this.classes[i].getJavaDocHolder().getAccessFlag() <= anAccessFlag) {
					this.add(this.classes[i]);
				}
			}
		}
		//Debug.println("EXIT: num child: " + children.size());
		//Debug.println("reload!");
		MainWindow.getInstance().getClassTree().getClassTreeModel().reload(this);
	}

	private final MethodNode[] methods; // all
	private final FieldNode[] fields;
	private final ClassNode[] classes;
}
class MethodNode extends JavaDocNode
{
	public MethodNode(MethodDecl aMethod, SourceFileNode aFileNode)
	{
		super(aMethod, aFileNode);
	}
	public String toString()
	{
		return(((MethodDecl)super.userObject).getMethodName());
	}
}
class FieldNode extends JavaDocNode
{
	public FieldNode(FieldDecl aField, SourceFileNode aFileNode)
	{
		super(aField, aFileNode);
	}
	public String toString()
	{
		return(((FieldDecl)super.userObject).getFieldName());
	}
	public int getAccessFlag()	
	{
		return(super.getAccessFlag() | 0x04);
	}
}
