package jp.gr.java_conf.a0.jdh.gui;

import java.util.Hashtable;
import java.util.Enumeration;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
//import javax.swing.tree.TreeNode

import jp.gr.java_conf.a0.debug.Debug;


public class RootTreeNode extends ClassTreeNode
{
	public RootTreeNode(ClassTreeModel aModel)
	{
		this(aModel, new File[0]);
	}

	/**
	 * c[ɒǉt@CwBׂẴt@C ".java"ŏI
	 * Java\[Xt@CłȂ΂ȂȂB
	 */
	public RootTreeNode(ClassTreeModel aModel, File[] aFileList)
	{
		super("root");
		this.model = aModel;
		for(int i = 0; i < aFileList.length; i++) {
			this.addFile(aFileList[i]);
		}
	}
	
	public void addFile(File aFile)
	{
		//Debug.println("absolute: " + aFile.getAbsolutePath());
		//Debug.println("name    : " + aFile.getName());
		
		if (!aFile.getAbsolutePath().equals(aFile.getName())) {
			aFile = new File(aFile.getAbsolutePath());
		}
		
		DirectoryNode node = (DirectoryNode)this.dirNodes.get(aFile.getParent());
		//Debug.println("RootTreeNode.addFile(): " + aFile+", node:"+node);
		if (node == null) {
			node = new DirectoryNode(aFile.getParent());
			//this.add(node);
			this.model.insertNodeInto(node, this, 0);
			this.dirNodes.put(aFile.getParent(), node);
			//node.setParent(this);	// add()̒ŌĂ΂
			//Debug.println("RootTreeNode.addFile(): this.add: " + node+", childCount:"+getChildCount());
			SwingUtilities.updateComponentTreeUI(MainWindow.getInstance().getClassTree());
		}
		//node.add(new SourceFileNode(aFile));
		this.model.insertNodeInto(new SourceFileNode(aFile), node, 0);
	}
	
	/**
	 * dirNodes폜邽߂ɃI[o[Ch
	 */
	/*
	public void remove(int anIndex)
	{
		this.dirNodes.remove(((DefaultMutableTreeNode)super.getChildAt(anIndex)).getUserObject());
		super.remove(anIndex);
	}
	*/
	
	/**
	 *  false Ԃ悤ɃI[o[Ch
	 */
	public boolean isLeaf() 
	{
		return(false);
	}
	/** ΃pXԂ */
	public String getToolTipText()	{return("root");}
	/** leafIconԂ */
	public Icon getIcon(boolean anExpanded)
	{
		if (anExpanded) {
			return(OPEN_ICON);
		} else {
			return(CLOSED_ICON);
		}
	}
	
	// true: pkgMode, false: dirMode
	private boolean pkgMode;
	private final Hashtable dirNodes = new Hashtable();
	private final ClassTreeModel model;

}


/*
protected class PackageNode extends JavaDocNode
{
}
*/
