package jp.gr.java_conf.a0.jdh.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Locale;
//import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.metal.*;
import jp.gr.java_conf.a0.debug.Debug;


public class PropertyDialog extends JDialog
{
	public PropertyDialog(MainWindow aMain)
	{
        super(aMain.getFrame(), "Preferences", true);
		JPanel container = new JPanel();
		container.setLayout( new BorderLayout() );

		JTabbedPane tabs = new JTabbedPane();
		JPanel winPanel = buildWinPanel();
		JPanel treePanel = buildTreePanel();
		JPanel contentPanel = buildContentPanel();
		JPanel parsePanel = buildParsePanel();
		//JPanel parsePanel = buildFilterPanel();
		tabs.addTab(MainWindow.getResource().getString("tab.option.win"), null, winPanel);
		tabs.addTab(MainWindow.getResource().getString("tab.option.tree"), null, treePanel);
		tabs.addTab(MainWindow.getResource().getString("tab.option.content"), null, contentPanel);
		tabs.addTab(MainWindow.getResource().getString("tab.option.parse"), null, parsePanel);

		JPanel buttonPanel = new JPanel();
		//buttonPanel.setLayout ( new FlowLayout(FlowLayout.RIGHT) );
		ok.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					OKPressed();
				}});
		buttonPanel.add( ok );
		cancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					CancelPressed();
				}});
		buttonPanel.add( cancel );
		getRootPane().setDefaultButton(ok);

		disableOptions();
		container.add(tabs, BorderLayout.CENTER);
		container.add(buttonPanel, BorderLayout.SOUTH);
		getContentPane().add(container);
		pack();
		centerDialog();
		//UIManager.addPropertyChangeListener(new UISwitchListener(container));
    }
	/**
	 * set disabled to unimplemented options.
	 */
	private void disableOptions()
	{
		tRootNodeDisp.setEnabled(false);
		tTreeNodeParam.setEnabled(false);
		cSrcColor.setEnabled(false);
		cSrcDoc.setEnabled(false);
		docAdd.setEnabled(false);
		docAddEx.setEnabled(false);
		docAddParam.setEnabled(false);
		docCheck.setEnabled(false);
		docRepare.setEnabled(false);
		//docExPkg.setEnabled(false);
		tFontName.setEnabled(false);
		tFontSize.setEnabled(false);
	}

    public JPanel buildWinPanel() {
		JPanel connectPanel = new JPanel();
		connectPanel.setLayout( new ColumnLayout() );
		//connectPanel.setBorder( new TitledBorder("flags") );

		connectPanel.add(wTooltipDisp);
		connectPanel.add(wTooltipParam);
		connectPanel.add(wInvalidColor);
		connectPanel.add(wModifiedColor);
		connectPanel.add(outJdh);
		connectPanel.add(reflectBeforeSave);
		return connectPanel;
    }
    public JPanel buildTreePanel() {
		JPanel connectPanel = new JPanel();
		connectPanel.setLayout( new ColumnLayout() );
		//connectPanel.setBorder( new TitledBorder("flags") );

		// Select node displayed in tree node.
		JPanel accessPanel = new JPanel();
		tTreeNodeAccess.addItem("public");
		tTreeNodeAccess.addItem("protected");
		tTreeNodeAccess.addItem("package");
		tTreeNodeAccess.addItem("private");
		accessPanel.add(tTreeNodeAccessLabel);
		accessPanel.add(tTreeNodeAccess);
		connectPanel.add(accessPanel);
		connectPanel.add(tTreeNodeField);
		connectPanel.add(tTreeNodeInner);
	
		//connectPanel.add(tRootNodeDisp);
		//connectPanel.add(tTreeNodeParam);
		connectPanel.add(createFontPanel(tFontName, tFontSize));
		return connectPanel;
    }
	private JPanel createFontPanel(JComboBox aName, JTextField aSize)
	{
		JPanel fontNamePanel = new JPanel();
		try {
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			String[] fonts = ge.getAvailableFontFamilyNames(Locale.getDefault());
			for (int i = 0; i< fonts.length; i++) {
				if (fonts[i].indexOf('.') < 0) {
					aName.addItem(fonts[i]);
				}
			}
		}
		catch (Throwable ex) {
			Debug.warn(ex);
			try {
				// ToolKit.getFontList() is deprecated at 1.2. This code is for 1.1
				String[] fonts = Toolkit.getDefaultToolkit().getFontList();
				for (int i = 0; i < fonts.length; i++) {
					aName.addItem(fonts[i]);
				}
			}
			catch (Throwable exx) {
				Debug.warn(exx);
			}
		}
		fontNamePanel.add(new JLabel(MainWindow.getResource().getString("msg.option.font.name")));
		fontNamePanel.add(aName);
		JPanel fontSizePanel = new JPanel();
		aSize.setColumns(5);
		fontSizePanel.add(new JLabel(MainWindow.getResource().getString("msg.option.font.size")));
		fontSizePanel.add(aSize);
		
		JPanel fontPanel = new JPanel();
		fontPanel.setLayout( new ColumnLayout() );
		fontPanel.setBorder(new TitledBorder("font"));
		fontPanel.add(fontNamePanel);
		fontPanel.add(fontSizePanel);
		return fontPanel;
	}
    public JPanel buildContentPanel() {
		JPanel connectPanel = new JPanel();
		connectPanel.setLayout( new ColumnLayout() );
		//connectPanel.setBorder( new TitledBorder("flags") );

		connectPanel.add(cSrcColor);
		connectPanel.add(cSrcDoc);
		connectPanel.add(cTagButton);
		connectPanel.add(createFontPanel(cFontName, cFontSize));
		
		return connectPanel;
    }
    public JPanel buildParsePanel() {
		JPanel connectPanel = new JPanel();
		connectPanel.setLayout( new ColumnLayout() );
		//connectPanel.setBorder( new TitledBorder("flags") );

		connectPanel.add(docAdd);
		connectPanel.add(docCheck);
		connectPanel.add(docRepare);
		connectPanel.add(docAddEx);
		connectPanel.add(docAddParam);
		//connectPanel.add(docExPkg);
		connectPanel.add(inParse);
		return connectPanel;
    }



    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
		Dimension size = this.getSize();
		screenSize.height = screenSize.height/2;
		screenSize.width = screenSize.width/2;
		size.height = size.height/2;
		size.width = size.width/2;
		int y = screenSize.height - size.height;
		int x = screenSize.width - size.width;
		this.setLocation(x,y);
    }

    public void CancelPressed() {
        this.setVisible(false);
    }

    public void OKPressed() {
        this.setVisible(false);
		// reflect to CurrentProperties
		CurrentProperties props = CurrentProperties.getInstance();
		props.wTooltipDisp = wTooltipDisp.isSelected();
		props.wTooltipParam = wTooltipParam.isSelected();
		props.wInvalidColor = wInvalidColor.isSelected();
		props.wModifiedColor = wModifiedColor.isSelected();
		props.tRootNodeDisp = tRootNodeDisp.isSelected();
		props.tTreeNodeParam = tTreeNodeParam.isSelected();
		props.tTreeNodeAccess = tTreeNodeAccess.getSelectedIndex();
		props.tTreeNodeField = tTreeNodeField.isSelected();
		props.tTreeNodeInner = tTreeNodeInner.isSelected();
		try {
			props.treefont = new Font((String)tFontName.getSelectedItem(),
							  Font.PLAIN,
							  Integer.parseInt(tFontSize.getText()));
		}
		catch(NumberFormatException ex) {
			props.treefont = new Font((String)tFontName.getSelectedItem(),
							  Font.PLAIN,
							  props.treefont.getSize());
		}
		props.cSrcColor = cSrcColor.isSelected();
		props.cSrcDoc = cSrcDoc.isSelected();
		props.cTagButton = cTagButton.isSelected();
		try {
			props.cfont = new Font((String)cFontName.getSelectedItem(),
							  Font.PLAIN,
							  Integer.parseInt(cFontSize.getText()));
		}
		catch(NumberFormatException ex) {
			props.cfont = new Font((String)cFontName.getSelectedItem(),
							  Font.PLAIN,
							  props.cfont.getSize());
		}
		props.docAdd = docAdd.isSelected();
		props.docAddEx = docAddEx.isSelected();
		props.docAddParam = docAddParam.isSelected();
		props.docCheck = docCheck.isSelected();
		props.docRepare = docRepare.isSelected();
		props.docExPkg = docExPkg.isSelected();
		props.outJdh = outJdh.isSelected();
		props.reflectBeforeSave = reflectBeforeSave.isSelected();
		props.inParse = inParse.isSelected();
		CurrentProperties.firePropertyChanged();
    }

	public void setVisible(boolean display)
	{
		if (display) {
			// retrieve current settings
			CurrentProperties props = CurrentProperties.getInstance();
			wTooltipDisp.setSelected(props.wTooltipDisp);
			wTooltipParam.setSelected(props.wTooltipParam);
			wInvalidColor.setSelected(props.wInvalidColor);
			wModifiedColor.setSelected(props.wModifiedColor);
			tRootNodeDisp.setSelected(props.tRootNodeDisp);
			tTreeNodeParam.setSelected(props.tTreeNodeParam);
			tTreeNodeAccess.setSelectedIndex(props.tTreeNodeAccess);
			tTreeNodeField.setSelected(props.tTreeNodeField);
			tTreeNodeInner.setSelected(props.tTreeNodeInner);
			tFontSize.setText(Integer.toString(props.treefont.getSize()));
			tFontName.setSelectedItem(props.treefont.getName());
			cSrcColor.setSelected(props.cSrcColor);
			cSrcDoc.setSelected(props.cSrcDoc);
			cTagButton.setSelected(props.cTagButton);
			cFontSize.setText(Integer.toString(props.cfont.getSize()));
			cFontName.setSelectedItem(props.cfont.getName());
			docAdd.setSelected(props.docAdd);
			docAddEx.setSelected(props.docAddEx);
			docAddParam.setSelected(props.docAddParam);
			docCheck.setSelected(props.docCheck);
			docRepare.setSelected(props.docRepare);
			docExPkg.setSelected(props.docExPkg);
			outJdh.setSelected(props.outJdh);
			reflectBeforeSave.setSelected(props.reflectBeforeSave);
			inParse.setSelected(props.inParse);
		}
		super.setVisible(display);
	}
	
	JButton ok = new JButton(MainWindow.getResource().getString("button.ok"));
	JButton cancel = new JButton(MainWindow.getResource().getString("button.cancel"));
	JButton save = new JButton(MainWindow.getResource().getString("button.save"));
	//JLabel fontNameLabel = new JLabel(MainWindow.getResource().getString("msg.option.font.name"));
	//JLabel fontSizeLabel = new JLabel(MainWindow.getResource().getString("msg.option.font.size"));
	JLabel tTreeNodeAccessLabel = new JLabel(MainWindow.getResource().getString("msg.option.t.treenode.access"));
	
	JCheckBox wTooltipDisp = new JCheckBox(MainWindow.getResource().getString("msg.option.w.tooltip.display"));
	JCheckBox wTooltipParam = new JCheckBox(MainWindow.getResource().getString("msg.option.w.tooltip.withparam"));
	JCheckBox wInvalidColor = new JCheckBox(MainWindow.getResource().getString("msg.option.w.invalid.color"));
	JCheckBox wModifiedColor = new JCheckBox(MainWindow.getResource().getString("msg.option.w.modified.color"));
	JCheckBox tRootNodeDisp = new JCheckBox(MainWindow.getResource().getString("msg.option.t.rootnode.display"));
	JCheckBox tTreeNodeParam = new JCheckBox(MainWindow.getResource().getString("msg.option.t.treenode.withparam"));
	JComboBox tTreeNodeAccess = new JComboBox();
	JCheckBox tTreeNodeField = new JCheckBox(MainWindow.getResource().getString("msg.option.t.treenode.field"));
	JCheckBox tTreeNodeInner = new JCheckBox(MainWindow.getResource().getString("msg.option.t.treenode.inner"));
	JTextField tFontSize = new JTextField();
	JComboBox tFontName = new JComboBox();
	JCheckBox cSrcColor = new JCheckBox(MainWindow.getResource().getString("msg.option.c.source.color"));
	JCheckBox cSrcDoc = new JCheckBox(MainWindow.getResource().getString("msg.option.c.source.withdoc"));
	JCheckBox cTagButton = new JCheckBox(MainWindow.getResource().getString("msg.option.c.tagbutton.display"));
	JTextField cFontSize = new JTextField();
	JComboBox cFontName = new JComboBox();
	JCheckBox docAdd = new JCheckBox(MainWindow.getResource().getString("msg.option.p.javadoc.add"));
	JCheckBox docAddEx = new JCheckBox(MainWindow.getResource().getString("msg.option.p.javadoc.add.ex"));
	JCheckBox docAddParam = new JCheckBox(MainWindow.getResource().getString("msg.option.p.javadoc.add.param"));
	JCheckBox docCheck = new JCheckBox(MainWindow.getResource().getString("msg.option.p.javadoc.check"));
	JCheckBox docRepare = new JCheckBox(MainWindow.getResource().getString("msg.option.p.javadoc.repare"));
	JCheckBox docExPkg = new JCheckBox(MainWindow.getResource().getString("msg.option.p.javadoc.ex.package"));
	JCheckBox outJdh = new JCheckBox(MainWindow.getResource().getString("msg.option.w.output.jdh"));
	JCheckBox reflectBeforeSave = new JCheckBox(MainWindow.getResource().getString("msg.option.w.reflectsave"));
	JCheckBox inParse = new JCheckBox(MainWindow.getResource().getString("msg.option.p.input.parse"));
}

class ColumnLayout implements LayoutManager {

	int xInset = 5;
	int yInset = 5;
	int yGap = 2;

	public void addLayoutComponent(String s, Component c) {}

	public void layoutContainer(Container c) {
		Insets insets = c.getInsets();
		int height = yInset + insets.top;
      
		Component[] children = c.getComponents();
		Dimension compSize = null;
		for (int i = 0; i < children.length; i++) {
			compSize = children[i].getPreferredSize();
			children[i].setSize(compSize.width, compSize.height);
			children[i].setLocation( xInset + insets.left, height);
			height += compSize.height + yGap;
		}

	}

	public Dimension minimumLayoutSize(Container c) {
		Insets insets = c.getInsets();
		int height = yInset + insets.top;
		int width = 0 + insets.left + insets.right;
      
		Component[] children = c.getComponents();
		Dimension compSize = null;
		for (int i = 0; i < children.length; i++) {
			compSize = children[i].getPreferredSize();
			height += compSize.height + yGap;
			width = Math.max(width, compSize.width + insets.left + insets.right + xInset*2);
		}
		height += insets.bottom;
		return new Dimension( width, height);
	}
  
	public Dimension preferredLayoutSize(Container c) {
		return minimumLayoutSize(c);
	}
   
	public void removeLayoutComponent(Component c) {}

}
