package jp.gr.java_conf.a0.jdh.gui;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

import java.io.IOException;
import jp.gr.java_conf.a0.debug.Debug;
import jp.gr.java_conf.a0.debug.Logger;

/**
 * vWFNg̃IvVAt@Cێ
 */
public class ProjectManager
{
	public ProjectManager(ClassTree aTree)
	{
		this.tree = aTree;
	}

	public void newProject()
	{
		if (!this.close()) {
			// close LZꂽ
			return;
		}
	}
	public void open()
	{
		if (!this.close()) {
			// close LZꂽ
			return;
		}
		// open!
		File newFile = MainWindow.getController().showProjectDialog();
		if (newFile == null) {
			return;
		}
		if (!newFile.exists()) {
			MainWindow.getController().showErrorMessage(
					MainWindow.getResource().getString("message.file.notfound") +
					"\n" + newFile.getAbsolutePath());
			return;
		}
		this.projectFile = newFile;
		this.readFromFile();
	}
	// JIT𗘗pĂꍇAڂStackOverflowĂ2ڈȍ~͐ɏł
	private void readFromFile()
	{
		ObjectInputStream oin = null;
		try {
			oin = new ObjectInputStream(new BufferedInputStream(
										  new FileInputStream(this.projectFile)));
			this.tree.setModel((ClassTreeModel)oin.readObject());
			// option ނ̓ǂݏo  ݒ
			CurrentProperties.loadProjectProperties(oin);
		}
		catch (Exception ex) {
			MainController.messageException(ex);
		}
		finally {
			if (oin != null) {
				try {
					oin.close();
				} catch (IOException ex) {
					MainController.messageException(ex);
				}
			}
		}
	}
	public void save()
	{
		if (this.projectFile == null) {
			this.saveAs();
			return;
		}
		this.writeToFile();
	}
	public void saveAs()
	{
		File newFile = MainWindow.getController().showProjectDialog();
		if (newFile == null) {
			return;
		}
		this.projectFile = newFile;
		this.writeToFile();
	}
	
	// JIT𗘗pĂꍇAڂStackOverflowĂ2ڈȍ~͐ɏł
	// this.projectFile must be set.
	private void writeToFile()
	{
		ObjectOutputStream oout = null;
		try {
			Debug.assert(this.projectFile == null);
			oout = new ObjectOutputStream(new BufferedOutputStream(
							 new FileOutputStream(this.projectFile), 2048));
			oout.writeObject(this.tree.getModel());
			CurrentProperties.saveProjectProperties(oout);
			// ɏނƂł
			this.changed = false;
		}
		catch (IOException ex) {
			MainController.messageException(ex);
		}
		finally {
			if (oout != null) {
				try {
					oout.close();
				} catch (IOException ex) {
					MainController.messageException(ex);
				}
			}
		}
	}
	// close LZꂽꍇ̂ false ԂB
	public boolean close()
	{
		if (this.hasChanged()) {
			int result = JOptionPane.showConfirmDialog(MainWindow.getInstance().getFrame(),
						   MainWindow.getResource().getString("message.closeprj.confirm"));
			if (result == JOptionPane.YES_OPTION ) {
				this.save();
			} else if (result == JOptionPane.NO_OPTION ) {
				// do nothing
			} else {
				//CANCEL_OPTION or CLOSED_OPTION
				//return;
				return(false);
			}
		}
		MainWindow.getInstance().getClassTree().clearSelection();
		MainWindow.getInstance().getEditPane().setJavaDocNode(JavaDocNode.DUMMY_NODE);
		ParseThread.getInstance().clear();
		CurrentProperties.loadApplicationProperties();
		this.projectFile = null;
		this.tree.setModel(new ClassTreeModel());
		this.changed = false;
		System.gc();
		return(true);
	}

	//private static void messageString(String aMsg)


	private boolean hasChanged()
	{
		return(this.changed || CurrentProperties.changed);
	}
	public void notifyChanged()
	{
		this.changed = true;
	}

	private final ClassTree tree;
	private boolean changed = false;
	private File projectFile = null; // null̏ꍇ͓͂𑣂B

	private boolean writeOverflow = false;
	private boolean readOverflow = false;

	public ActionListener actionNewProject = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			newProject();
		}
	};
	public ActionListener actionOpen = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			open();
		}
	};
	public ActionListener actionSave = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			save();
		}
	};
	public ActionListener actionSaveAs = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			saveAs();
		}
	};
	public ActionListener actionClose = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			close();
		}
	};
}
