package jp.gr.java_conf.a0.jdh.gui;

import java.util.Stack;
import jp.gr.java_conf.a0.debug.Debug;

/**
 * SourceFileNode𐶐ɁÃXbhɓo^邱ƂŁA
 * ʃXbhŎIɃ\[Xt@CiRgj̃p[XsB
 */
public class ParseThread extends Thread
{
	public void run()
	{
		SourceFileNode aNode = null;
		while (true) {
			aNode = this.popNode();
			if (aNode.isParsing()) {
				this.pushNode(aNode);
				continue;
			}
			aNode.parse();
		}
	}

	public synchronized void pushNode(SourceFileNode aNode)
	{
		//this.nodes.addElement(aNode);
		this.nodes.push(aNode);
		this.notify();
	}
	private synchronized SourceFileNode popNode()
	{
		while (this.nodes.size() == 0) {
			try {
				wait();
			}
			catch (Exception ex) {
				Debug.warn(ex);
			}
		}
		return((SourceFileNode)this.nodes.pop());
	}

	protected synchronized void clear()
	{
		this.nodes.removeAllElements();
	}

	public static ParseThread getInstance()
	{
		return(instance);
	}

	//private final Vector nodes = new Vector();
	private final Stack nodes = new Stack();
	private static ParseThread instance;

	static {
		instance = new ParseThread();
		instance.start();
	}
}
