package jp.gr.java_conf.a0.jdh.gui;

import java.util.ResourceBundle;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
//import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
//import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.KeyStroke;

import jp.gr.java_conf.a0.debug.Debug;


// Shuld change name to MainView ???
public class MainWindow
{
	protected MainWindow()
	{
		this.frame = new JFrame("JDocHelper");
		this.controller = new MainController(this);
		this.frame.addWindowListener(this.controller.windowExit);

		//this.tagTable = new TagTable();
		//this.editPane = new EditPane(this.tagTable);
		this.editPane = new EditPane();

		this.classTree = new ClassTree();
		MainWindow.project = new ProjectManager(this.classTree);
		//JPanel treePanel = new JPanel();
		//treePanel.setLayout( new BorderLayout() );
		//treePanel.add(new JScrollPane(this.classTree) , BorderLayout.CENTER );
		splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
											  //treeScroller,
											  //treePanel,
											  new JScrollPane(this.classTree),
											  this.editPane );
		splitPane.setContinuousLayout(false);
		splitPane.setOneTouchExpandable(true);
		//splitPane.setDividerLocation((double)0.5);
		//splitPane.setLastDividerLocation(250);

		this.frame.getContentPane().add( splitPane );
		this.frame.setJMenuBar(this.createMenuBar());

		this.frame.pack();
		this.loadStaticProperties();
		this.frame.show();
	}

	private void loadStaticProperties()
	{
		StaticProperties staticProps = StaticProperties.getInstance();
		this.frame.setSize(staticProps.winDimension);
		if (staticProps.dividerTree < 0) {
			this.splitPane.setDividerLocation((double)0.4);
		} else {
			this.splitPane.setDividerLocation(staticProps.dividerTree);
		}
		if (staticProps.dividerTable < 0) {
			this.editPane.setDividerLocation((double)0.4);
		} else {
			this.editPane.setDividerLocation(staticProps.dividerTable);
		}
		this.frame.setLocation(staticProps.winLocation);
	}
	
	/**
	 * Creates a menu bar.
	 */
	protected JMenuBar createMenuBar() {
		JMenuItem menuItem = null;
		
		JMenu fileMenu = new JMenu(MainWindow.resource.getString("menu.file")); 
		fileMenu.setMnemonic('F');
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.add"));
		menuItem.addActionListener(this.getClassTree().fileOpen);
		menuItem.setMnemonic('D');
		fileMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.delete"));
		menuItem.addActionListener(this.getClassTree().actionRemove);
		menuItem.setMnemonic('E');
		fileMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.reflect"));
		menuItem.addActionListener(this.getClassTree().actionReflect);
		menuItem.setMnemonic('R');
		fileMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.reflectall"));
		menuItem.addActionListener(this.getClassTree().actionReflectAll);
		menuItem.setMnemonic('L');
		fileMenu.add(menuItem);
		fileMenu.addSeparator();
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.save"));
		menuItem.addActionListener(this.getClassTree().actionSave);
		menuItem.setMnemonic('S');
		fileMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.saveall"));
		menuItem.addActionListener(this.getClassTree().actionSaveAll);
		menuItem.setMnemonic('A');
		fileMenu.add(menuItem);
		fileMenu.addSeparator();
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.file.exit")); 
		menuItem.addActionListener(this.controller.fileExit);
		menuItem.setMnemonic('X');
		fileMenu.add(menuItem); 

		JMenu projectMenu = new JMenu(MainWindow.resource.getString("menu.project"));
		projectMenu.setMnemonic('P');
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.project.new"));
		menuItem.addActionListener(this.project.actionNewProject);
		menuItem.setMnemonic('N');
		projectMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.project.open"));
		menuItem.addActionListener(this.project.actionOpen);
		menuItem.setMnemonic('O');
		projectMenu.add(menuItem);
		// SẴm[hVACYH or t@Ĉ݂ۑiSReflectjH
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.project.save"));
		menuItem.addActionListener(this.project.actionSave);
		menuItem.setMnemonic('S');
		projectMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.project.saveas"));
		menuItem.addActionListener(this.project.actionSaveAs);
		menuItem.setMnemonic('A');
		projectMenu.add(menuItem);
		projectMenu.addSeparator();
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.project.close"));
		menuItem.addActionListener(this.project.actionClose);
		menuItem.setMnemonic('C');
		projectMenu.add(menuItem);
		//projectMenu.addSeparator();
		//menuItem = new JMenuItem(MainWindow.resource.getString("menu.project.history"));
		//menuItem.setMnemonic('H');
		//projectMenu.add(menuItem);

		JMenu optionsMenu = new JMenu(MainWindow.resource.getString("menu.options"));
		optionsMenu.setMnemonic('O');
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.options.setting"));
		menuItem.addActionListener(this.controller.optionProject);
		menuItem.setMnemonic('T');
		optionsMenu.add(menuItem);
		optionsMenu.addSeparator();
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.options.save"));
		menuItem.addActionListener(this.controller.optionSave);
		optionsMenu.add(menuItem);
		menuItem.setMnemonic('S');
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.options.default"));
		menuItem.addActionListener(this.controller.optionDefault);
		menuItem.setMnemonic('D');
		optionsMenu.add(menuItem);


		JMenu helpMenu = new JMenu(MainWindow.resource.getString("menu.help"));
		helpMenu.setMnemonic('H');
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.help.version"));
		menuItem.addActionListener(this.controller.showVersion);
		menuItem.setMnemonic('V');
		helpMenu.add(menuItem);
		menuItem = new JMenuItem(MainWindow.resource.getString("menu.help.resource"));
		menuItem.addActionListener(this.controller.showResource);
		menuItem.setMnemonic('R');
		helpMenu.add(menuItem);
		
		// Create a menu bar
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(fileMenu);
		menuBar.add(projectMenu);
		menuBar.add(optionsMenu);
		menuBar.add(helpMenu);

		return menuBar;
	}
	
	
//
	/**
	 * t@Cۑ邩ǂāAI
	 */
	public void exit()
	{
		if (!getProject().close()) {
			// 
			return;
		}
		StaticProperties staticProps = StaticProperties.getInstance();
		staticProps.winDimension = this.frame.getSize();
		staticProps.dividerTree = this.splitPane.getDividerLocation();
		staticProps.dividerTable = this.editPane.getDividerLocation();
		staticProps.winLocation = this.frame.getLocation();
		staticProps.save();
		System.exit(0);
	}
	
// Accessor
	public JFrame getFrame()	{return(this.frame);}
	public ClassTree getClassTree()	{return(this.classTree);}
	//public ClassTreeModel getClassTreeModel()	{return(this.classTreeModel);}
	public EditPane getEditPane()	{return(this.editPane);}
	//public TagTable getTagTable() {return(this.tagTable);}
	public static MainWindow getInstance()
	{
		if (MainWindow.instance == null) {
			MainWindow.instance = new MainWindow();
		}
		return(MainWindow.instance);
	}
	public static ResourceBundle getResource()	{return(MainWindow.resource);}
	public static MainController getController() {return(instance.controller);}
	public static ProjectManager getProject()	{return(MainWindow.project);}

// Main
	public static void main(String[] args) 
	{
		MainWindow.resource = ResourceBundle.getBundle(
				 "jp.gr.java_conf.a0.jdh.Resource");
		if (MainWindow.resource == null) {
			System.out.println("Resource.properties is not found.");
			return;
		}
		StaticProperties.load();
		CurrentProperties.loadApplicationProperties();
 
		MainWindow main = getInstance();
		//SwingUtilities.updateComponentTreeUI(main.getFrame());
		
		// for test
		if (Debug.DEBUG_MODE) {
			main.classTree.getClassTreeModel().addFile(
				   //new java.io.File("\\work\\tmp\\ClassLoader.java"));
				   new java.io.File("\\work\\tmp\\Logger.java"));
			//SwingUtilities.updateComponentTreeUI(main.getFrame());
			//main.frame.repaint();
		}
	}
	

// Fields
	private final JFrame frame;
	private ClassTree classTree;
	private MainController controller;
	private EditPane editPane;
	private JSplitPane splitPane;
	
	private static MainWindow instance;
	private static ResourceBundle resource;
	private static ProjectManager project;
}
