package jp.gr.java_conf.a0.jdh.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
//import javax.swing.SwingUtilities;
import javax.swing.JOptionPane;

import jp.gr.java_conf.a0.debug.Debug;
import jp.gr.java_conf.a0.debug.Logger;


public class MainController
{
	public MainController(MainWindow aWindow)
	{
		this.main = aWindow;

	}

	/**
	 * t@CI_CAO\Iꂽt@C̃t@CԂB
	 * LZAt@CIȂꍇɂ null ԂB
	 */
	protected File showOpenDialog()
	{
Debug.println("shwoOpenDialog()");
		int result = this.getFileChooser().showOpenDialog(this.main.getFrame());
		//Debug.println("fileOpen: result: " + result);
		if (result == JFileChooser.APPROVE_OPTION) {
			return(getFileChooser().getSelectedFile());
		}
		return(null);
	}
	/**
	 * t@CI_CAO\Iꂽt@C̃t@CԂB
	 * LZAt@CIȂꍇɂ null ԂB
	 */
	protected File showProjectDialog()
	{
Debug.println("shwoProjectDialog()");
		int result = this.getProjectFileChooser().showOpenDialog(this.main.getFrame());
		if (result != JFileChooser.APPROVE_OPTION) {
			return(null);
		}
		File projectFile = this.getProjectFileChooser().getSelectedFile();
		if (!projectFile.getName().toLowerCase().endsWith(".jdp")) {
			projectFile  = new File(projectFile.getName() + ".jdp");
			this.getProjectFileChooser().setSelectedFile(projectFile);
		}
		return(projectFile);
	}

	protected void showVersionDialog()
	{
		JOptionPane.showMessageDialog(MainWindow.getInstance().getFrame(),
						  VERSION_INFO,
						  MainWindow.getResource().getString("message.title.version"),
						  JOptionPane.PLAIN_MESSAGE);
	}
	protected void showResourceDialog()
	{
		JOptionPane.showMessageDialog(MainWindow.getInstance().getFrame(),
						  "   Total: " + Runtime.getRuntime().totalMemory() + ", " +
						  "\n   Free: " + Runtime.getRuntime().freeMemory(),
						  MainWindow.getResource().getString("message.title.resource"),
						  JOptionPane.PLAIN_MESSAGE);
	}
	public static void showInformationDialog(String aMsg)
	{
		JOptionPane.showMessageDialog(MainWindow.getInstance().getFrame(),
						  aMsg,
						  MainWindow.getResource().getString("message.title.info"),
						  JOptionPane.INFORMATION_MESSAGE);
	}
	public static void showErrorMessage(String aMsg)
	{
		JOptionPane.showMessageDialog(MainWindow.getInstance().getFrame(),
						  aMsg,
						  MainWindow.getResource().getString("message.title.error"),
						  JOptionPane.ERROR_MESSAGE);
	}
	public static void messageException(Exception ex)
	{
		JOptionPane.showMessageDialog(MainWindow.getInstance().getFrame(),
						  ex.toString(),
						  MainWindow.getResource().getString("message.title.error"),
						  JOptionPane.ERROR_MESSAGE);
		Logger.LOG.record(ex);
	}
	
	public ActionListener showVersion = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			showVersionDialog();
		}
	};
	public ActionListener showResource = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			showResourceDialog();
		}
	};
	
	public ActionListener fileExit = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			MainController.this.main.exit();
		}
	};

	public WindowAdapter windowExit = new WindowAdapter() {
		public void windowClosing( WindowEvent e ) {
			 //System.exit( 0 );
			MainController.this.main.exit();
		}
	 };

	public ActionListener optionProject = new ActionListener()
	{
		public void actionPerformed(ActionEvent ae)
		{
			if (propDlg == null) {
				propDlg = new PropertyDialog(MainController.this.main);
			}
			propDlg.setVisible(true);
		}
	};
	public ActionListener optionDefault = new ActionListener()
	{
		public void actionPerformed(ActionEvent ae)
		{
			CurrentProperties.defaultProperties();
			showInformationDialog(MainWindow.getResource().getString("message.default.setting"));
		}
	};
	public ActionListener optionSave = new ActionListener()
	{
		public void actionPerformed(ActionEvent ae)
		{
			try {
				CurrentProperties.saveApplicationPropeties();
				showInformationDialog(MainWindow.getResource().getString("message.save.setting"));
			}
			catch (Exception ex) {
				messageException(ex);
			}
		}
	};

// Accessor
	private JFileChooser getFileChooser()
	{
		if (this.fileChooser == null) {
			this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
			this.fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
//			this.fileChooser.setMultiSelectionEnabled(true);
			ExtensionFileFilter filter = new ExtensionFileFilter();
			filter.addExtension("java");
			filter.addExtension("jdh");
			this.fileChooser.setFileFilter(filter);
		}
		return(this.fileChooser);
	}
	private JFileChooser getProjectFileChooser()
	{
		if (this.projectFileChooser == null) {
			this.projectFileChooser = new JFileChooser(System.getProperty("user.dir"));
			this.projectFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			ExtensionFileFilter filter = new ExtensionFileFilter();
			filter.addExtension("jdp");
			this.projectFileChooser.setFileFilter(filter);
		}
		return(this.projectFileChooser);
	}

// Fields
	/*protected*/private final MainWindow main;
	/** ʏ̃t@CJ߂̃_CAO */
	private JFileChooser fileChooser;
	/** vWFNgt@CJij߂̃_CAOB".jdp"ƂgqB */
	private JFileChooser projectFileChooser;
	/** o[W_CAOɕ\ */
	private static final String[] VERSION_INFO = {
		"JDocHelper Version 0.8",
		"Copyright (C) 2001 Hiroyuki Kurokawa",
		"",
		"http://homepage2.nifty.com/a0/jdh/index.html",
		"hiroyuki.kurokawa@nifty.com"
	};
	private PropertyDialog propDlg;
}
