package jp.gr.java_conf.a0.jdh.gui;

import java.util.Hashtable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentTag;
import jp.gr.java_conf.a0.jdh.parser.source.JavaDocHolder;

import jp.gr.java_conf.a0.debug.Debug;

//public class JavaDocNode extends ClassTreeNode
public abstract class JavaDocNode extends ClassTreeNode
{
	public JavaDocNode(JavaDocHolder aHolder, SourceFileNode aFileNode)
	{
		super(aHolder);
		this.fileNode = aFileNode;
	}
//	private JavaDocHolder javaDoc;

	protected void checkState()
	{
		//Debug.println("JavaDocNode.checkState(): START:"+getSignature());	
		CommentTag tag = null;
		int state = 0;
		Enumeration tags = this.getCommentBody().getAllTags();
		while (tags.hasMoreElements()) {
			tag = (CommentTag)tags.nextElement();
			state = tag.getState();
			if ((state & STATE_CHANGED) != 0) {
				this.setChanged(true);
				if (this.isInvalid()) {
					// ȏstateς邱Ƃ͂Ȃ
					break;
				}
			}
			if ((state & STATE_INVALID) != 0) {
				this.setInvalid(true);
				if (this.isChanged()) {
					// ȏstateς邱Ƃ͂Ȃ
					break;
				}
			}
		}
		if (state == STATE_OK) {
			this.releaseCommentBody();// \[X
		}

		// qm[h`FbN
		Enumeration enum = this.children();
		while (enum.hasMoreElements()) {
			((JavaDocNode)enum.nextElement()).checkState();
		}
	}
	protected void checkStateInvalid()
	{
		this.setInvalid(false);
		CommentTag tag = null;
		int state = 0;
		Enumeration tags = this.getCommentBody().getAllTags();
		while (tags.hasMoreElements()) {
			tag = (CommentTag)tags.nextElement();
Debug.println("JavaDocNode.checkStaeInvalid(): tag: " + tag.getClass().getName());
state = tag.getState();
			if ((state & STATE_INVALID) != 0) {
				this.setInvalid(true);
				break;
			}
		}
		this.fileNode.setInvalid(this.isInvalid(), this);
	}
	public String getToolTipText()
	{
		if (CurrentProperties.displaysTooltipParam()) {
			// ̏܂߂ĕ\
			return(getSignature());
		} else {
			return(toString());
		}
	}
	public Icon getIcon(boolean anExpanded)
	{
		return(ICONS[this.getAccessFlag() & 0x07]);
	}
	protected void setInvalid(boolean aFlag)
	{
		super.setInvalid(aFlag);
		this.fileNode.setInvalid(aFlag, this);
	}
	/*
	protected void setInvalid(boolean aFlag, CommentTag aTag)
	{
		if (aFlag) {
			this.invalidTags.put(aTag, aTag);
			this.fileNode.setInvalid(aFlag, this);
		} else {
			this.invalidTags.remove(aTag);
			if (!this.isInvalid()) {
				this.fileNode.setInvalid(false, this);
			}
		}
	}
	public boolean isInvalid() {return(this.invalidTags.size() != 0);}
	*/
	protected void setChanged(boolean aFlag)
	{
		super.setChanged(aFlag);
		this.fileNode.setChanged(aFlag, this);
	}
	//protected void notifyReflecting()
	protected void reflect()
	{
		this.reflectToToken();
		this.setChanged(false);
	}
	private void reflectToToken()
	{
		this.getJavaDocHolder().reflectToJavaDocToken();
		Enumeration tags = this.getCommentBody().getAllTags();
		while (tags.hasMoreElements()) {
			((CommentTag)tags.nextElement()).setFlag(STATE_CHANGED, false);
		}
	}
	protected void save()
	{
		this.getSourceFileNode().save();
	}

	
// Accessor
	public int getAccessFlag()		{return(this.getJavaDocHolder().getAccessFlag());}
	/** ToolTipManager Ăяo */
	public String getSignature()	{return(this.getJavaDocHolder().getSignature());}
	public JavaDocHolder getJavaDocHolder()	{return((JavaDocHolder)super.userObject);}
	public CommentBody getCommentBody()	{return(this.getJavaDocHolder().getCommentBody());}
	private void releaseCommentBody(){this.getJavaDocHolder().releaseCommentBody();}
	protected SourceFileNode getSourceFileNode(){return(this.fileNode);}
	

// Fields
	private final SourceFileNode fileNode;
	//private final Hashtable invalidTags = new Hashtable();
	
	public static final int STATE_OK = CommentTag.STATE_OK;
	public static final int STATE_INVALID = (CommentTag.STATE_INVALID |
											 CommentTag.STATE_CONTENTS_CHANGED);
	public static final int STATE_CHANGED = (CommentTag.STATE_EDITED |
											 CommentTag.STATE_INSERTED |
											 CommentTag.STATE_EXTRA);

	private static final ImageIcon[] ICONS = {
/*		new ImageIcon("images/public.gif"),
		new ImageIcon("images/protected.gif"),
		new ImageIcon("images/package.gif"),
		new ImageIcon("images/private.gif"),
		new ImageIcon("images/public_f.gif"),
		new ImageIcon("images/protected_f.gif"),
		new ImageIcon("images/package_f.gif"),
		new ImageIcon("images/private_f.gif")
*/		StaticProperties.getImage("images/public.gif"),
		StaticProperties.getImage("images/protected.gif"),
		StaticProperties.getImage("images/package.gif"),
		StaticProperties.getImage("images/private.gif"),
		StaticProperties.getImage("images/public_f.gif"),
		StaticProperties.getImage("images/protected_f.gif"),
		StaticProperties.getImage("images/package_f.gif"),
		StaticProperties.getImage("images/private_f.gif")
	};
	
	// XXX
	public static final JavaDocNode DUMMY_NODE = new JavaDocNode(JavaDocHolder.DUMMY_HOLDER, null) {
		protected void checkState(){}
		public int getAccessFlag()	
		{
			return(0);
		}
		public String getSignature()
		{
			return("");
		}
		public JavaDocHolder getJavaDocHolder()
		{
			return(JavaDocHolder.DUMMY_HOLDER);
		}
		public CommentBody getCommentBody()
		{
			//Debug.println("getCommentBody(): " + this.body);
			//return(this.body);
			return(CommentBody.DUMMY_BODY);
		}
		//private final CommentBody body = new CommentBody();
	};
}
