package jp.gr.java_conf.a0.jdh.gui;

import java.awt.*;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.*;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.*;

import jp.gr.java_conf.a0.debug.Debug;


import javax.swing.text.*;
import javax.swing.text.html.*;
import java.util.*;
import java.awt.event.ActionEvent;

/**
 * ẼyCB
 */
public class EditPane extends JPanel implements PropertyChangeListener
{
	public EditPane()
	{
		super(false);	// not double buffered.
		super.setLayout(new BorderLayout());

		this.textArea = new JTextArea();
		//JScrollPane textScroller = new JScrollPane(this.textArea);
		JScrollPane textScroller = new JScrollPane();
		textScroller.getViewport().add(this.textArea);
		textScroller.getViewport().setBackingStoreEnabled(true);
		//textScroller.doLayout();
		
		this.htmlView = new JEditorPane("text/html", "");
		this.htmlView.setEditable(false);
		this.htmlView.addFocusListener(new HtmlFocusListener());
		JScrollPane htmlScroller = new JScrollPane();
		htmlScroller.getViewport().add(this.htmlView);
		htmlScroller.getViewport().setBackingStoreEnabled(true);
		//htmlScroller.doLayout();

		this.sourceView = new JTextArea();
		this.sourceView.setEditable(false);
		JScrollPane sourceScroller = new JScrollPane();
		sourceScroller.getViewport().add(this.sourceView);
		sourceScroller.getViewport().setBackingStoreEnabled(true);
		//sourceScroller.doLayout();
		

		JTabbedPane tabbedPane = new JTabbedPane();
		tabbedPane.add(MainWindow.getResource().getString("tab.title.edit"), textScroller);
		tabbedPane.add(MainWindow.getResource().getString("tab.title.html"), htmlScroller);
		tabbedPane.add(MainWindow.getResource().getString("tab.title.source"), sourceScroller);


		this.table = new TagTable();
		JScrollPane tableScroller = new JScrollPane(this.table);
		//tableScroller.setMinimumSize( new Dimension( 30, 10 ) );
		tableScroller.setBackground( Color.white );

		splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
												tabbedPane, tableScroller);
		splitPane.setContinuousLayout(false);
		splitPane.setOneTouchExpandable(false);
		//splitPane.setDividerLocation((double)0.75);
		super.add(splitPane);
		this.buttonPanel = new TagTableButtonPanel(this.table);
		super.add(buttonPanel, BorderLayout.SOUTH);

		this.setProperties();
		CurrentProperties.addPropertyChangeListener(this);
	}
	private void setProperties()
	{
		this.textArea.setFont(CurrentProperties.getEditFont());  //OK
		this.sourceView.setFont(CurrentProperties.getSourceFont());
		//this.table.setFont(CurrentProperties.getTableFont());// XXX: doesn't work
		//this.table.updateFont(CurrentProperties.getTableFont()); // XXX
		this.buttonPanel.setVisible(CurrentProperties.displaysTagButton());
	}

	// for PropertyChangeListener
	public void notifyPropertyChanged()
	{
		this.setProperties();
		this.repaint();
	}
	
	public void setJavaDocNode(JavaDocNode aNode)
	{
		//new Throwable(aNode.toString()).printStackTrace();		
		//Debug.println("aNode:" + aNode);
 		if (this.node == aNode) {
			return;
		}
		if (!this.node.getCommentBody().getBody().equals(this.textArea.getText())) {
			Debug.println("EditPane.setJavaDocNode(): reflect! body");
			this.node.getCommentBody().setBody(this.textArea.getText());
			this.node.setChanged(true);
		}

		this.node = aNode;
		this.textArea.setText(aNode.getCommentBody().getBody());
		this.htmlView.setText(this.textArea.getText());
		this.sourceView.setText(aNode.getJavaDocHolder().getSource());
		this.table.setJavaDocNode(aNode);
		
		// ĕ`
		this.repaint();
	}
	JavaDocNode getJavaDocNode()	{return(this.node);}
	//TagTabje getTagTable(){return(this.table);}

    protected int getDividerLocation() {return(this.splitPane.getDividerLocation());}
    protected void setDividerLocation(int aLoc) {this.splitPane.setDividerLocation(aLoc);}
    protected void setDividerLocation(double aLoc) {this.splitPane.setDividerLocation(aLoc);}
	
	private JavaDocNode node = JavaDocNode.DUMMY_NODE;

	private JTextArea textArea;
	private JEditorPane htmlView;
	private JTextArea sourceView;
	private TagTable table;
	private TagTableButtonPanel buttonPanel;
	private JSplitPane splitPane;

	// textArea  htmlView ̐Ƃ邽߂ɗpB
	//private boolean textChanged = false;
	
	
/*	private class TabChangeListener implements ChangeListener
	{
		// e  JTabbedPane
		public void stateChanged(ChangeEvent e)
		{
			Debug.println("stateChange(): " + e.getSource());
			if (e.getSource().equals(EditPane.this.htmlView)) {
				EditPane.this.htmlView.setText(EditPane.this.textArea.getText());
			}
		}
	}
*/	private class HtmlFocusListener implements FocusListener
	{
		public void focusGained(FocusEvent e)
		{
			JEditorPane ed = (JEditorPane)e.getComponent();
			if (!ed.getText().equals(EditPane.this.textArea.getText())) {
				ed.setText(EditPane.this.textArea.getText());
				//this.htmlView.setText(this.textArea.getText());
			}
		}
		public void focusLost(FocusEvent e)	{}
	}
}
