package jp.gr.java_conf.a0.jdh.gui;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Enumeration;
import javax.swing.ToolTipManager;

import jp.gr.java_conf.a0.debug.Debug;


public class CurrentProperties implements Serializable
{
	public static void defaultProperties()
	{
		INSTANCE = new CurrentProperties();
		INSTANCE.firePropertyChanged();
	}
	public static void loadProjectProperties(ObjectInputStream anIn)
		throws IOException, ClassNotFoundException
	{
		INSTANCE = (CurrentProperties)anIn.readObject();
		firePropertyChanged();
		changed = false;
	}
	public static void saveProjectProperties(ObjectOutputStream anOut) throws IOException
	{
		anOut.writeObject(INSTANCE);
		changed = false;
	}
	public static void loadApplicationProperties() //throws IOException
	{
		try {
			String fname = StaticProperties.getRootDir() + PROJECT_PROPFILE;
			File propfile = new File(fname);
			if (!propfile.exists()) {
				Debug.println("Property file not found: " + fname);
				//saveApplicationPropeties();
				return;
			}
			ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(
										  new FileInputStream(propfile)));
			INSTANCE = (CurrentProperties)oin.readObject();
			firePropertyChanged();
			changed = false;
			oin.close();
		}
		catch (Exception ex) {
			//Debug.warn(ex);
			MainController.messageException(ex);
		}
	}
	public static void saveApplicationPropeties() throws IOException
	{
		String fname = StaticProperties.getRootDir() + PROJECT_PROPFILE;
		File propfile = new File(fname);
		ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(
										  new FileOutputStream(propfile)));
		oout.writeObject(INSTANCE);
		oout.close();
		changed = false;
	}

	
	protected static void firePropertyChanged()
	{
		Enumeration enum = LISTENER_SET.elements();
		while (enum.hasMoreElements()) {
			((PropertyChangeListener)enum.nextElement()).notifyPropertyChanged();
		}
		ToolTipManager.sharedInstance().setEnabled(INSTANCE.wTooltipDisp);
		changed = true;
	}
	public static void addPropertyChangeListener(PropertyChangeListener aListener)
	{
		LISTENER_SET.put(aListener, aListener);
	}
	public static void removePropertyChangeListener(PropertyChangeListener aListener)
	{
		LISTENER_SET.remove(aListener);
	}
	
// Accessor
	protected static CurrentProperties getInstance()	{return(INSTANCE);}
	// Font
	//public static Font getFont() {return(INSTANCE.font);}
	public static Font getEditFont() {return(INSTANCE.cfont);}    // ҏW^uptHg
	public static Font getHtmlFont() {return(INSTANCE.cfont);}    // HTML^uptHg
	public static Font getSourceFont() {return(INSTANCE.cfont);}  // \[XR[h^uptHg
	public static Font getTreeFont() {return(INSTANCE.treefont);}
	public static Font getTableFont() {return(INSTANCE.tablefont);}
	// Color
	public static Color getColorInvalidState()	{return(INSTANCE.colorInvalidState);}
	public static Color getColorTableForeground()	{return(INSTANCE.colorTableForeground);}
	public static Color getColorTableBackground()	{return(INSTANCE.colorTableBackground);}
	public static Color getColorTreeForeground()	{return(INSTANCE.colorTreeForeground);}
	public static Color getColorTreeBackground()	{return(INSTANCE.colorTreeBackground);}
	// Flags
	public static boolean displaysTooltip() {return(INSTANCE.wTooltipDisp);}
	public static boolean displaysTooltipParam() {return(INSTANCE.wTooltipParam);}
	public static boolean colorsInvalidNode() {return(INSTANCE.wInvalidColor);}
	public static boolean colorsModifiedNode() {return(INSTANCE.wModifiedColor);}
	public static boolean displaysRootNode() {return(INSTANCE.tRootNodeDisp);}
	public static boolean displaysRootNodeParam() {return(INSTANCE.tTreeNodeParam);}
	public static boolean displaysNodeField() {return(INSTANCE.tTreeNodeField);}
	public static boolean displaysInnerClass() {return(INSTANCE.tTreeNodeInner);}
	public static boolean colorsSourceCode() {return(INSTANCE.cSrcColor);}
	public static boolean displaysJavaDoc() {return(INSTANCE.cSrcDoc);}
	public static boolean displaysTagButton() {return(INSTANCE.cTagButton);}
	public static boolean addsJavaDoc() {return(INSTANCE.docAdd);}
	public static boolean checksJavaDoc() {return(INSTANCE.docCheck);}
	public static boolean reparesJavaDoc() {return(INSTANCE.docRepare);}
	public static boolean exceptWithPackage() {return(INSTANCE.docExPkg);}
	public static boolean parsesWhenLoaded()	{return(INSTANCE.inParse);}
	//public static boolean parsesAllWhenOpened()	{return(INSTANCE.allParse);}
	public static boolean getParseAllWhenSourceOpened()	{return(INSTANCE.docCheck);}//XXX
	public static boolean preservesOrginalFile()	{return(INSTANCE.outJdh);}
	public static boolean reflectsBeforeSave()	{return(INSTANCE.reflectBeforeSave);}
	// num
	//public static int getFontSize() {return(INSTANCE.fontSize);}
	public static int getTreeNodeAccess() {return(INSTANCE.tTreeNodeAccess);}
	// String
	public static String getFileHeader() {return(INSTANCE.fileHeader);}
	public static String[] getTags() {return(INSTANCE.tags);}

	/*
	public static boolean getProperty(BoolProperty aProp)
	{
		Boolean b = (Boolean)PROPS.get(aProp);
		if (b != null) {
			return(b.booleanValue);
		}
		return(aProp.getDefault());
	}
	*/

	
// Fields
// Font
	// Dialog, DialogInput, Monospaced, Serif, SansSerif, or Symbol.
	//protected Font font = new Font("monospaced", Font.PLAIN, 12);
	//protected Font font = new Font("DialogInput", Font.PLAIN, 10);
	protected Font cfont = new Font("Monospaced", Font.PLAIN, 12);
	protected Font treefont = new Font("Dialog", Font.PLAIN, 12);
	protected Font tablefont = new Font("Dialog", Font.PLAIN, 24);
// size
	//protected int fontSize = 10;
// Color
	protected Color colorInvalidState = Color.red;
	protected Color colorTableForeground = Color.black;
	protected Color colorTableBackground = Color.white;
	protected Color colorTreeForeground = Color.black;
	protected Color colorTreeBackground = Color.white;
// Flags
	//protected boolean parseWhenLoaded = true;
	protected boolean parseAllWhenSourceOpened = true;//false;// ̓IvVłȂAtruełׂHA߂JavaDocCommentn߂ƂȂǂɗLpiKSẴm[hQƂĂ̂ŁjB
	/** true: .javat@C㏑Bfalse: .jdh t@C𓯂fBNgɍ쐬B */
	//protected boolean overwriteWhenReflect = false;
// String
	//protected String fileHeader = "";
	protected String fileHeader = "/*\n" +
		" * JDocHelper) Version 0.8\n"+
		" *   Copyright(C) 2001 Hiroyuki Kurokawa\n"+
		" */\n";
	protected String[] tags = {
		"@param",
		"@return",
		"@exception",
		"@see",
		"@version",
		"@since"
	};
// From PropertyDialog
	boolean wTooltipDisp = true;
	boolean wTooltipParam = true;
	boolean wInvalidColor = true;
	boolean wModifiedColor = true;
	boolean tRootNodeDisp = true;
	boolean tTreeNodeParam = true;
	//JLabel tTreeNodeAccessLabel;
	int tTreeNodeAccess = 1; // more than protected.  0:public, 1: protected, 2:pkg, 3:private
	boolean tTreeNodeField = true;
	boolean tTreeNodeInner = true;
	//JTextField tFontSize;
	//JComboBox tFontName;
	boolean cSrcColor = false;
	boolean cSrcDoc = false;
	boolean cTagButton = true;
	//JTextField cFontSize;
	//JComboBox cFontName;
	boolean docAdd = true;
	boolean docAddEx = true;
	boolean docAddParam = true;
	boolean docCheck = true;
	boolean docRepare = true;
	boolean docExPkg = false;
	boolean outJdh = true;
	boolean inParse = true;
	boolean reflectBeforeSave = true;

	
	public static boolean changed = false;

	/** vpeBύXꂽƂɒʒm󂯂IuWFNg̏W */
	private static final Hashtable LISTENER_SET = new Hashtable();
	/** SINGLETON INSTANCE */
	private static CurrentProperties INSTANCE = new CurrentProperties();
	private static final String PROJECT_PROPFILE = "properties";
	
	private static final long serialVersionUID = 7883223291891325039L;
}
