package jp.gr.java_conf.a0.jdh.gui;

import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;

import jp.gr.java_conf.a0.debug.Debug;

public abstract class ClassTreeNode extends DefaultMutableTreeNode
{
	public ClassTreeNode(Object anObj)
	{
		super(anObj);
	}
	
	//protected void fireTreeWillExpand()
	
// AbstractMethods
	public abstract String getToolTipText();
	public abstract Icon getIcon(boolean anExpanded);
	//protected abstract void reflect();
	//protected abstract void save();

	protected void reflect()
	{
		Enumeration enum = children();
		while (enum.hasMoreElements()) {
			((ClassTreeNode)enum.nextElement()).reflect();
		}
	}
	protected void save()
	{
		Enumeration enum = children();
		while (enum.hasMoreElements()) {
			((ClassTreeNode)enum.nextElement()).reflect();
		}
	}
	
		
// Accessor
	public boolean isInvalid() {return(this.invalid);}
	protected void setInvalid(boolean aFlag)
	{
		this.invalid = aFlag;
		MainWindow.getInstance().getClassTree().getClassTreeModel().nodeChanged(this);
	}
	public boolean isChanged() {return(this.changed);}
	protected void setChanged(boolean aFlag)
	{
		this.changed = aFlag;
		MainWindow.getInstance().getClassTree().getClassTreeModel().nodeChanged(this);
	}

// Fields
	private boolean invalid = false;
	private boolean changed = false;

	//protected final ClassTreeModel treeModel = MainWindow.getInstance().getClassTreeModel();

	protected static final Icon LEAF_ICON = UIManager.getIcon("Tree.leafIcon");
	//protected static final Icon INVALID_LEAF_ICON = new ImageIcon("images/invalidLeaf.gif");
	protected static final Icon INVALID_LEAF_ICON =
		StaticProperties.getImage("images/invalidLeaf.gif");
	protected static final Icon CLOSED_ICON = UIManager.getIcon("Tree.closedIcon");
	protected static final Icon OPEN_ICON = UIManager.getIcon("Tree.openIcon");
}
