package jp.gr.java_conf.a0.jdh.gui;

import java.io.File;
import javax.swing.JOptionPane;
//import javax.swing.tree.TreeModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.MutableTreeNode;
import javax.swing.event.TreeModelListener;

import jp.gr.java_conf.a0.debug.Debug;

//public class ClassTreeModel implements TreeModel 
public class ClassTreeModel extends DefaultTreeModel
{
	public ClassTreeModel()
	{
		//super(new RootTreeNode());
		super(JavaDocNode.DUMMY_NODE);
		super.setRoot(new RootTreeNode(this));
	}


	/**
	 * Returns the child of <I>parent</I> at index <I>index</I> in the parent's
	 * child array.	 <I>parent</I> must be a node previously obtained from
	 * this data source. This should not return null if <i>index</i>
	 * is a valid index for <i>parent</i> (that is <i>index</i> >= 0 &&
	 * <i>index</i> < getChildCount(<i>parent</i>)).
	 *
	 * @param	parent	a node in the tree, obtained from this data source
	 * @return	the child of <I>parent</I> at index <I>index</I>
	 */
	public Object getChild(Object parent, int index)
	{
		return(((MutableTreeNode)parent).getChildAt(index));
	}


	/**
	 * Returns the number of children of <I>parent</I>.	 Returns 0 if the node
	 * is a leaf or if it has no children.	<I>parent</I> must be a node
	 * previously obtained from this data source.
	 *
	 * @param	parent	a node in the tree, obtained from this data source
	 * @return	the number of children of the node <I>parent</I>
	 */
	public int getChildCount(Object parent)
	{
		return(((MutableTreeNode)parent).getChildCount());
	}


	/**
	 * Returns true if <I>node</I> is a leaf.  It is possible for this method
	 * to return false even if <I>node</I> has no children.	 A directory in a
	 * filesystem, for example, may contain no files{} the node representing
	 * the directory is not a leaf, but it also has no children.
	 *
	 * @param	node	a node in the tree, obtained from this data source
	 * @return	true if <I>node</I> is a leaf
	 */
	public boolean isLeaf(Object node)
	{
		return(((MutableTreeNode)node).isLeaf());
	}


	/**
	 * Returns the index of child in parent.
	 */
	public int getIndexOfChild(Object parent, Object child)
	{
		return(((MutableTreeNode)parent).getIndex((MutableTreeNode)child));
	}



// Mine
	public void addFile(File aFile)
	{
		//this.rootNode.addFile(aFile);
		this.getRootTreeNode().addFile(aFile);
		MainWindow.getProject().notifyChanged();
	}
	public void removeFile(SourceFileNode aNode)
	{
		if (aNode.isChanged()) {
			int result = JOptionPane.showConfirmDialog(MainWindow.getInstance().getFrame(),
							   MainWindow.getResource().getString("message.remove.confirm"));
			//Debug.println("removeFile(): result: " + result);
			if (result == JOptionPane.YES_OPTION ) {
				aNode.reflect();
				aNode.save();
			} else if (result == JOptionPane.NO_OPTION ) {
				// do nothing
			} else {
				//CANCEL_OPTION or CLOSED_OPTION
				return;
			}
		}
		//aNode.removeFromParent();
		super.removeNodeFromParent(aNode);
		MainWindow.getProject().notifyChanged();
	}

	
	public RootTreeNode getRootTreeNode(){return((RootTreeNode)this.getRoot());}
	
// Fields
	//private final RootTreeNode rootNode = new RootTreeNode();
	private static final long serialVersionUID = -6038554877386789929L;
}


