package jp.gr.java_conf.a0.jdh.gui;

//import java.io.*;
import java.io.File;
import java.util.Enumeration;
import java.awt.Component;
import java.awt.Font;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.ImageIcon;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.TreePath;

import java.io.FileNotFoundException;
import javax.swing.tree.ExpandVetoException;
import jp.gr.java_conf.a0.jdh.parser.ParseException;

import jp.gr.java_conf.a0.debug.Debug;


public class ClassTree extends JTree implements PropertyChangeListener
{
	//public ClassTree(ClassTreeModel aModel)
	public ClassTree()
	{
		//super(aModel);
		super(new ClassTreeModel());
		ToolTipManager.sharedInstance().registerComponent(this);
		ClassTreeCellRenderer renderer = new ClassTreeCellRenderer();
		renderer.setFont(CurrentProperties.getTreeFont());
		super.setCellRenderer(renderer);
		
		TreeListener listener = new TreeListener();
		this.addTreeSelectionListener(listener);
//		this.addTreeModelListener(listener);
		this.addTreeExpansionListener(listener);
		this.addTreeWillExpandListener(listener);
		
		this.setRootVisible(false);// root is not always visible. toggle pathnode.
		this.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		//this.setRowHeight(-1);

		CurrentProperties.addPropertyChangeListener(this);
	}

	// for PropertyChangeListener
	public void notifyPropertyChanged()
	{
		//this.setRootVisible(CurrentProperties.displaysRootNode());
		this.repaint();
	}

/*	public Dimension getPreferredSize()
	{
		return(new Dimension(300, 300));
	}
	public Dimension preferredSize()
	{
		return(getPreferredSize());
	}
*/
	
// Accessor
	protected ClassTreeModel getClassTreeModel(){return((ClassTreeModel)super.getModel());}
	
// Fields
	public ActionListener fileOpen = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			File file = MainWindow.getController().showOpenDialog();
			if (file == null) {
				return;
			}
			if (!file.exists()) {
				MainWindow.getController().showErrorMessage(
						MainWindow.getResource().getString("message.file.notfound") +
						"\n" + file.getAbsolutePath());
				return;
			}
			getClassTreeModel().addFile(file);
		}
	};
	protected ActionListener actionReflect = new ActionListener()
	{
		public void actionPerformed(ActionEvent ae)
		{
			TreePath path = getSelectionPath();
			if (path == null) {
				return;
			}
			ClassTreeNode node = (ClassTreeNode)path.getLastPathComponent();
			node.reflect();
			//node.save();
		}
	};
	public ActionListener actionReflectAll = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			//ClassTreeNode node =
			getClassTreeModel().getRootTreeNode().reflect();
			//getClassTreeModel().getRootTreeNode().save();
		}
	};
	protected ActionListener actionSave = new ActionListener()
	{
		public void actionPerformed(ActionEvent ae)
		{
			TreePath path = getSelectionPath();
			if (path == null) {
				return;
			}
			ClassTreeNode node = (ClassTreeNode)path.getLastPathComponent();
			node.save();
		}
	};
	public ActionListener actionSaveAll = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			getClassTreeModel().getRootTreeNode().save();
		}
	};
	public ActionListener actionRemove = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			TreePath path = getSelectionPath();
			if (path == null) {
				return;
			}
			ClassTreeNode node = (ClassTreeNode)path.getLastPathComponent();
			if (node instanceof DirectoryNode) {
				Enumeration enum = node.children();
				while (enum.hasMoreElements()) {
					getClassTreeModel().removeFile((SourceFileNode)enum.nextElement());
				}
			} else if (node instanceof SourceFileNode) {
				getClassTreeModel().removeFile((SourceFileNode)node);
			}
		}
	};
	
// InnerClasses
	protected class TreeListener implements TreeSelectionListener, TreeExpansionListener,
						TreeModelListener, TreeWillExpandListener
	{
		// Selection
		public void valueChanged( TreeSelectionEvent e ) {
			Object node = e.getPath().getLastPathComponent();
			//Debug.println("SelectionListener.valueChanged(): " + node);
			if (node instanceof JavaDocNode) {
				MainWindow.getInstance().getEditPane().setJavaDocNode((JavaDocNode)node);
//			} else if (node instanceof SourceFileNode) {
//			} else {
			}
		}
		
		// Expansion
		public void treeExpanded(TreeExpansionEvent event)
		{
			//Debug.println("treeExpanded: "+event);
		}
		public void treeCollapsed(TreeExpansionEvent event)
		{
			//Debug.println("treeCollapsed: "+event);
		}
		
		// Model
		public void treeNodesChanged(TreeModelEvent event)
		{
			//Debug.println("treeNodesChanged: "+event);
		}
		public void treeNodesInserted(TreeModelEvent event)
		{
			//Debug.println("treeNodesInserted: "+event);
		}
		public void treeNodesRemoved(TreeModelEvent event)
		{
			//Debug.println("treeNodesRemoved: "+event);
		}
		public void treeStructureChanged(TreeModelEvent event)
		{
			//Debug.println("treeStructureChanged: "+event);
		}
		
		// WillExpand
		public void treeWillExpand(TreeExpansionEvent event)
							throws ExpandVetoException
		{
			//Debug.println("treeWillExpand: "+event);
			Object node = event.getPath().getLastPathComponent();
			if (node instanceof SourceFileNode) {
				Exception ex = ((SourceFileNode)node).parse();
				//Debug.println("treeWillExpand: parse(): "+ex);
				if (ex != null) {
					// parse failed
					JOptionPane.showMessageDialog(MainWindow.getInstance().getFrame(),
								  ex.getMessage(),
								  MainWindow.getResource().getString("message.title.error"),
								  JOptionPane.ERROR_MESSAGE);
					throw(new ExpandVetoException(event, ex.getMessage()));
				}
			}
		}
		public void treeWillCollapse(TreeExpansionEvent event)
							  throws ExpandVetoException
		{
			//Debug.println("treeWillCollapse: "+event);
		}
	}
	
	protected class ClassTreeCellRenderer extends DefaultTreeCellRenderer
	{
		public Component getTreeCellRendererComponent(JTree tree,
													   Object value,
													   boolean sel,
													   boolean expanded,
													   boolean leaf,
													   int row,
													   boolean hasFocus)
		{
			super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
			super.setFont(this.getPlainFont());
			super.setForeground(CurrentProperties.getColorTreeForeground());
			super.setBackground(CurrentProperties.getColorTreeBackground());

			if (value instanceof ClassTreeNode) {
				// ToolTip  Icon ̐ݒs
				ClassTreeNode treeNode = (ClassTreeNode)value;
				super.setToolTipText(treeNode.getToolTipText());
				super.setIcon(treeNode.getIcon(expanded));
				if (CurrentProperties.colorsModifiedNode() && treeNode.isChanged()) {
					super.setFont(getBoldFont());
				}
				if (CurrentProperties.colorsInvalidNode() && treeNode.isInvalid()) {
					super.setForeground(CurrentProperties.getColorInvalidState());
				}
			}
			return(this);
		}

		private Font getPlainFont()
		{
			if (this.plain == null) {
				this.plain = new Font(super.getFont().getName(),
									  Font.PLAIN,
									  super.getFont().getSize());
			}
			return(this.plain);
		}
		private Font getBoldFont()
		{
			if (this.bold == null) {
				this.bold = new Font(super.getFont().getName(),
									 Font.BOLD,
									 super.getFont().getSize());
			}
			return(this.bold);
		}
		//private Font getPlainFont() {return(this.plain);}
		
	// Fields
		private Font plain;
		private Font bold;
	}
}


