package sra.smalltalk;

import java.awt.*;

/**
 * SystemResourceSupport class
 * 
 * 	@author:    Hirotsugu Kondo
 * 	@created:   1998/12/4 (by Hirotsugu Kondo)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: SystemResourceSupport.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class SystemResourceSupport {
	public static Frame systemFrame;
	public static Window systemWindow;
	static {
		systemFrame = new Frame();
		systemWindow = new Window(systemFrame);
		systemWindow.pack();
		systemWindow.setVisible(true);
		systemWindow.setVisible(false);
	}
/**
 */
public SystemResourceSupport() {
}
/**
 * 
 * @return point
 */
public static Point _getStringExtentFor_(String string, Font font) {
	FontMetrics fontMetrics = getFontMetrics(font);
	return new Point(fontMetrics.stringWidth(string), fontMetrics.getHeight());
}
/**
 * 
 * @return Image
 */
public static Image createImage(int width, int height) {
	return getWindow().createImage(width, height);
}
/**
 * 
 * @return Image
 */
public static Image createImage(Point extent) {
	return getWindow().createImage(extent.x, extent.y);
}
/**
 * 
 * @return Font
 */
public static Font getFont() {
	return getWindow().getFont();
}
/**
 * 
 * @return FontMetrics
 */
public static FontMetrics getFontMetrics(Font aFont) {
	Font font = aFont;
	if (font == null) {
		font = getFont();
	};
	return getWindow().getFontMetrics(font);
}
/**
 * 
 * @return java.awt.Frame
 */
public static Frame getFrame() {
	return systemFrame;
}
/**
 * 
 * @return Graphics
 */
public static Graphics getGraphics() {
	return getWindow().getGraphics();
}
/**
 * 
 * @return java.awt.Window
 */
public static Window getWindow() {
	return systemWindow;
}
}
