package sra.smalltalk;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * StViewPanel class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/11/11 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@JUN:       197
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StViewPanel.java,v 3.0 2000/02/24 07:12:25 nisinaka Exp $
 */
public abstract class StViewPanel extends Panel implements StView {
	protected StModel model;
	/**
	 * Replacement for the # notation of Smalltalk. :-)
	 *
	 * @return sra.smalltalk.StSymbol
	 * @param aString java.lang.String
	 */
	public final static StSymbol $(String aString) {
		return StObject.$(aString);
	}
	/**
	 * StCanvasView constructor comment.
	 */
	public StViewPanel() {
		super();
		buildComponent();
	}
	/**
	 * If model is null then set a default model.
	 */
	public void addNotify() {
		if (model == null) {
			model_(defaultModel());
		}
		super.addNotify();
	}
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new StModel();
	}
	/**
	 * Paints this component.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
	}
	/*
	 * Support for property change.
	 */
	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	}
	/**
	 * Answer a model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	public StModel model() {
		if (model == null) {
			model_(defaultModel());
		}
		return model;
	}
	/**
	 * Set a model.
	 *
	 * @param aModel sra.smalltalk.StModel
	 */
	public void model_(StModel newModel) {
		if (model != newModel) {
			if (model != null) {
				model.removeDependent_(this);
			}
			StModel oldModel = model;
			model = newModel;
			if (model != null) {
				model.addDependent_(this);
			}
			rebuildComponent(oldModel, newModel);
			repaint();
			firePropertyChange("model", oldModel, newModel);
		}
	}
	/**
	 * Paints this component.
	 *
	 * @param @param aGraphics java.awt.Graphics
	 */
	public void paint(Graphics g) {
		this.displayOn_(g);
	}
	/**
	 * Rebuild this component.
	 *
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
	}
	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol
	 * that indicates what change has occurred.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		repaint();
	}
}
