package sra.smalltalk;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * StViewJPanel class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/11/11 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StViewJPanel.java,v 3.1 2000/04/07 05:41:28 nisinaka Exp $
 */
public abstract class StViewJPanel extends JPanel implements StView {
	protected StModel model;
	/**
	 * Replacement for the # notation of Smalltalk. :-)
	 *
	 * @return sra.smalltalk.StSymbol
	 * @param aString java.lang.String
	 */
	public final static StSymbol $(String aString) {
		return StObject.$(aString);
	}
	/**
	 * StCanvasView constructor comment.
	 */
	public StViewJPanel() {
		super();
		buildComponent();
	}
	/**
	 * If model is null then set a default model.
	 */
	public void addNotify() {
		if (model == null) {
			model_(defaultModel());
		}
		super.addNotify();
	}
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new StModel();
	}
	/**
	 * Paints this component.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
	}
	/**
	 * Answer a model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	public StModel model() {
		if (model == null) {
			model_(defaultModel());
		}
		return model;
	}
	/**
	 * Set a model.
	 *
	 * @param aModel sra.smalltalk.StModel
	 */
	public void model_(StModel newModel) {
		if (model != newModel) {
			if (model != null) {
				model.removeDependent_(this);
			}
			StModel oldModel = model;
			model = newModel;
			if (model != null) {
				model.addDependent_(this);
			}
			rebuildComponent(oldModel, newModel);
			repaint();
			firePropertyChange("model", oldModel, newModel);
		}
	}
	/**
	 * Paints this component.
	 *
	 * @param @param aGraphics java.awt.Graphics
	 */
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		this.displayOn_(g);
	}
	/**
	 * Rebuild this component.
	 *
	 * @param oldModel sra.smalltalk.StModel
	 * @param newModel sra.smalltalk.StModel
	 */
	protected void rebuildComponent(StModel oldModel, StModel newModel) {
	}
	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol
	 * that indicates what change has occurred.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		repaint();
	}
}
