package sra.smalltalk;

/**
 * StValueModel class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/09 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StValueModel.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StValueModel extends StModel {
	/**
	 * Create a new instance and initialize it.
	 */
	public StValueModel() {
		super();
		this.initialize();
	}
	/**
	 * Convert this as StValueModel.
	 *
	 * @return sra.smalltalk.StValueModel
	 */
	public StValueModel asValue() {
		return this;
	}
	/**
	 * Answer a StBlockValue that computes aBlock with the receiver's value
	 * as the argument.
	 *
	 * @return sra.smalltalk.StBlockValue
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		StValueModel[] anArray = {this};
		return StBlockValue.Block_arguments_(aBlock, anArray);
	}
	/**
	 * Initialize the instance. Subclasses may extend this.
	 *
	 * @return sra.smalltalk.StObject
	 */
	public StObject initialize() {
		return this;
	}
	/**
	 * Arrange to receive a message with aSymbol when the value aspect
	 * changes on anObject.
	 *
	 * @param aSymbol java.lang.String
	 * @param anObject sra.smalltalk.StObject
	 */
	public void onChangeSend_to_(String aSymbol, StObject anObject) {
		this.expressInterestIn_for_sendBack_($("value"), anObject, aSymbol);
	}
	/**
	 * Remove references to objects that may refer to the receiver.
	 */
	public void release() {
		this.releaseParts();
		super.release();
	}
	/**
	 * Break the dependency links from any parts of myself to myself.
	 * Subclasses holding composite values will implement this in a
	 * non-trivial way.
	 */
	public void releaseParts() {
	}
	/**
	 * Undo a send of onChangeSend_to_().
	 *
	 * @param anObject sra.smalltalk.StObject
	 */
	public void retractInterestsFor_(StObject anObject) {
		this.retractInterestIn_for_($("value"), anObject);
	}
	/**
	 * Set the currently stored value, without notifying dependents.
	 *
	 * @param newValue java.lang.Object
	 */
	public void setValue_(Object newValue) {
		throw SmalltalkException.SubclassResponsibility();
	}
	/**
	 * Answer the currently stored value.
	 *
	 * @return java.lang.Object
	 */
	public Object value() {
		throw SmalltalkException.SubclassResponsibility();
	}
	/**
	 * Set the currently stored value, and notify dependents.
	 *
	 * @param newValue java.lang.Object
	 */
	public void value_(Object newValue) {
		this.setValue_(newValue);
		this.changed_($("value"));
	}
}