package sra.smalltalk;

import java.io.*;

/**
 * StValueHolder class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/09 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StValueHolder.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StValueHolder extends StValueModel {
	protected Object value = null;
	/**
	 * Default constructor.
	 */
	public StValueHolder() {
		super();
	}
	/**
	 * Create a new instance and initialize it with aNumber
	 *.
	 * @param aNumber double
	 */
	public StValueHolder(double aNumber) {
		super();
		this.setValue_(new Double(aNumber));
	}
	/**
	 * Create a new instance and initialize it with aNumber
	 *.
	 * @param aNumber float
	 */
	public StValueHolder(float aNumber) {
		super();
		this.setValue_(new Float(aNumber));
	}
	/**
	 * Create a new instance and initialize it with aNumber
	 *.
	 * @param aNumber int
	 */
	public StValueHolder(int aNumber) {
		super();
		this.setValue_(new Integer(aNumber));
	}
	/**
	 * Create a new instance and initialize it with aNumber
	 *.
	 * @param aNumber long
	 */
	public StValueHolder(long aNumber) {
		super();
		this.setValue_(new Long(aNumber));
	}
	/**
	 * Create a new instance and initialize it with anObject.
	 *
	 * @param anObject java.lang.Object
	 */
	public StValueHolder(Object anObject) {
		super();
		this.setValue_(anObject);
	}
	/**
	 * Assume 'value' is a kind of Number and return it as double.
	 *
	 * @return double
	 */
	public double _doubleValue() {
		return ((Number) value).doubleValue();
	}
	/**
	 * Assume 'value' is a kind of Number and return it as float.
	 *
	 * @return float
	 */
	public float _floatValue() {
		return ((Number) value).floatValue();
	}
	/**
	 * Assume 'value' is a kind of Number and return it as int.
	 *
	 * @return int
	 */
	public int _intValue() {
		return ((Number) value).intValue();
	}
	/**
	 * Assume 'value' is a kind of Number and return it as long.
	 *
	 * @return long
	 */
	public long _longValue() {
		return ((Number) value).longValue();
	}
	/**
	 * Print my string representation on aWriter.
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		aWriter.write(this.value().toString());
	}
	/**
	 * Set the currently stored value, without notifying dependents.
	 *
	 * @param newValue java.lang.Object
	 */
	public void setValue_(Object newValue) {
		value = newValue;
	}
	/**
	 * Answer the currently stored value.
	 *
	 * @return java.lang.Object
	 */
	public Object value() {
		return value;
	}
	/**
	 * Set the currently stored value, and notify dependents.
	 *
	 * @param aNumber double
	 */
	public void value_(double aNumber) {
		super.value_(new Double(aNumber));
	}
	/**
	 * Set the currently stored value, and notify dependents.
	 *
	 * @param aNumber float
	 */
	public void value_(float aNumber) {
		super.value_(new Float(aNumber));
	}
	/**
	 * Set the currently stored value, and notify dependents.
	 *
	 * @param aNumber int
	 */
	public void value_(int aNumber) {
		super.value_(new Integer(aNumber));
	}
	/**
	 * Set the currently stored value, and notify dependents.
	 *
	 * @param aNumber long
	 */
	public void value_(long aNumber) {
		super.value_(new Long(aNumber));
	}
	/**
	 * Create a new instance and initialize it with anObject.
	 *
	 * @return sra.smalltalk.StValueHolder
	 * @param aClass java.lang.Class
	 * @param anObject java.lang.Object
	 */
	public static StValueHolder With_(Class aClass, Object anObject) {
		return (StValueHolder) _New(aClass, anObject);
	}
	/**
	 * Create a new instance of StValueHolder and initialize it with anObject.
	 *
	 * @return sra.smalltalk.StValueHolder
	 * @param anObject java.lang.Object
	 */
	public final static StValueHolder With_(Object anObject) {
		return With_(StValueHolder.class, anObject);
	}
}