package sra.smalltalk;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * StUIBuilder class
 * 
 * 	@author:    He Weijie
 * 	@created:   1998/08/27 (by He Weijie)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StUIBuilder.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StUIBuilder extends StObject implements WindowListener {
	protected StApplicationModel model;
	protected Vector frames = new Vector();
	/**
	 * 
	 * @param aModel sra.smalltalk.StApplicationModel
	 */
	public StUIBuilder(StApplicationModel aModel) {
		super();
		model = aModel;
	}
	/**
	 * 
	 * @param aFrame java.awt.Frame
	 */
	public void addFrame_(Frame aFrame) {
		frames.addElement(aFrame);
		aFrame.addWindowListener(this);
	}
	/**
	 * 
	 * @return java.awt.Frame[]
	 */
	public Frame[] frames() {
		Frame[] array;
		synchronized (frames) {
			array = new Frame[frames.size()];
			frames.copyInto(array);
		}
		return array;
	}
	/**
	 * 
	 * @return sra.smalltalk.StApplicationModel
	 */
	protected StApplicationModel model() {
		return model;
	}
	/**
	 * 
	 * @param aFrame java.awt.Frame
	 */
	public void removeFrame_(Frame aFrame) {
		aFrame.removeWindowListener(this);
		frames.removeElement(aFrame);
	}
	/**
	 * Invoked when a window is activated.
	 */
	public void windowActivated(WindowEvent e) {
	}
	/**
	 * Invoked when a window has been closed.
	 */
	public void windowClosed(WindowEvent e) {
	}
	/**
	 * Invoked when a window is in the process of being closed.
	 * The close operation can be overridden at this point.
	 */
	public void windowClosing(WindowEvent e) {
		this.model().windowClosing(e);
	}
	/**
	 * Invoked when a window is de-activated.
	 */
	public void windowDeactivated(WindowEvent e) {
	}
	/**
	 * Invoked when a window is de-iconified.
	 */
	public void windowDeiconified(WindowEvent e) {
	}
	/**
	 * Invoked when a window is iconified.
	 */
	public void windowIconified(WindowEvent e) {
	}
	/**
	 * Invoked when a window has been opened.
	 */
	public void windowOpened(WindowEvent e) {
	}
}
