package sra.smalltalk;

import java.util.*;

/**
 * StSymbol class
 * 
 * 	@author:    He Weijie
 * 	@created:   1998/09/16 (by HeWeijie)
 * 	@updated:   1998/11/04 (by nisinaka)
 * 	@updated:   1999/06/22 (by nisinaka)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StSymbol.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StSymbol extends StObject {
	/**
	 * The string representation.
	 */
	protected String _string;

	//
	protected static Hashtable _symbols = new Hashtable();
	/**
	 * The instance of StSymbol should not be created with
	 * the default constructor.
	 */
	private StSymbol() {
	}
	/**
	 * Create a new instance of StSymbol.
	 *
	 * @param aString java.lang.String
	 */
	private StSymbol(String aString) {
		_string = aString.intern();
		_symbols.put(_string, this);
	}
	/**
	 * Answer true if the receiver is equal to the Object, otherwise false.
	 *
	 * @return boolean
	 * @param anObject java.lang.Object
	 */
	public boolean equals(Object anObject) {
		return (this == anObject);
	}
	/**
	 * Answer the symbol specified with the String.
	 *
	 * @param java.lang.String
	 * @return sra.smalltalk.StSymbol
	 */
	public static StSymbol Intern_(String aString) {
		StSymbol aSymbol = (StSymbol) _symbols.get(aString.intern());
		if (aSymbol == null) {
			aSymbol = new StSymbol(aString);
		}
		return aSymbol;
	}
	/**
	 * @deprecated, replaced by <code>==</code>.
	 * @return boolean
	 * @param aSymbol sra.smalltalk.StSymbol
	 */
	public boolean isEqual(StSymbol aSymbol) {
		return (this == aSymbol);
	}
	/**
	 * Answer the size.
	 *
	 * @return int
	 */
	public int size() {
		return _string.length();
	}
	/**
	 * Returns a string representation of the StString.
	 *
	 * @return java.lang.String
	 */
	public String toString() {
		return _string;
	}
}