package sra.smalltalk;

/**
 * StSortedCollectionTestExamples class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/12/02 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StSortedCollectionTestExamples.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StSortedCollectionTestExamples extends SmalltalkTestExamples {
	/**
	 * 
	 * @return boolean
	 */
	public final static boolean Example1() {
		StBlockClosure sortBlock = new StBlockClosure() {
			public Object value_value_(Object e1, Object e2) {
				return new Boolean(((Number) e1).intValue() <= ((Number) e2).intValue());
			}
		};
		StSortedCollection collection = new StSortedCollection(sortBlock);
		collection.add_(new Integer(0));
		collection.add_(new Integer(4));
		collection.add_(new Integer(5));
		collection.add_(new Integer(3));
		collection.add_(new Integer(2));
		collection.add_(new Integer(1));
		Object[] array = collection._asArray();
		for (int i = 0; i < array.length; i++) {
			System.out.println(i);
			if (((Number) array[i]).intValue() != i) {
				return false;
			}
		}
		return true;
	}
	/**
	 * Execute all examles.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String args[]) {
		new StSortedCollectionTestExamples();
	}
}