package sra.smalltalk;

import java.util.Vector;

/**
 * StSortedCollection class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/12/02 (by nisinaka)
 * 	@updated:   1999/08/05 (by nisinaka)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StSortedCollection.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StSortedCollection extends StObject {
	/**
	 * The block closure for comparing two elements.
	 */
	protected StBlockClosure sortBlock = null;

	/**
	 * The collection which holds the elements in order.
	 */
	protected Vector _elements = new Vector();
	/**
	 * Need to specify the sort block.
	 */
	private StSortedCollection() {
	}
	/**
	 * Create a new instance of StSortedCollection with a sort block.
	 *
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public StSortedCollection(StBlockClosure aBlock) {
		super();
		this.sortBlock_(aBlock);
	}
	/**
	 * Create a new instance of StSortedCollection with a sort block.
	 *
	 * @param aBlock sra.smalltalk.StBlockClosure
	 * @param anArray java.lang.Object[]
	 */
	public StSortedCollection(StBlockClosure aBlock, Object[] anArray) {
		this(aBlock);
		for (int i = 0; i < anArray.length; i++) {
			this.add_(anArray[i]);
		}
	}
	/**
	 * Create a new instance of StSortedCollection with a sort block.
	 *
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public StSortedCollection(StBlockClosure aBlock, Vector aCollection) {
		this(aBlock);
		Object[] anArray = new Object[aCollection.size()];
		aCollection.copyInto(anArray);
		for (int i = 0; i < anArray.length; i++) {
			this.add_(anArray[i]);
		}
	}
	/**
	 * Answer the receiver's elements as array.
	 *
	 * @return java.lang.Object[]
	 */
	public Object[] _asArray() {
		Object[] newArray = new Object[_elements.size()];
		_elements.copyInto(newArray);
		return newArray;
	}
	/**
	 * Add the new object as one of the receiver's element.
	 *
	 * @return java.lang.Object
	 * @param newObject java.lang.Object
	 */
	public Object add_(Object newObject) {
		if (_elements.isEmpty()) {
			_elements.addElement(newObject);
		} else {
			int nextIndex = this.indexForInserting_(newObject);
			_elements.insertElementAt(newObject, nextIndex);
		}
		return newObject;
	}
	/**
	 * Compare the two elements.
	 *
	 * @return boolean
	 * @param e1 java.lang.Object
	 * @param e2 java.lang.Object
	 */
	private boolean compareElement_to_(Object e1, Object e2) {
		if (sortBlock == null) {
			throw new SmalltalkException("No sort block.");
		}
		return ((Boolean) sortBlock.value_value_(e1, e2)).booleanValue();
	}
	/**
	 * Answer the index for inserting the new object.
	 *
	 * @return int
	 * @param newObject java.lang.Object
	 */
	private int indexForInserting_(Object newObject) {
		int low = 0;
		int high = _elements.size() - 1;
		int index = (high + low) / 2;
		while (low <= high) {
			if (this.compareElement_to_(_elements.elementAt(index), newObject)) {
				low = index + 1;
			} else {
				high = index - 1;
			}
			index = (high + low) / 2;
		}
		return low;
	}
	/**
	 * Answer my size.
	 *
	 * @return int
	 */
	public int size() {
		return _elements.size();
	}
	/**
	 * Set the sort block of the receiver.
	 *
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	public void sortBlock_(StBlockClosure aBlock) {
		sortBlock = aBlock;
	}
}