package sra.smalltalk;

/**
 * StReadStream class
 * 
 * 	@author:    nisinaka
 * 	@created:   1999/06/21 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StReadStream.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StReadStream extends StObject {
	/**
	 * The string as a source stream.
	 */
	protected String source = null;

	/**
	 * The current reading position within a source string.
	 */
	protected int position;

	/**
	 * The length of the source string.
	 */
	protected int length;
	/**
	 * The default constructor.
	 */
	public StReadStream() {
		this("");
	}
	/**
	 * Create a new instance of StReadStream with a string as a source.
	 *
	 * @param aString java.lang.String
	 */
	public StReadStream(String aString) {
		length = aString.length();
		char[] charArray = new char[length + 1];
		System.arraycopy(aString.toCharArray(), 0, charArray, 0, length);
		charArray[length] = 0;
		source = new String(charArray);
		position = 0;
	}
	/**
	 * Answer true if the position is at the end.
	 *
	 * @return boolean
	 */
	public boolean atEnd() {
		return (position >= length);
	}
	/**
	 * Answer the copied contents of the receiver.
	 *
	 * @return java.lang.String
	 */
	public String contents() {
		return new String(source);
	}
	/**
	 * Answer the character at the current position and change the position.
	 *
	 * @return char
	 */
	public char next() {
		return source.charAt(position++);
	}
/**
 * Answer the next anInteger elements of the receiver.
 * If there are not enough elements available, answer
 * a collection of as many as are available.
 *
 * @param int
 * @return String
 */
public String nextAvailable_(int anInteger) {
	int to = Math.min(this.length, this.position() + anInteger);
	int size = to - this.position();
	StringBuffer buffer = new StringBuffer();
	for (int i = 0; i < size; i++) {
		buffer.append(this.next());
	};
	return buffer.toString();
}
	/**
	 * Answer the character at the current position, but not change the position.
	 *
	 * @return char
	 */
	public char peek() {
		if (this.atEnd()) {
			return 0;
		}
		return source.charAt(position);
	}
	/**
	 * Answer true and increment the position if the next character equals to ch.
	 *
	 * @return boolean
	 * @param ch char
	 */
	public boolean peekFor_(char ch) {
		if (this.atEnd()) {
			return false;
		}
		char nextChar = this.next();
		if (ch == nextChar) {
			return true;
		}
		this.skip_(-1);
		return false;
	}
	/**
	 * Answer the current reading position.
	 *
	 * @return int
	 */
	public final int position() {
		return position;
	}
	/**
	 * Set the current position.
	 *
	 * @param newPosition int
	 */
	public void position_(int newPosition) {
		if (0 <= newPosition && newPosition <= source.length()) {
			position = newPosition;
		} else {
			throw new SmalltalkException("positionOutOfBoundsError: " + newPosition);
		}
	}
	/**
	 * Set position to position + offset.
	 *
	 * @param offset int
	 */
	public void skip_(int offset) {
		this.position_(position + offset);
	}
/**
 * Returns a String that represents the value of this object.
 * @return a string representation of the receiver
 */
public String toString() {
	// Insert code to print the receiver here.
	// This implementation forwards the message to super. You may replace or supplement this.
	return super.toString();
}
	/**
	 * Answer the substring from the current position to the end.
	 *
	 * @return java.lang.String
	 */
	public String upToEnd() {
		return source.substring(position, length);
	}
}
