package sra.smalltalk;

import java.awt.event.*;
import java.util.*;
/**
 * StRadioButtonMenuItem class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/09/16 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StRadioButtonMenuItem.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StRadioButtonMenuItem extends StCheckBoxMenuItem {
	private StButtonGroup group = null;
	/**
	 * Creates a menuItem with text.
	 *
	 * @param text java.lang.String
	 */
	public StRadioButtonMenuItem(String text) {
		this(text, false);
	}
	/**
	 * Creates a menuItem with text.
	 *
	 * @param text java.lang.String
	 * @param selected boolean
	 */
	public StRadioButtonMenuItem(String text, boolean selected) {
		super(text, selected);
	}
	/**
	 *
	 * @return sra.smalltalk.StButtonGroup
	 */
	StButtonGroup getGroup() {
		return group;
	}
	/**
	 * @param aBoolean boolean
	 */
	protected void selected_(boolean aBoolean) {
		if (selected != aBoolean) {
			selected = aBoolean;
			StSymbol aspect = selected ? $("selected") : $("deselected");
			StMenuItem root = getRoot();
			if (root instanceof StMenuModel) {
				((StMenuModel) root).changed_with_(aspect, this);
			}
			this.fireItemStateChanged(new ItemEvent(
				this, ItemEvent.ITEM_STATE_CHANGED, this,
				selected ? ItemEvent.SELECTED : ItemEvent.DESELECTED));
		}
	}
	/**
	 *
	 * @param aGroup sra.smalltalk.StButtonGroup
	 */
	void setGroup(StButtonGroup aGroup) {
		group = aGroup;
	}
	/**
	 * @param aBoolean boolean
	 */
	public void setSelected(boolean aBoolean) {
		if (aBoolean == true) {
			getGroup().setSelection(this);
		}
	}
}