package sra.smalltalk;

import java.io.*;

/**
 * StObjectTestExamples class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/07 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StObjectTestExamples.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StObjectTestExamples extends SmalltalkTestExamples {
	public static String StObjectTestExamples_variable = "This is a class instance variable";
	/**
	 * The usage of StObject._New().
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		try {
			String aString = "an instance of String";
			Object[] arguments = {aString};
			String newString = (String) StObject._New(String.class, arguments);
			System.out.println(newString);
			return aString.equals(newString);
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * The usage of StObject._ParameterTypesOf().
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		try {
			Object[] arguments = {"string", new Double(1.0)};
			Class[] parameterTypes = (Class[]) StObject._ParameterTypesOf(arguments);
			return parameterTypes[0] == String.class && parameterTypes[1] == Double.TYPE;
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * The usage of StObject._ListOfPossibleParameterTypes().
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		try {
			Class aClass = String.class;
			Class[] anArray = {aClass};
			java.util.Vector aList = StObject._ListOfPossibleParameterTypes(anArray, aClass);
			if (aList.size() != 4) {
				return false;
			}
			if (((Class[]) aList.elementAt(0)).length != 2) {
				return false;
			}
			if (((Class[]) aList.elementAt(0))[0] != String.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(0))[1] != String.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(1)).length != 2) {
				return false;
			}
			if (((Class[]) aList.elementAt(1))[0] != String.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(1))[1] != Object.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(2)).length != 2) {
				return false;
			}
			if (((Class[]) aList.elementAt(2))[0] != Object.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(2))[1] != String.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(3)).length != 2) {
				return false;
			}
			if (((Class[]) aList.elementAt(3))[0] != Object.class) {
				return false;
			}
			if (((Class[]) aList.elementAt(3))[1] != Object.class) {
				return false;
			}
			return true;
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * The usage of StObject._ClassInstanceVariable().
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		try {
			Object anObject = StObject._ClassInstanceVariable(StObjectTestExamples.class, "variable");
			return StObjectTestExamples_variable.equals(anObject);
		} catch (Exception e) {
			throw new SmalltalkException(e);
			// return false;
		}
	}
	/**
	 * The usage of StObject._ClassInstanceVariable().
	 *
	 * @return boolean
	 */
	public static boolean Example5() {
		try {
			StObject._ClassInstanceVariable(StObjectTestExamples.class, "variable", new String("new value"));
			return StObjectTestExamples_variable.equals("new value");
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * The usage of StObject._PerformWithArguments().
	 *
	 * @return boolean
	 */
	public static boolean Example6() {
		try {
			Object[] arguments = {new Character('A')};
			Character c = (Character) StObject._PerformWithArguments(Character.class, "toLowerCase", arguments);
			return c.charValue() == 'a';
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * The test for copy() method.
	 *
	 * @return boolean
	 */
	public static boolean Example7() {
		try {
			String first = "first";
			String second = "second";
			StValueHolder aValueHolder1 = new StValueHolder(first);
			StValueHolder aValueHolder2 = (StValueHolder) aValueHolder1.copy();
			aValueHolder2.value_(second);
			return aValueHolder1.value() == first && aValueHolder2.value() == second;
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * A test for the dependency mechanism.
	 *
	 * @return boolean
	 */
	public static boolean Example9() {
		try {
			StObject otherObject = new StObject() {
			};
			StObject transient1 = new StObject() {
				public void update_(DependentEvent evt) {
					System.out.println(evt.getAspect().toString());
				}
			};
			StObject transient2 = new StObject() {
				public void update_(DependentEvent evt) {
					System.out.println(evt.getAspect().toString());
				}
			};
			otherObject.addDependent_(transient1);
			otherObject.addDependent_(transient2);
			otherObject.changed_(StObject.$("something"));
			otherObject.removeDependent_(transient1);
			otherObject.removeDependent_(transient2);
			return true;
		} catch (Exception e) {
			return false;
		}
	}
	/**
	 * Execute all examples.
	 * @param args java.lang.String[]
	 */
	public static void main(String args[]) {
		new StObjectTestExamples();
	}
}