package sra.smalltalk;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;

/**
 * StObject class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/08/05 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StObject.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StObject implements Cloneable, DependentListener {
	/**
	 * 
	 */
	static Hashtable DependentsFields = new Hashtable();

	/**
	 * Replacement for the # notation of Smalltalk. :-)
	 *
	 * @return sra.smalltalk.StSymbol
	 * @param aString java.lang.String
	 */
	public final static StSymbol $(String aString) {
		return StSymbol.Intern_(aString);
	}
	/**
	 * Find a class instance variable and return its value.
	 *
	 * Please refer to StObjectTestExamples.Example4() for the usage..
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param variableName java.lang.String
	 */
	public static Object _ClassInstanceVariable(Class aClass, String variableName) {
		String className = aClass.getName();
		int index = className.lastIndexOf('.');
		if (index != -1) {
			className = className.substring(index + 1);
		}
		String fieldName = className + "_" + variableName;
		try {
			return aClass.getField(fieldName).get(null);
		} catch (NoSuchFieldException e) {
			if (aClass == Object.class) {
				throw new SmalltalkException(e);
			}
			return _ClassInstanceVariable(aClass.getSuperclass(), variableName);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Find a class instance variable and set its value.
	 *
	 * Please refer to StObjectTestExamples.Example5() for the usage..
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param variableName java.lang.String
	 */
	public static void _ClassInstanceVariable(Class aClass, String variableName, Object anObject) {
		String className = aClass.getName();
		int index = className.lastIndexOf('.');
		if (index != -1) {
			className = className.substring(index + 1);
		}
		String fieldName = className + "_" + variableName;
		Field aField;
		try {
			aField = aClass.getField(fieldName);
			aClass.getField(fieldName).set(null, anObject);
		} catch (NoSuchFieldException e) {
			if (aClass == Object.class) {
				throw new SmalltalkException(e);
			}
			_ClassInstanceVariable(aClass.getSuperclass(), variableName, anObject);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Input all the public fileds from a ObjectInputStream.  
	 *
	 * Please refer to StObjectTestExamples.Example8() for the usage..
	 *
	 * @param in java.io.ObjectInputStream
	 */
	private void _getFileds(ObjectInputStream in) {
		Class aClass = this.getClass();
		Field aFields[] = aClass.getFields();
		try {
			for (int i = 0; i < Array.getLength(aFields); i++) {
				aFields[i].set(this, in.readObject());
			}
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Answer the list of possible parameter types.
	 *
	 * This is used to get a list of possible parameter types.  This
	 * process will be done recursively so you need to divide parameter
	 * types into two: the last one and the rest.
	 *
	 * Please refer to StObjectTestExamples.Example3() for the usage..
	 * 
	 * @return java.util.Vector
	 * @param parameterTypes java.lang.Class[]
	 * @param tailClass java.lang.Class
	 */
	public static Vector _ListOfPossibleParameterTypes(Class[] parameterTypes, Class tailClass) {
		Vector possibleParameterTypes = new Vector();

		// Make a list of tailClass class and its superclasses.
		Vector listOfClasses = new Vector();
		Class aClass = tailClass;
		do {
			listOfClasses.addElement(aClass);
			aClass = aClass.getSuperclass();
		} while (aClass != null);

		// Make a list of possible parameter types.
		if (parameterTypes.length == 0) {
			// There is no list of head parameter types.
			// You just need to create a list of parameter types.
			for (int i = 0; i < listOfClasses.size(); i++) {
				Class[] anArray = {(Class) listOfClasses.elementAt(i)};
				possibleParameterTypes.addElement(anArray);
			}
		} else {
			// There is a list of head parameter types.
			// You need to make a list of possible parameter types with them.
			Vector listOfParameterTypes;
			int arraySize = parameterTypes.length - 1;
			Class[] anArray = new Class[arraySize];
			for (int i = 0; i < arraySize; i++) {
				anArray[i] = parameterTypes[i];
			}
			listOfParameterTypes = _ListOfPossibleParameterTypes(anArray, parameterTypes[arraySize]);
			
			// Append each class of "listOfClasses" as a last class of parameter,
			// and add it to the list of possible parameter types.
			arraySize = parameterTypes.length + 1;
			for (int i = 0; i < listOfParameterTypes.size(); i++) {
				Class[] anElement = (Class[]) listOfParameterTypes.elementAt(i);
				for (int j = 0; j < listOfClasses.size(); j++) {
					anArray = new Class[arraySize];
					for (int k = 0; k < arraySize - 1; k++) {
						anArray[k] = anElement[k];
					}
					anArray[arraySize - 1] = (Class) listOfClasses.elementAt(j);
					possibleParameterTypes.addElement(anArray);
				}
			}
		}
		
		return possibleParameterTypes;
	}
	/**
	 * Create a new instance of aClass without arguments.
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 */
	public static Object _New(Class aClass) {
		try {
			return aClass.newInstance();
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Create a new instance of aClass with arguments.
	 *
	 * Please refer to StObjectTestExamples.Example1() for the usage.
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param arguments java.lang.Object[]
	 */
	public static Object _New(Class aClass, Object[] arguments) {
		Class[] parameterTypes = _ParameterTypesOf(arguments);
		Constructor aConstructor = null;
		try {
			aConstructor = aClass.getConstructor(parameterTypes);
		} catch (NoSuchMethodException e) {
			int arraySize = parameterTypes.length - 1;
			Class[] anArray = new Class[arraySize];
			for (int i = 0; i < arraySize; i++) {
				anArray[i] = parameterTypes[i];
			}
			Vector aList = _ListOfPossibleParameterTypes(anArray, parameterTypes[arraySize]);
			for (int i = 0; i < aList.size(); i++) {
				Class[] aPossibleParameterTypes = (Class[]) aList.elementAt(i);
				try {
					aConstructor = aClass.getConstructor(aPossibleParameterTypes);
				} catch (NoSuchMethodException e2) {
					// Just ignore the exception and try another parameter types.
				}
			}
			if (aConstructor == null) {
				throw SmalltalkException.MessageNotUnderstood("Constructor of " + aClass.getName());
			}
		}
		try {
			return aConstructor.newInstance(arguments);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Create a new instance of aClass with an argument.
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param argument java.lang.Object
	 */
	public static Object _New(Class aClass, Object argument) {
		Object[] arguments = {argument};
		return _New(aClass, arguments);
	}
	/**
	 * Create a new instance of aClass with two arguments.
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 */
	public static Object _New(Class aClass, Object argument1, Object argument2) {
		Object[] arguments = {argument1, argument2};
		return _New(aClass, arguments);
	}
	/**
	 * Make an array of class which contains parameter types of arguments.
	 *
	 * This is used to get an appropriate parameter types which
	 * correspond to the arguments.  The parameter types can be used as
	 * an argument for Class.getConstructor() or Class.getMethod().
	 *
	 * Please refer to StObjectTestExamples.Example2() for the usage.
	 *
	 * @return java.lang.Class[]
	 * @param arguments java.lang.Object[]
	 */
	public static Class[] _ParameterTypesOf(Object[] arguments) {
		int numberOfArguments = arguments.length;
		Class[] parameterTypes = new Class[numberOfArguments];
		for (int i = 0; i < numberOfArguments; i++) {
			Class aClass;
			try {
				// You cannot use the return value of getClass()
				// for Class.getMethod() or Class.getConstructor()
				// if the type of object is a primitive one. So
				// check for the primitive types. If there is a
				// "TYPE" field, then use its value.
				aClass = (Class) arguments[i].getClass().getField("TYPE").get(null);
			} catch (NoSuchFieldException e) {
				// If there is no "TYPE" field, use the return
				// value of getClass().
				aClass = arguments[i].getClass();
			} catch (IllegalAccessException e) {
				throw new sra.smalltalk.SmalltalkException(e);
			}
			parameterTypes[i] = aClass;
		}
		return parameterTypes;
	}
	/**
	 * Send the message indicated by "selector" to aClass. The
	 * "selector" is the method name.
	 * 
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param selector java.lang.String
	 */
	public static Object _Perform(Class aClass, String selector) {
		Object theObject = null;
		try {
			Method theMethod = aClass.getMethod(selector, null);
			Object argumentList[] = null;
			theObject = theMethod.invoke(aClass, null);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
		return theObject;
	}
	/**
	 * Send the message indicated by "selector" and "argument" to
	 * aClass. The "selector" is the method name and its argument is
	 * "argument".
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param selector java.lang.String
	 * @param argument java.lang.Object
	 */
	public static Object _PerformWith(Class aClass, String selector, Object argument) {
		Object[] arguments = {argument};
		return _PerformWithArguments(aClass, selector, arguments);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param selector java.lang.String
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 */
	public static Object _PerformWith(Class aClass, String selector, Object argument1, Object argument2) {
		Object[] arguments = {argument1, argument2};
		return _PerformWithArguments(aClass, selector, arguments);
	}
	/**
	 * Send the message indicated by "selector" and "arguments" to
	 * aClass. The "selector" is the method name and its arguments are
	 * the elements of "arguments".
	 *
	 * @return java.lang.Object
	 * @param aClass java.lang.Class
	 * @param selector java.lang.String
	 * @param arguments java.lang.Object[]
	 */
	public static Object _PerformWithArguments(Class aClass, String selector, Object[] arguments) {
		Object theResult = null;
		Method theMethod = _SearchMethod(aClass, selector, _ParameterTypesOf(arguments));
		try {
			theResult = theMethod.invoke(aClass, arguments);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
		return theResult;
	}
	/**
	 * Output all the public fileds to a ObjectOutputStream.  
	 *
	 * Please refer to StObjectTestExamples.Example8() for the usage..
	 *
	 * @param out java.io.ObjectOutputStream
	 */
	private void _putFileds(ObjectOutputStream out) {
		Class aClass = this.getClass();
		Field aFields[] = aClass.getFields();
		try {
			for (int i = 0; i < Array.getLength(aFields); i++) {
				out.writeObject(aFields[i].get(this));
			}
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Answer a method which parameter types do not much exactly.
	 *
	 * @return java.lang.reflect.Method
	 * @param aClass java.lang.Class
	 * @param selector java.lang.String
	 * @param parameterTypes java.lang.Class[]
	 */
	public static Method _SearchMethod(Class aClass, String selector, Class[] parameterTypes) {
		try {
			return aClass.getMethod(selector, parameterTypes);
		} catch (NoSuchMethodException e) {
			int arraySize = parameterTypes.length - 1;
			Class[] anArray = new Class[arraySize];
			for (int i = 0; i < arraySize; i++) {
				anArray[i] = parameterTypes[i];
			}
			Vector aList = _ListOfPossibleParameterTypes(anArray, parameterTypes[arraySize]);
			for (int i = 0; i < aList.size(); i++) {
				Class[] aPossibleParameterTypes = (Class[]) aList.elementAt(i);
				try {
					return aClass.getMethod(selector, aPossibleParameterTypes);
				} catch (NoSuchMethodException e2) {
					// Just ignore the exception and try another parameter types.
				}
			}
			throw SmalltalkException.MessageNotUnderstood(aClass.getName() + " >> " + selector);
		}
	}
	/**
	 * Answer the method, which name is "selector" and its arguments can be "arguments".
	 *
	 * @return java.lang.reflect.Method
	 * @param selector java.lang.String
	 * @param arguments java.lang.Object[]
	 */
	public Method _searchMethod(String selector, Object[] arguments) {
		return _SearchMethod(this.getClass(), selector, _ParameterTypesOf(arguments));
	}
	/**
	 * 
	 * @param anObject sra.smalltalk.DependentListener
	 */
	public void addDependent_(DependentListener anObject) {
		this.addDependentListener(anObject);
	}
	/**
	 * 
	 * @param anObject sra.smalltalk.DependentListener
	 */
	public synchronized void addDependentListener(DependentListener anObject) {
		Vector myDependentsCopy;
		if (this.myDependents() == null) {
			myDependentsCopy = new Vector();
		} else {
			myDependentsCopy = (Vector)this.myDependents().clone();
		}
		myDependentsCopy.addElement(anObject);
		this.myDependents_(myDependentsCopy);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void breakDependents() {
		myDependents_(null);
	}
	/**
	 * The receiver is changed and broadcast it to my dependents.
	 */
	public void changed() {
		this.changed_(new DependentEvent(this, null, null));
	}
	/**
	 * The receiver is changed.  Broadcast it to my dependents.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void changed_(DependentEvent evt) {
		if (this.myDependents() != null) {
			Vector dependents;
			synchronized (this) {
				dependents = (Vector) this.myDependents().clone();
			}
			int size = dependents.size();
			for (int i = 0; i < size; i++) {
				DependentListener dependent = (DependentListener) dependents.elementAt(i);
				dependent.update_(evt);
			}
		}
	}
	/**
	 * The receiver is changed and broadcast it to my dependents.
	 *
	 * @param anAspect sra.smalltalk.StSymbol
	 */
	public void changed_(StSymbol anAspect) {
		this.changed_(new DependentEvent(this, anAspect, null));
	}
	/**
	 * The receiver is changed.  Broadcast it to my dependents.
	 *
	 * @param anAspect sra.smalltalk.StSymbol
	 * @param aParameter java.lang.Object
	 */
	public void changed_with_(StSymbol anAspect, Object aParameter) {
		this.changed_(new DependentEvent(this, anAspect, aParameter));
	}
	/**
	 * Answer a copy of receiver.
	 *
	 * @return sra.smalltalk.StObject
	 */
	public StObject copy() {
		return this.shallowCopy().postCopy();
	}
	/**
	 * Print out the error message
	 * @param errorMessage java.lang.String
	 */
	public void error_(String errorMessage) {
		System.err.println(errorMessage);
	}
	/**
	 * Arrange to receive a message with aSelector when anAspect
	 * changes at anObject.
	 *
	 * @param anAspect sra.smalltalk.StSymbol
	 * @param anObject sra.smalltalk.StObject
	 * @param aSelector java.lang.String
	 */
	public void expressInterestIn_for_sendBack_(StSymbol anAspect, StObject anObject, String aSelector) {
		StDependencyTransformer dt = new StDependencyTransformer();
		dt.setReceiver_aspect_selector_(anObject, anAspect, aSelector);
		if (this.myDependents() == null || !this.myDependents().contains(dt)) {
			this.addDependent_(dt);
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * @return java.util.Vector
	 */
	public Vector myDependents() {
		return (Vector) DependentsFields.get(this);
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * @param dependents java.util.Vector
	 */
	public void myDependents_(Vector dependents) {
		if (dependents == null) {
			DependentsFields.remove(this);
		} else {
			DependentsFields.put(this, dependents);
		}
	}
	/**
	 * Send the message indicated by "selector" to this object. The
	 * "selector" is the method name.
	 * 
	 * @param dependents java.lang.String
	 * @return dependents java.lang.Object
	 */
	public Object perform_(String aSymbol) {
		Object returnObject = null;
		try {
			Class thisClass = this.getClass();
			Class parameterTypes[] = null;
			Method method = thisClass.getMethod(aSymbol, parameterTypes);
			Object argumentList[] = null;
			returnObject = method.invoke(this, argumentList);
		} catch (Exception e) {
			this.perform_with_(aSymbol,null);
		}
		return returnObject;
	}
	/**
	 * Send the message indicated by "selector" and "argument" to this
	 * object. The "selector" is the method name and its argument is
	 * "argument".
	 *
	 * @return java.lang.Object
	 * @param selector java.lang.String
	 * @param argument java.lang.Object
	 */
	public Object perform_with_(String selector, Object argument) {
		Object[] arguments = { argument };
		return this.perform_withArguments_(selector, arguments);
	}
	/**
	 * Send the message indicated by "selector" and "argument" to this
	 * object. The "selector" is the method name and its arguments are
	 * "argument1" and "argument2".
	 *
	 * @return java.lang.Object
	 * @param selector java.lang.String
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 */
	public Object perform_with_with_(String selector, Object argument1, Object argument2) {
		Object[] arguments = {argument1, argument2};
		return this.perform_withArguments_(selector, arguments);
	}
	/**
	 * Send the message indicated by "selector" and "arguments" to this
	 * object. The "selector" is the method name and its arguments are
	 * the elements of "arguments".
	 *
	 * @return java.lang.Object
	 * @param selector java.lang.String
	 * @param arguments java.lang.Object[]
	 */
	public Object perform_withArguments_(String selector, Object[] arguments) {
		Object theResult = null;
		Method theMethod = this._searchMethod(selector, arguments);
		try {
			theResult = theMethod.invoke(this, arguments);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
		return theResult;
	}
	/**
	 * Do something after a shallow copy.  Subclasses may add
	 * functionality, but they should always do 'super.postCopy()'
	 * first.
	 *
	 * @return sra.smalltalk.StObject
	 */
	public StObject postCopy() {
		return this;
	}
	/**
	 * Print my string representation on aStream.
	 * @param aWriter java.io.OutputStream
	 */
	public void printOn_(OutputStream aStream) throws IOException {
		BufferedWriter aWriter = new BufferedWriter(new OutputStreamWriter(aStream));
		this.printOn_(aWriter);
		aWriter.flush();
	}
	/**
	 * Print my string representation on aWriter.
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("a ");
		aWriter.write(this.getClass().getName());
	}
	/**
	 * Answer printable string of this object.
	 * @return java.lang.String
	 */
	public String printString() {
		try {
			StringWriter aWriter = new StringWriter();
			this.printOn_(aWriter);
			return aWriter.toString();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Create an object based on the contents of aStream.
	 * @param aStream java.io.InputStream
	 */
	public static StObject ReadFrom_(InputStream aStream) throws Exception {
		ObjectInputStream aObjectInputStream = new ObjectInputStream(aStream);
		return (StObject)aObjectInputStream.readObject();
	}
	/**
	 * readObject is called to restore the state of the StObject from a 
	 * input stream.  
	 * It is responsible for implementing the interface serializable.
	 *
	 * @param in java.io.ObjectInputStream
	 */
	private void readObject(ObjectInputStream in) {
		this._getFileds(in);	
	}
	/**
	 * Remove references to objects that may refer to the receiver.
	 */
	public void release() {
		this.breakDependents();
	}
	/**
	 * 
	 * @param anObject sra.smalltalk.DependentListener
	 */
	public void removeDependent_(DependentListener anObject) {
		this.removeDependentListener(anObject);
	}
	/**
	 * 
	 * @param anObject sra.smalltalk.DependentListener
	 */
	public synchronized void removeDependentListener(DependentListener anObject) {
		if (this.myDependents() != null) {
			int indx = this.myDependents().indexOf(anObject);
			if (indx != -1) {
				Vector myDependentsCopy = (Vector)this.myDependents().clone();
				myDependentsCopy.removeElementAt(indx);
				this.myDependents_(myDependentsCopy);
			}
		}
	}
	/**
	 * Answer true if the receiver can accept a method specified with "selector".
	 *
	 * @return boolean
	 * @param selector java.lang.String
	 */
	public boolean respondsTo_(String selector) {
		Method[] methods = this.getClass().getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			if (methods[i].getName().equals(selector)) {
				return true;
			}
		}
		return false;
	}
	/**
	 * Undo a send of expressInterestIn_for_sendBack_().
	 *
	 * @param anAspect sra.smalltalk.StSymbol
	 * @param anObject sra.smalltalk.StObject
	 */
	public void retractInterestIn_for_(StSymbol anAspect, StObject anObject) {
		Vector deps = this.myDependents();
		if (deps == null) {
			return;
		}
		for (int i = 0; i < deps.size(); i++) {
			StObject dep = (StObject) deps.elementAt(i);
			if (dep instanceof StDependencyTransformer) {
				StDependencyTransformer dt = (StDependencyTransformer) dep;
				if (dt.matches_forAspect_(anObject, anAspect)) {
					this.removeDependent_(dt);
				}
			}
		}
	}
	/**
	 * Answer a copy of the receiver which shares the receiver's
	 * instance variables.
	 *
	 * @return sra.smalltalk.StObject
	 */
	public StObject shallowCopy() {
		try {
			return (StObject) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Just output the error message "shouldNotImplement".
	 */
	public void shouldNotImplement() {
		this.error_("shouldNotImplement");
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * @return java.lang.Class
	 */
	public Class species() {
		return this.getClass();
	}
	/**
	 * Store my string representation on aStream.
	 * @param aWriter java.io.OutputStream
	 */
	public void storeOn_(OutputStream aStream) throws IOException {
		ObjectOutputStream aObjectOutputStream = new ObjectOutputStream(aStream);
		aObjectOutputStream.writeObject(this);
		aObjectOutputStream.flush();
	}
	/**
	 * Answer storeable string of this object.
	 * @return java.lang.String
	 */
	public String storeString() {
		try {
			ByteArrayOutputStream aByteArrayOutputStream = new ByteArrayOutputStream();
			this.storeOn_(aByteArrayOutputStream);
			return aByteArrayOutputStream.toString();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Just output the error message "subclassResponsibility".
	 */
	public void subclassResponsibility() throws SmalltalkException {
//		this.error_("subclassResponsibility");
		throw new SmalltalkException();
	}
	/**
	 * Throw an exception which indicate an improper integer was used as an index.
	 *
	 * @param index int
	 */
	public Object subscriptBoundsError_(int index) {
		throw new SmalltalkException("subscriptBoundsError: " + index);
	}
	/**
	 * Answer printable string of this object.
	 * @return java.lang.String
	 */
	public String toString() {
		return this.printString();
	}
	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument evt.getAspect() is typically a Symbol
	 * that indicates what change has occurred.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		// Do nothing as a default.
	}
	/**
	 * WriteObject is called to output the filed of the StObject to a 
	 * output stream.
	 * It is responsible for implementing the interface serializable.
	 *
	 * @param out java.io.ObjectOutputStream
	 */
	private void writeObject(ObjectOutputStream out) {
		this._putFileds(out);	
	}
}