package sra.smalltalk;

import java.util.*;

/**
 * StModel class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/08/05 (by nisinaka)
 * 	@updated:   1998/10/09 (by nisinaka)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StModel.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StModel extends StObject {
	/**
	 *
	 */
	protected Vector dependents = null;
	/**
	 * Convert the receiver's dependents as an array of StObject.
	 *
	 * @return sra.smalltalk.StObject[]
	 */
	public StObject[] _dependentsAsArray() {
		if (dependents == null) {
			return null;
		} else {
			int size = dependents.size();
			StObject[] anArray = new StObject[size];
			dependents.copyInto(anArray);
			return anArray;
		}
	}
	/**
	 * Answer the receiver's dependents.
	 *
	 * @return java.util.Vector
	 */
	public Vector myDependents() {
		return dependents;
	}
	/**
	 * Set the receiver's dependents.
	 *
	 * @param dependentsOrNull java.util.Vector
	 */
	public void myDependents_(Vector dependentsOrNull) {
		dependents = dependentsOrNull;
	}
	/**
	 * Do not copy the dependents list.
	 *
	 * @return sra.smalltalk.StObject
	 */
	public StObject postCopy() {
		super.postCopy();
		this.breakDependents();
		return this;
	}
}