package sra.smalltalk;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Hashtable;
/**
 * StMenuViewForSwing class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/10/01 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StMenuViewForSwing.java,v 3.2 2000/04/07 05:41:28 nisinaka Exp $
 */
public class StMenuViewForSwing implements DependentListener, ActionListener, ItemListener {
	private transient boolean isBroadcasting = false;
	protected StMenu stRootMenu;
	protected JComponent uiRootMenu;
	protected Vector stMenus;
	protected Vector uiMenus;
	protected Hashtable groups;
	/**
	 * Replacement for the # notation of Smalltalk. :-)
	 *
	 * @return sra.smalltalk.StSymbol
	 * @param aString java.lang.String
	 */
	public final static StSymbol $(String aString) {
		return StSymbol.Intern_(aString);
	}
	/**
	 * @param menuBar javax.swing.JMenuBar
	 */
	public StMenuViewForSwing(JMenuBar menuBar) {
		super();
		uiRootMenu = menuBar;
	}
	/**
	 * @param popupMenu javax.swing.JPopupMenu
	 */
	public StMenuViewForSwing(JPopupMenu popupMenu) {
		super();
		uiRootMenu = popupMenu;
	}
	/**
	 * Invoked when a menu item has been selected. 
	 *
	 * @param ev java.awt.event.ActionEvent 
	 */
	public void actionPerformed(ActionEvent ev) {
		StMenuItem anItem = getMenu((JMenuItem) ev.getSource());
		anItem.action();
	}
	/**
	 * @param stMenu sra.smalltalk.StMenuItem
	 * @param uiMenu javax.swing.JMenuItem
	 */
	protected void addMenu(StMenuItem stMenu, JMenuItem uiMenu) {
		stMenus.addElement(stMenu);
		uiMenus.addElement(uiMenu);
	}
	/**
	 */
	protected void clearMenuTable() {
		stMenus = new Vector();
		uiMenus = new Vector();
		groups = new Hashtable();
	}
	/**
	 * @return javax.swing.JFrame
	 * @param app sra.smalltalk.StApplicationModel
	 * @param view sra.smalltalk.StView
	 */
	public final static JFrame CreateJFrame(StApplicationModel app, StView view) {
		JFrame aFrame = new JFrame(app.windowTitle());
		aFrame.getContentPane().add((JComponent) view);
		aFrame.pack();
		StMenuModel menuModel = app.menuModel();
		if (menuModel != null) {
			JMenuBar aMenuBar = new JMenuBar();
			StMenuViewForSwing aMenuView = new StMenuViewForSwing(aMenuBar);
			aMenuView.setModel(menuModel);
			aFrame.setJMenuBar(aMenuBar);
		}
		//
		if (app.windowResizable() == false) {
			aFrame.setResizable(false);
		}
		aFrame.pack();
		aFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		app.builder().addFrame_(aFrame);
		return aFrame;
	}
	/**
	 * @param menu sra.smalltalk.StMenu
	 * @return javax.swing.JPopupMenu
	 */
	public final static JPopupMenu CreateJPopupMenu(StMenu menu) {
		JPopupMenu popupMenu = new JPopupMenu();
		StMenuViewForSwing aMenuView = new StMenuViewForSwing(popupMenu);
		aMenuView.setModel(menu);
		return popupMenu;
	}
	/**
	 * @param stMenu sra.smalltalk.StMenuItem
	 * @return javax.swing.JMenuItem
	 */
	protected ButtonGroup getGroup(StButtonGroup stGroup) {
		ButtonGroup uiGroup = (ButtonGroup) groups.get(stGroup);
		if (uiGroup == null) {
			uiGroup = new ButtonGroup();
			groups.put(stGroup, uiGroup);
		}
		return uiGroup;
	}
	/**
	 * @param javax.swing.JMenuItem
	 * @return sra.smalltalk.StMenuItem
	 */
	protected StMenuItem getMenu(JMenuItem uiMenu) {
		int i = uiMenus.indexOf(uiMenu);
		return (StMenuItem) stMenus.elementAt(i);
	}
	/**
	 * @param stMenu sra.smalltalk.StMenuItem
	 * @return javax.swing.JMenuItem
	 */
	protected JMenuItem getMenu(StMenuItem stMenu) {
		int i = stMenus.indexOf(stMenu);
		return (JMenuItem) uiMenus.elementAt(i);
	}
	/**
	 * Answer a model.
	 *
	 * @return sra.smalltalk.StMenu
	 */
	public StMenu getModel() {
		return stRootMenu;
	}
	/**
	 * Invoked when an item has been selected or deselected.
	 */
	public void itemStateChanged(ItemEvent e) {
		if (isBroadcasting) {
			return;
		}
		StMenuItem menuItem = getMenu((JMenuItem) e.getSource());
		boolean selected = (e.getStateChange() == e.SELECTED);
		ActionEvent action = new ActionEvent(e.getSource(), e.getID(), menuItem.getActionCommand());
		if (menuItem instanceof StRadioButtonMenuItem) {
			StRadioButtonMenuItem anItem = (StRadioButtonMenuItem) menuItem;
			anItem.selected_(selected);
		} else {
			// StCheckBoxMenuItem
			StCheckBoxMenuItem anItem = (StCheckBoxMenuItem) menuItem;
			anItem.selected_(selected);
		}
	}
	/**
	 * @param stMenu sra.smalltalk.StMenu
	 * @param uiMenu javax.swing.JMenu
	 */
	protected void makeSubMenu(StMenu stMenu, JMenu uiMenu) {
		for (int i = 0; i < stMenu.getItems().size(); i++) {
			StMenuItem stSubMenu = stMenu.getItem(i);
			if (stSubMenu == null) {
				// Separator
				uiMenu.addSeparator();
			} else if (stSubMenu instanceof StMenu) {
				JMenu uiSubMenu = new JMenu(stSubMenu.label);
				uiMenu.add(uiSubMenu);
				addMenu(stSubMenu, uiSubMenu);
				//
				makeSubMenu((StMenu) stSubMenu, uiSubMenu);
			} else if (stSubMenu instanceof StRadioButtonMenuItem) {
				boolean isSelected = ((StRadioButtonMenuItem) stSubMenu).isSelected();
				JRadioButtonMenuItem uiSubMenu = new JRadioButtonMenuItem(stSubMenu.label, isSelected);
				uiSubMenu.setEnabled(stSubMenu.isEnabled());
				StButtonGroup stGroup = ((StRadioButtonMenuItem) stSubMenu).getGroup();
				getGroup(stGroup).add(uiSubMenu);
				uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
				uiSubMenu.addItemListener(this);
				uiSubMenu.addActionListener(this);
				uiMenu.add(uiSubMenu);
				addMenu(stSubMenu, uiSubMenu);
			} else if (stSubMenu instanceof StCheckBoxMenuItem) {
				boolean isSelected = ((StCheckBoxMenuItem) stSubMenu).isSelected();
				JCheckBoxMenuItem uiSubMenu = new JCheckBoxMenuItem(stSubMenu.label, isSelected);
				uiSubMenu.setEnabled(stSubMenu.isEnabled());
				uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
				uiSubMenu.addItemListener(this);
				uiSubMenu.addActionListener(this);
				uiMenu.add(uiSubMenu);
				addMenu(stSubMenu, uiSubMenu);
			} else {
				JMenuItem uiSubMenu = new JMenuItem(stSubMenu.label);
				uiSubMenu.setEnabled(stSubMenu.isEnabled());
				uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
				uiSubMenu.addActionListener(this);
				uiMenu.add(uiSubMenu);
				addMenu(stSubMenu, uiSubMenu);
			}
		}
	}
	/**
	 * Rebuild this component.
	 */
	protected void rebuildComponent() {
		clearMenuTable();
		if (uiRootMenu instanceof JPopupMenu) {
			JPopupMenu uiMenu = (JPopupMenu) uiRootMenu;
			for (int i = 0; i < getModel().getItems().size(); i++) {
				StMenuItem stSubMenu = getModel().getItem(i);
				if (stSubMenu == null) {
					// Separator
					uiMenu.addSeparator();
				} else if (stSubMenu instanceof StMenu) {
					JMenu uiSubMenu = new JMenu(stSubMenu.label);
					uiMenu.add(uiSubMenu);
					addMenu(stSubMenu, uiSubMenu);
					//
					makeSubMenu((StMenu) stSubMenu, uiSubMenu);
				} else if (stSubMenu instanceof StRadioButtonMenuItem) {
					boolean isSelected = ((StRadioButtonMenuItem) stSubMenu).isSelected();
					JRadioButtonMenuItem uiSubMenu = new JRadioButtonMenuItem(stSubMenu.label, isSelected);
					StButtonGroup stGroup = ((StRadioButtonMenuItem) stSubMenu).getGroup();
					getGroup(stGroup).add(uiSubMenu);
					uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
					uiSubMenu.addItemListener(this);
					uiSubMenu.addActionListener(this);
					uiMenu.add(uiSubMenu);
					addMenu(stSubMenu, uiSubMenu);
				} else if (stSubMenu instanceof StCheckBoxMenuItem) {
					boolean isSelected = ((StCheckBoxMenuItem) stSubMenu).isSelected();
					JCheckBoxMenuItem uiSubMenu = new JCheckBoxMenuItem(stSubMenu.label, isSelected);
					uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
					uiSubMenu.addItemListener(this);
					uiSubMenu.addActionListener(this);
					uiMenu.add(uiSubMenu);
					addMenu(stSubMenu, uiSubMenu);
				} else {
					JMenuItem uiSubMenu = new JMenuItem(stSubMenu.label);
					uiSubMenu.setActionCommand(stSubMenu.getActionCommand());
					uiSubMenu.addActionListener(this);
					uiMenu.add(uiSubMenu);
					addMenu(stSubMenu, uiSubMenu);
				}
			}
		} else {
			for (int i = 0; i < getModel().getItems().size(); i++) {
				StMenu stMenu = (StMenu) getModel().getItem(i);
				JMenu uiMenu = new JMenu(stMenu.label);
				((JMenuBar) uiRootMenu).add(uiMenu);
				addMenu(stMenu, uiMenu);
				makeSubMenu(stMenu, uiMenu);
			}
		}
	}
	/**
	 * @param aModel sra.smalltalk.StMenu
	 */
	public void setModel(StMenu aModel) {
		stRootMenu = aModel;
		((StMenuModel) stRootMenu.getRoot()).addDependentListener(this);
		this.rebuildComponent();
	}
	/**
	 * 
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		StMenuItem stMenu = (StMenuItem) evt.getParameter();
		JMenuItem uiMenu = getMenu(stMenu);
		StSymbol aspect = evt.getAspect();
		if (aspect == $("selected")) {
			isBroadcasting = true;
			uiMenu.setSelected(true);
			isBroadcasting = false;
		} else if (aspect == $("deselected")) {
			isBroadcasting = true;
			uiMenu.setSelected(false);
			isBroadcasting = false;
		} else if (aspect == $("enabled")) {
			uiMenu.setEnabled(true);
		} else if (aspect == $("disable")) {
			uiMenu.setEnabled(false);
		}
	}
}