package sra.smalltalk;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
/**
 * StMenuViewForAwt class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/09/16 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StMenuViewForAwt.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StMenuViewForAwt implements DependentListener, ActionListener, ItemListener {
	private transient boolean isBroadcasting = false;
	protected StMenu stRootMenu;
	protected MenuComponent uiRootMenu;
	protected Vector stMenus;
	protected Vector uiMenus;
	/**
	 * Replacement for the # notation of Smalltalk. :-)
	 *
	 * @return sra.smalltalk.StSymbol
	 * @param aString java.lang.String
	 */
	public final static StSymbol $(String aString) {
		return StSymbol.Intern_(aString);
	}
	/**
	 * @param menuBar java.awt.MenuBar
	 */
	public StMenuViewForAwt(MenuBar menuBar) {
		super();
		uiRootMenu = menuBar;
	}
	/**
	 * @param popupMenu java.awt.PopupMenu
	 */
	public StMenuViewForAwt(PopupMenu popupMenu) {
		super();
		uiRootMenu = popupMenu;
	}
	/**
	 * Invoked when a menu item has been selected. 
	 *
	 * @param ev java.awt.event.ActionEvent 
	 */
	public void actionPerformed(ActionEvent ev) {
		StMenuItem anItem = getMenu((MenuItem) ev.getSource());
		anItem.action();
	}
	/**
	 * @param stMenu sra.smalltalk.StMenuItem
	 * @param uiMenu java.awt.MenuItem
	 */
	protected void addMenu(StMenuItem stMenu, MenuItem uiMenu) {
		stMenus.addElement(stMenu);
		uiMenus.addElement(uiMenu);
	}
	/**
	 */
	protected void clearMenuTable() {
		stMenus = new Vector();
		uiMenus = new Vector();
	}
	/**
	 * @return java.awt.Frame
	 * @param app sra.smalltalk.StApplicationModel
	 * @param view sra.smalltalk.StView
	 */
	public final static Frame CreateFrame(StApplicationModel app, StView view) {
		Frame aFrame = new Frame(app.windowTitle());
		aFrame.add((Component) view);
		aFrame.pack();
		StMenuModel menuModel = app.menuModel();
		if (menuModel != null) {
			MenuBar aMenuBar = new MenuBar();
			StMenuViewForAwt aMenuView = new StMenuViewForAwt(aMenuBar);
			aMenuView.setModel(menuModel);
			aFrame.setMenuBar(aMenuBar);
		}
		//
		if (app.windowResizable() == false) {
			aFrame.setResizable(false);
		}
		aFrame.pack();
		app.builder().addFrame_(aFrame);
		return aFrame;
	}
	/**
	 * @param menu sra.smalltalk.StMenu
	 * @return java.awt.PopupMenu
	 */
	public final static PopupMenu CreatePopupMenu(StMenu menu) {
		PopupMenu popupMenu = new PopupMenu();
		StMenuViewForAwt aMenuView = new StMenuViewForAwt(popupMenu);
		aMenuView.setModel(menu);
		return popupMenu;
	}
	/**
	 * @param java.awt.MenuItem
	 * @return sra.smalltalk.StMenuItem
	 */
	protected StMenuItem getMenu(MenuItem uiMenu) {
		int i = uiMenus.indexOf(uiMenu);
		return (StMenuItem) stMenus.elementAt(i);
	}
	/**
	 * @return java.awt.MenuItem
	 * @param stMenu sra.smalltalk.StMenuItem
	 */
	protected MenuItem getMenu(StMenuItem stMenu) {
		int i = stMenus.indexOf(stMenu);
		return (MenuItem) uiMenus.elementAt(i);
	}
	/**
	 * Answer a model.
	 *
	 * @return sra.smalltalk.StMenu
	 */
	public StMenu getModel() {
		return stRootMenu;
	}
	/**
	 * Invoked when an item has been selected or deselected.
	 */
	public void itemStateChanged(ItemEvent e) {
		if (isBroadcasting) {
			return;
		}
		StMenuItem menuItem = getMenu((MenuItem) e.getSource());
		boolean selected = (e.getStateChange() == e.SELECTED);
		ActionEvent action = new ActionEvent(e.getSource(), e.getID(), menuItem.getActionCommand());
		if (menuItem instanceof StRadioButtonMenuItem) {
			if (selected) {
				StRadioButtonMenuItem anItem = (StRadioButtonMenuItem) menuItem;
				anItem.setSelected(selected);
				anItem.action();
			} else {
				((CheckboxMenuItem) e.getSource()).setState(true);
			}
		} else {
			// StCheckBoxMenuItem
			StCheckBoxMenuItem anItem = (StCheckBoxMenuItem) menuItem;
			anItem.setSelected(selected);
			anItem.action();
		}
	}
	/**
	 * @param stItem sra.smalltalk.StMenu
	 * @param awtItem java.awt.Menu
	 */
	protected void makeSubMenu(StMenu stMenu, Menu awtMenu) {
		for (int i = 0; i < stMenu.getItems().size(); i++) {
			StMenuItem stSubMenu = stMenu.getItem(i);
			if (stSubMenu == null) {
				// Separator
				awtMenu.addSeparator();
			} else if (stSubMenu instanceof StMenu) {
				Menu awtSubMenu = new Menu(stSubMenu.label);
				awtMenu.add(awtSubMenu);
				addMenu(stSubMenu, awtSubMenu);
				//
				makeSubMenu((StMenu) stSubMenu, awtSubMenu);
			} else if (stSubMenu instanceof StRadioButtonMenuItem) {
				boolean isSelected = ((StRadioButtonMenuItem) stSubMenu).isSelected();
				CheckboxMenuItem awtSubMenu = new CheckboxMenuItem(stSubMenu.label, isSelected);
				awtSubMenu.setEnabled(stSubMenu.isEnabled());
				awtSubMenu.setActionCommand(stSubMenu.getActionCommand());
				awtSubMenu.addItemListener(this);
				awtMenu.add(awtSubMenu);
				addMenu(stSubMenu, awtSubMenu);
			} else if (stSubMenu instanceof StCheckBoxMenuItem) {
				boolean isSelected = ((StCheckBoxMenuItem) stSubMenu).isSelected();
				CheckboxMenuItem awtSubMenu = new CheckboxMenuItem(stSubMenu.label, isSelected);
				awtSubMenu.setEnabled(stSubMenu.isEnabled());
				awtSubMenu.setActionCommand(stSubMenu.getActionCommand());
				awtSubMenu.addItemListener(this);
				awtMenu.add(awtSubMenu);
				addMenu(stSubMenu, awtSubMenu);
			} else {
				MenuItem awtSubMenu = new MenuItem(stSubMenu.label);
				awtSubMenu.setEnabled(stSubMenu.isEnabled());
				awtSubMenu.setActionCommand(stSubMenu.getActionCommand());
				awtSubMenu.addActionListener(this);
				awtMenu.add(awtSubMenu);
				addMenu(stSubMenu, awtSubMenu);
			}
		}
	}
	/**
	 * Rebuild this component.
	 */
	protected void rebuildComponent() {
		clearMenuTable();
		if (uiRootMenu instanceof PopupMenu) {
			makeSubMenu(getModel(), (PopupMenu) uiRootMenu);
		} else {
			for (int i = 0; i < getModel().getItems().size(); i++) {
				StMenu stMenu = (StMenu) getModel().getItem(i);
				Menu awtMenu = new Menu(stMenu.label);
				((MenuBar) uiRootMenu).add(awtMenu);
				addMenu(stMenu, awtMenu);
				makeSubMenu(stMenu, awtMenu);
			}
		}
	}
	/**
	 * @param aModel sra.smalltalk.StMenuModel
	 */
	public void setModel(StMenu aModel) {
		stRootMenu = aModel;
		((StMenuModel) stRootMenu.getRoot()).addDependentListener(this);
		this.rebuildComponent();
	}
	/**
	 * 
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		StMenuItem stMenu = (StMenuItem) evt.getParameter();
		MenuItem awtMenu = getMenu(stMenu);
		StSymbol aspect = evt.getAspect();
		if (aspect == $("selected")) {
			isBroadcasting = true;
			((CheckboxMenuItem) awtMenu).setState(true);
			isBroadcasting = false;
		} else if (aspect == $("deselected")) {
			isBroadcasting = true;
			((CheckboxMenuItem) awtMenu).setState(false);
			isBroadcasting = false;
		} else if (aspect == $("enabled")) {
			awtMenu.setEnabled(true);
		} else if (aspect == $("disable")) {
			awtMenu.setEnabled(false);
		}
	}
}
