package sra.smalltalk;

import java.awt.event.*;
import java.util.*;
/**
 * StMenuModel class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/09/16 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StMenuModel.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StMenuModel extends StMenu {
	protected Vector dependents = new Vector();
	/**
	 *
	 */
	public StMenuModel() {
		super(null);
	}
	/**
	 * 
	 * @param anObject sra.smalltalk.DependentListener
	 */
	public synchronized void addDependentListener(DependentListener anObject) {
		dependents.addElement(anObject);
	}
	/**
	 *
	 */
	public void addSeparator() {
	}
	/**
	 * The receiver is changed.  Broadcast it to my dependents.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void changed_(DependentEvent evt) {
		Vector fireDependents;
		synchronized (this) {
			fireDependents = (Vector) dependents.clone();
		}
		int size = fireDependents.size();
		for (int i = 0; i < size; i++) {
			DependentListener dependent = (DependentListener) fireDependents.elementAt(i);
			dependent.update_(evt);
		}
	}
	/**
	 * The receiver is changed.  Broadcast it to my dependents.
	 *
	 * @param anAspect sra.smalltalk.StSymbol
	 * @param aParameter java.lang.Object
	 */
	public void changed_with_(StSymbol anAspect, Object aParameter) {
		this.changed_(new DependentEvent(this, anAspect, aParameter));
	}
	/**
	 * 
	 * @param anObject sra.smalltalk.DependentListener
	 */
	public synchronized void removeDependentListener(DependentListener anObject) {
		dependents.removeElement(anObject);
	}
}