package sra.smalltalk;

import java.awt.event.*;
import java.util.Vector;
/**
 * StMenuItem class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/09/16 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StMenuItem.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StMenuItem {
	private Vector actionlisteners;
	protected String label;
	protected String actionCommand;
	protected boolean enabled = true;
	protected StMenu parent;
	/**
	 * Replacement for the # notation of Smalltalk. :-)
	 *
	 * @return sra.smalltalk.StSymbol
	 * @param aString java.lang.String
	 */
	public final static StSymbol $(String aString) {
		return StSymbol.Intern_(aString);
	}
	/**
	 * Creates a menuItem with label.
	 *
	 * @param aLabel java.lang.String
	 */
	public StMenuItem(String aLabel) {
		super();
		label = aLabel;
	}
	/**
	 *
	 */
	public void action() {
		fireActionPerformed(new ActionEvent(this,
			ActionEvent.ACTION_PERFORMED, getActionCommand()));
	}
	/**
	 * adds an ActionListener to the button
	 */
	public synchronized void addActionListener(ActionListener l) {
		if (actionlisteners == null) {
			actionlisteners = new Vector();
		}
		actionlisteners.addElement(l);
	}
	/**
	 * Invoked when a menu item has been selected. 
	 *
	 * @param e java.awt.event.ActionEvent 
	 */
	protected void fireActionPerformed(ActionEvent event) {
		if (actionlisteners == null) {
			return;
		}
		Vector copy;
		synchronized (actionlisteners) {
			copy = (Vector) actionlisteners.clone();
		}
		for (int i = 0; i < copy.size(); i++) {
			ActionListener l = (ActionListener) copy.elementAt(i);
			l.actionPerformed(event);
		}
	}
	/**
	 * Returns the command string associated with this action.
	 *
	 * @return java.lang.String
	 */
	public String getActionCommand() {
		return actionCommand;
	}
	/**
	 * @return sra.smalltalk.StMenu
	 */
	protected StMenu getParent() {
		return parent;
	}
	/**
	 * @return sra.smalltalk.StMenuModel
	 */
	protected StMenuItem getRoot() {
		StMenuItem current = this;
		StMenuItem parent = getParent();
		while (parent != null) {
			current = parent;
			parent = current.getParent();
		}
		return current;
	}
	/**
	 *
	 *
	 * @return boolean
	 */
	public boolean isEnabled() {
		return enabled;
	}
	/**
	 * removes an ActionListener from the button
	 */
	public void removeActionListener(ActionListener l) {
		actionlisteners.removeElement(l);
	}
	/**
	 * Sets the command name of the action event that is fired
	 * by this menu item.
	 *
	 * @param command java.lang.String
	 */
	public void setActionCommand(String command) {
		actionCommand = command;
	}
	/**
	 * Enable or disable the menu item.
	 *
	 * @param aBoolean boolean
	 */
	public void setEnabled(boolean aBoolean) {
		if (enabled != aBoolean) {
			enabled = aBoolean;
			StSymbol aspect = enabled ? $("enabled") : $("disable");
			StMenuItem root = getRoot();
			if (root instanceof StMenuModel) {
				((StMenuModel) root).changed_with_(aspect, this);
			}
		}
	}
	/**
	 * @param aMenu sra.smalltalk.StMenu
	 */
	protected void setParent(StMenu aMenu) {
		parent = aMenu;
	}
}