package sra.smalltalk;

import java.util.*;
/**
 * StMenu class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/09/16 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StMenu.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StMenu extends StMenuItem {
	protected Vector children = new Vector();
	/**
	 * StMenu constructor comment.
	 * @param aLabel java.lang.String
	 */
	public StMenu(String aLabel) {
		super(aLabel);
	}
	/**
	 * @param aMenu sra.smalltalk.StMenuItem
	 */
	public void add(StMenuItem aMenu) {
		children.addElement(aMenu);
		aMenu.setParent(this);
	}
	/**
	 * Adds a separator line.
	 */
	public void addSeparator() {
		children.addElement(null);
	}
	/**
	 * Gets the item located at the specified index of this menu.
	 *
	 * @param index int
	 * @return sra.smalltalk.StMenuItem
	 */
	public StMenuItem getItem(int index) {
		if (index < 0 || children.size() <= index) {
			return null;
		}
		return (StMenuItem) children.elementAt(index);
	}
	/**
	 * Gets the item located at the specified label of this menu.
	 *
	 * @param label java.lang.String
	 * @return sra.smalltalk.StMenuItem
	 */
	public StMenuItem getItem(String label) {
		for (int i = 0; i < children.size(); i++) {
			StMenuItem item = (StMenuItem) children.elementAt(i);
			if (item != null && label.equals(item.label)) {
				return item;
			}
		}
		return null;
	}
	/**
	 * Gets the children items.
	 *
	 * @return java.util.Vector
	 */
	public Vector getItems() {
		return children;
	}
}