package sra.smalltalk;

/**
 * StIntervalTestExamples class
 * 
 * 	@author:    NISHIHARA Satoshi
 * 	@created:   2000/01/13 (by NISHIHARA Satoshi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 *
 * 	$Id: StIntervalTestExamples.java,v 3.1 2000/04/07 05:41:10 nisinaka Exp $
 */
public class StIntervalTestExamples extends SmalltalkTestExamples {
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		StInterval interval;
		interval = StInterval.From_to_by_(0, 10, 1);
		System.out.println("interval: " + interval);
		System.out.println("first: " + interval.first());
		System.out.println("last: " + interval.last());
		System.out.println("increment: " + interval.increment());
		System.out.println("size: " + interval.size());
		System.out.println("at_(4): " + interval.at_(4));

		StBlockClosure block = new StBlockClosure() {
			public Object value_(Object valueObject) {
				double value = ((Double) valueObject).doubleValue();
				System.out.println(value);
				return null;
			};
		};
		StBlockClosure collectBlock = new StBlockClosure() {
			public Object value_(Object valueObject) {
				double value = ((Double) valueObject).doubleValue();
				return new Double(value * 5);
			};
		};

		interval.do_(block);
		interval.reverseDo_(block);
		double[] collect = interval.collect_(collectBlock);
		for (int i = 0; i < collect.length; i++) {
			System.out.println(i + ": " + collect[i]);
		}
		return true;
	}
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		StInterval interval;
		interval = new StInterval(0, 10);
		System.out.println("interval: " + interval);
		System.out.println("first: " + interval.first());
		System.out.println("last: " + interval.last());
		System.out.println("increment: " + interval.increment());
		System.out.println("size: " + interval.size());
		System.out.println("at_(4): " + interval.at_(4));

		StBlockClosure block = new StBlockClosure() {
			public Object value_(Object valueObject) {
				double value = ((Double) valueObject).doubleValue();
				System.out.println(value);
				return null;
			};
		};
		StBlockClosure collectBlock = new StBlockClosure() {
			public Object value_(Object valueObject) {
				double value = ((Double) valueObject).doubleValue();
				return new Double(value * 5);
			};
		};

		interval.do_(block);
		interval.reverseDo_(block);
		double[] collect = interval.collect_(collectBlock);
		for (int i = 0; i < collect.length; i++) {
			System.out.println(i + ": " + collect[i]);
		}
		return true;
	}
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		StInterval interval;
		interval = new StInterval(20, 10, -0.5);
		System.out.println("interval: " + interval);
		System.out.println("first: " + interval.first());
		System.out.println("last: " + interval.last());
		System.out.println("increment: " + interval.increment());
		System.out.println("size: " + interval.size());
		System.out.println("at_(4): " + interval.at_(4));
		System.out.println("at_(interval.size() - 1): " + interval.at_(interval.size() - 1));

		StBlockClosure block = new StBlockClosure() {
			public Object value_(Object valueObject) {
				double value = ((Double) valueObject).doubleValue();
				System.out.println(value);
				return null;
			};
		};
		StBlockClosure collectBlock = new StBlockClosure() {
			public Object value_(Object valueObject) {
				double value = ((Double) valueObject).doubleValue();
				return new Double(value * 5);
			};
		};

		interval.do_(block);
		interval.reverseDo_(block);
		double[] collect = interval.collect_(collectBlock);
		for (int i = 0; i < collect.length; i++) {
			System.out.println(i + ": " + collect[i]);
		}
		return true;
	}
	/**
	 * Execute all examples.
	 * @param args java.lang.String[]
	 */
	public static void main(String args[]) {
		new StIntervalTestExamples();
	}
}