package sra.smalltalk;

import java.awt.*;
import java.awt.event.*;
import java.io.File;

/**
 * StDialog class
 * 
 * 	@author:    Hirotsugu Kondo
 * 	@created:   1998/11/11 (by Hirotsugu Kondo)
 * 	@updated:   1999/07/02 (by nisinaka)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StDialog.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StDialog implements ActionListener {
	protected Dialog dialog;
	protected boolean accepted;
	protected String value;
	protected TextField textField;

	protected static String lastDirectory = null;
	/**
	 * Default constructor.
	 */
	public StDialog() {
		this(SystemResourceSupport.getFrame());
	}
	/**
	 * Default constructor.
	 */
	public StDialog(Frame aFrame) {
		super();
		dialog = new Dialog(aFrame, "", true);
	}
	/**
	 * @return java.awt.Button
	 */
	protected Button _closeCancelButton() {
		Button yesButton = new Button("Cancel");
		yesButton.addActionListener(this);
		return yesButton;
	}
	/**
	 * @return java.awt.Button
	 */
	protected Button _closeOKButton() {
		Button yesButton = new Button("OK");
		yesButton.addActionListener(this);
		return yesButton;
	}
	/**
	 * Answer the center point of the screen.
	 *
	 * @return Point
	 */
	protected static Point _getCenterPoint() {
		Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
		return new Point(dimension.width / 2, dimension.height / 2);
	}
	/**
	 * @return java.awt.Panel
	 */
	protected Panel _okCancelButtons() {
		Button yesButton = new Button("OK");
		yesButton.addActionListener(this);
		Button noButton = new Button("Cancel");
		noButton.addActionListener(this);
		//
		Panel panel = new Panel();
		panel.add("West", yesButton);
		panel.add("East", noButton);
		return panel;
	}
	/**
	 * Dialog standard handling for JAVA.
	 *
	 * @param dialog java.awt.Dialog
	 * @param point java.awt.Point
	 */
	protected void _showDialog(Point point) {
		//dialog.setResizable(false);
		dialog.pack();
		Rectangle bounds = dialog.getBounds();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		int originX = Math.max(0, Math.min(point.x - bounds.width / 2, screenSize.width - bounds.width));
		int originY = Math.max(0, Math.min(point.y - bounds.height / 2, screenSize.height - bounds.height));
		dialog.setBounds(originX, originY, bounds.width, bounds.height);
		dialog.show();
	}
	/**
	 * @return java.awt.Panel
	 */
	protected Panel _yesNoButtons() {
		Button yesButton = new Button("Yes");
		yesButton.addActionListener(this);
		Button noButton = new Button("No");
		noButton.addActionListener(this);
		//
		Panel panel = new Panel();
		panel.add("West", yesButton);
		panel.add("East", noButton);
		return panel;
	}
	/**
	 * Invoked when an action occurs.
	 */
	public void actionPerformed(ActionEvent e) {
		String buttonLabel = e.getActionCommand();
		if (buttonLabel.equals("Yes") || buttonLabel.equals("OK")) {
			accepted = true;
			value = textField != null ? textField.getText() : null;
		} else if (buttonLabel.equals("No") || buttonLabel.equals("Cancel")) {
			accepted = false;
		}
		dialog.dispose();
	}
	/**
	 * @return boolean
	 * @param messageString java.lang.String
	 */
	public static boolean Confirm_(String messageString) {
		return Confirm_(messageString, _getCenterPoint());
	}
	/**
	 * @return boolean
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 */
	public static boolean Confirm_(String messageString, Point point) {
		return Confirm_(messageString, true, point);
	}
	/**
	 * @return boolean
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 */
	public static boolean Confirm_(String messageString, boolean initialAnswer) {
		return Confirm_(messageString, initialAnswer, _getCenterPoint());
	}
	/**
	 * @return boolean
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 * @param point java.awt.Point
	 */
	public boolean confirm_(String messageString, boolean initialAnswer, Point point) {
		dialog.add("Center", new Label(messageString, Label.CENTER));
		dialog.add("South", this._yesNoButtons());
		this._showDialog(point);
		return accepted;
	}
	/**
	 * @return boolean
	 * @param messageString java.lang.String
	 * @param initialAnswer boolean
	 * @param point java.awt.Point
	 */
	public static boolean Confirm_(String messageString, boolean initialAnswer, Point point) {
		StDialog aDialog = new StDialog();
		return aDialog.confirm_(messageString, initialAnswer, point);
	}
	/**
	 * @return java.io.File
	 */
	public static File OpenFileDialog() {
		return OpenFileDialog_default_("", null);
	}
	/**
	 * @return java.io.File
	 * @param messageString java.lang.String
	 */
	public static File OpenFileDialog_(String messageString) {
		return OpenFileDialog_default_(messageString, null);
	}
	/**
	 * @return java.io.File
	 * @param messageString java.lang.String
	 * @param defaultFilename java.lang.String
	 */
	public static File OpenFileDialog_default_(String messageString, String defaultFilename) {
		FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), messageString);
		if (lastDirectory != null) {
			fileDialog.setDirectory(lastDirectory);
		};
		if ((defaultFilename != null) | (defaultFilename == "")) {
			fileDialog.setFile(defaultFilename);
		};
		fileDialog.show();
		String directory = fileDialog.getDirectory();
		String filename = fileDialog.getFile();
		if (directory == null || filename == null)
			return null;
		lastDirectory = directory;
		return new File(directory, filename);
	}
	/**
	 * @return java.lang.String
	 * @param messageString java.lang.String
	 */
	public static String Request_(String messageString) {
		return Request_(messageString, _getCenterPoint());
	}
	/**
	 * @return java.lang.String
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 */
	public static String Request_(String messageString, Point point) {
		return Request_(messageString, "", point);
	}
	/**
	 * @return java.lang.String
	 * @param messageString java.lang.String
	 * @param initialAnswer java.lang.String
	 */
	public static String Request_(String messageString, String initialAnswer) {
		return Request_(messageString, initialAnswer, _getCenterPoint());
	}
	/**
	 * @return java.lang.String
	 * @param messageString java.lang.String
	 * @param initialAnswer java.lang.String
	 * @param point java.awt.Point
	 */
	public String request_(String messageString, String initialAnswer, Point point) {
		dialog.setLayout(new GridLayout(3, 1));
		textField = new TextField(20);
		textField.setText(initialAnswer);
		dialog.add(new Label(messageString, Label.CENTER));
		dialog.add(textField);
		dialog.add(this._okCancelButtons());
		this._showDialog(point);
		return value;
	}
	/**
	 * @return java.lang.String
	 * @param messageString java.lang.String
	 * @param initialAnswer java.lang.String
	 * @param point java.awt.Point
	 */
	public static String Request_(String messageString, String initialAnswer, Point point) {
		StDialog aDialog = new StDialog();
		return aDialog.request_(messageString, initialAnswer, point);
	}
	/**
	 * @return java.io.File
	 */
	public static File SaveFileDialog() {
		return SaveFileDialog_default_("", null);
	}
	/**
	 * @return java.io.File
	 * @param messageString java.lang.String
	 */
	public static File SaveFileDialog_(String messageString) {
		return SaveFileDialog_default_(messageString, null);
	}
	/**
	 * @return java.io.File
	 * @param messageString java.lang.String
	 * @param defaultFilename java.lang.String
	 */
	public static File SaveFileDialog_default_(String messageString, String defaultFilename) {
		FileDialog fileDialog = new FileDialog(SystemResourceSupport.getFrame(), "", FileDialog.SAVE);
		if (lastDirectory != null) {
			fileDialog.setDirectory(lastDirectory);
		};
		if ((defaultFilename != null) | (defaultFilename == "")) {
			fileDialog.setFile(defaultFilename);
		};
		fileDialog.show();
		String directory = fileDialog.getDirectory();
		String filename = fileDialog.getFile();
		if (directory == null || filename == null) {
			return null;
		}
		lastDirectory = directory;
		return new File(directory, filename);
	}
	/*
	 * @param messageString java.lang.String
	 */
	public static void Warn_(String messageString) {
		Warn_(messageString, _getCenterPoint());
	}
	/*
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 */
	public void warn_(String messageString, Point point) {
		dialog.add("Center", new Label(messageString, Label.CENTER));
		dialog.add("South", this._closeOKButton());
		this._showDialog(point);
	}
	/*
	 * @param messageString java.lang.String
	 * @param point java.awt.Point
	 */
	public static void Warn_(String messageString, Point point) {
		StDialog aDialog = new StDialog();
		aDialog.warn_(messageString, point);
	}
}
