package sra.smalltalk;

/**
 * StDependencyTransformer class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/14 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StDependencyTransformer.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StDependencyTransformer extends StObject {
	protected StObject receiver = null;
	protected StSymbol aspect = null;
	protected String selector = null;
	protected int numArguments;
	/**
	 * Answer the number of arguments of a selector aSymbol.
	 *
	 * @return int
	 * @param aSymbol java.lang.String
	 */
	public static int _NumArgs(String aSymbol) {
		int number = 0;
		for (int i = 0; i < aSymbol.length(); i++) {
			if (aSymbol.charAt(i) == '_') {
				number++;
			}
		}
		return number;
	}
	/**
	 * Answer true if the receiver matches the condition specified with the arguments.
	 *
	 * @return boolean
	 * @param anObject sra.smalltalk.StObject
	 * @param anAspect sra.smalltalk.StSymbol
	 */
	public boolean matches_forAspect_(StObject anObject, StSymbol anAspect) {
		return (receiver == anObject && aspect == anAspect);
	}
	/**
	 * Initialize the StDependencyTransformer.
	 *
	 * @param aReceiver sra.smalltalk.StObject
	 * @param anAspect sra.smalltalk.StSymbol
	 * @param aSymbol java.lang.String
	 */
	public void setReceiver_aspect_selector_(StObject aReceiver, StSymbol anAspect, String aSymbol) {
		receiver = aReceiver;
		aspect = anAspect;
		selector = aSymbol;
		numArguments = _NumArgs(selector);
		if (numArguments > 2) {
			throw SmalltalkException.Error("selector expects too many arguments");
		}
	}
	/**
	 * Receive a change notice from an object.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (aspect != evt.getAspect()) {
			return;
		}
		switch (numArguments) {
			case 0 :
				receiver.perform_(selector);
				return;
			case 1 :
				receiver.perform_with_(selector, evt.getParameter());
				return;
			case 2 :
				receiver.perform_with_with_(selector, evt.getParameter(), evt.getSource());
				return;
		}
	}
}