package sra.smalltalk;

import java.awt.*;
import java.awt.event.*;

/**
 * StController class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/12/09 (by nisinaka)
 * 	@updated:   1998/12/10 (by He Weijie)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StController.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StController extends StObject {
	protected StView view;
	/**
	 * add listeners.
	 * @param aView sra.mvctest.StView
	 */
	protected void buildListener(StView aView) {
	}
	/**
	 * Invoked when component has been hidden.
	 */
	public void componentHidden(ComponentEvent e) {
	}
	/**
	 * Invoked when component has been moved.
	 */
	public void componentMoved(ComponentEvent e) {
	}
	/**
	 * Invoked when component has been resized.
	 */
	public void componentResized(ComponentEvent e) {
	}
	/**
	 * Invoked when component has been shown.
	 */
	public void componentShown(ComponentEvent e) {
	}
	/**
	 * Invoked when a component gains the keyboard focus.
	 */
	public void focusGained(FocusEvent e) {
	}
	/**
	 * Invoked when a component loses the keyboard focus.
	 */
	public void focusLost(FocusEvent e) {
	}
	/**
	 * distinguih button event is for menu or not.
	 * @return boolean
	 */
	protected final boolean isMenuButtonPressed_(MouseEvent event) {
		return event.isMetaDown();
	}
	/**
	 * distinguih button event is for menu or not.
	 * @return boolean
	 */
	protected final boolean isShiftKeyPressed_(MouseEvent event) {
		return event.isShiftDown();
	}
	/**
	 * Invoked when a key has been pressed.
	 */
	public void keyPressed(KeyEvent e) {
	}
	/**
	 * Invoked when a key has been released.
	 */
	public void keyReleased(KeyEvent e) {
	}
	/**
	 * Invoked when a key has been typed.
	 * This event occurs when a key press is followed by a key release.
	 */
	public void keyTyped(KeyEvent e) {
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * @return sra.smalltalk.StModel 
	 */
	public StModel model() {
		return this.view().model();
	}
	/**
	 * Invoked when the mouse has been clicked on a component.
	 */
	public void mouseClicked(MouseEvent e) {
	}
	/**
	 * Invoked when a mouse button is pressed on a component and then 
	 * dragged.
	 */
	public void mouseDragged(MouseEvent e) {
	}
	/**
	 * Invoked when the mouse enters a component.
	 */
	public void mouseEntered(MouseEvent e) {
	}
	/**
	 * Invoked when the mouse exits a component.
	 */
	public void mouseExited(MouseEvent e) {
	}
	/**
	 * Invoked when the mouse button has been moved on a component
	 * (with no buttons no down).
	 */
	public void mouseMoved(MouseEvent e) {
	}
	/**
	 * Invoked when a mouse button has been pressed on a component.
	 */
	public void mousePressed(MouseEvent e) {
	}
	/**
	 * Invoked when a mouse button has been released on a component.
	 */
	public void mouseReleased(MouseEvent e) {
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * @return sra.mvctest.StView
	 */
	public StView view() {
		return view;
	}
	/**
	 * Set a view.
	 * @param aView sra.mvctest.StView
	 */
	public void view_(StView aView) {
		view = aView;
		this.buildListener(aView);
	}
}
