package sra.smalltalk;

/**
 * StComputedValue class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/15 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StComputedValue.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StComputedValue extends StValueModel {
	/**
	 * A cached value of the computation result.
	 */
	protected Object cachedValue = UnassignedValue;

	/**
	 * A flag whether to wait until the receiver is asked to perform the computation.
	 */
	protected boolean eagerEvaluation = true;

	/**
	 * A unique object which represents an unassigned value.
	 */
	protected static final Object UnassignedValue = new Object();
	/**
	 * Compute a value for the receiver.
	 *
	 * @return java.lang.Object
	 */
	public Object computeValue() {
		throw SmalltalkException.SubclassResponsibility();
	}
	/**
	 * Set the receiver's value to unknown.
	 * Propagate the change to my dependents.
	 */
	protected void resetValue() {
		if (eagerEvaluation) {
			cachedValue = this.computeValue();
		} else {
			cachedValue = UnassignedValue;
		}
		this.changed_($("value"));
	}
	/**
	 * If a model is propagating a change, then reset the receiver and
	 * propagate the change to my dependents.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		this.resetValue();
	}
	/**
	 * Answer the cached value for the receiver.
	 *
	 * @return java.lang.Object
	 */
	public Object value() {
		if (cachedValue == UnassignedValue) {
			cachedValue = this.computeValue();
		}
		return cachedValue;
	}
	/**
	 * Set the currently stored value, and notify dependents.
	 *
	 * @param newValue java.lang.Object
	 */
	public void value_(Object newValue) {
		throw SmalltalkException.ShouldNotImplement();
	}
}