package sra.smalltalk;

import java.io.*;
import java.util.Vector;
import java.awt.Color;
import java.awt.image.ColorModel;

/**
 * StColorValue class
 * 
 * 	@author:    He Weijie
 * 	@created:   1998/10/10 (by xiaolai)
 * 	@updated:   2000/01/06 (by Mitsuhiro Asada)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StColorValue.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StColorValue extends StObject {
	/**
	 * The RGB numbers.
	 */
	protected int red, green, blue;
	//
	// Constant color values.
	//
	public final static Color Black = Color.black;
	public final static Color Blue = Color.blue;
	public final static Color Brown = new Color(127, 63, 63);
	public final static Color Chartreuse = new Color(127, 255, 0);
	public final static Color Cyan = new Color(0, 255, 255);
	public final static Color DarkCyan = new Color(0, 127, 127);
	public final static Color DarkGray = new Color(95, 95, 95);
	public final static Color DarkGreen = new Color(0, 127, 0);
	public final static Color DarkMagenta = new Color(127, 0, 127);
	public final static Color DarkRed = new Color(127, 0, 0);
	public final static Color Gray = new Color(127, 127, 127);
	public final static Color Green = new Color(0, 255, 0);
	public final static Color LightGray = new Color(170, 170, 170);
	public final static Color LightCyan = new Color(127, 255, 255);
	public final static Color LightYellow = new Color(255, 255, 127);
	public final static Color Magenta = new Color(255, 0, 255);
	public final static Color Navy = new Color(0, 0, 127);
	public final static Color Olive = new Color(127, 127, 0);
	public final static Color Orange = new Color(255, 127, 0);
	public final static Color Orchid = new Color(255, 127, 255);
	public final static Color PaleGreen = new Color(127, 255, 127);
	public final static Color Pink = new Color(255, 191, 191);
	public final static Color Purple = new Color(159, 31, 223);
	public final static Color Red = Color.red;
	public final static Color RoyalBlue = new Color(127, 127, 255);
	public final static Color Salmon = new Color(255, 127, 127);
	public final static Color SpringGreen = new Color(0, 255, 127);
	public final static Color VeryDarkGray = new Color(63, 63, 63);
	public final static Color VeryLightGray = new Color(212, 212, 212);
	public final static Color White = Color.white;
	public final static Color Yellow = new Color(255, 255, 0);

	//
	// Class variavles
	//
	public static int _MaxDistanceSquared = -1;
	public static int _MaxValue = 0xFF;
	public static int _MaxLuminanceValue = _MaxValue * 1000;
	public static double _LuminanceScaleValue = 1.0f / _MaxLuminanceValue;
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 * @param aColor java.awt.Color
	 */
	public static double _DistanceFrom(Color color1, Color color2) {
		return Math.sqrt(_DistanceSquaredFrom(color1, color2));
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 * @param aColor java.awt.Color
	 */
	public static int _DistanceSquaredFrom(Color color1, Color color2) {
		int rdiff = color1.getRed() - color2.getRed();
		int gdiff = color1.getGreen() - color2.getGreen();
		int bdiff = color1.getBlue() - color2.getBlue();
		return rdiff * rdiff + gdiff + gdiff + bdiff * bdiff;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return java.lang.Integer or null
	 * @param aColor java.awt.Color
	 */
	public static Integer _DistanceSquaredFrom_ifLessThan_(Color color1, Color color2, int dist) {
		int diff, rdiff, gdiff, bdiff;
		rdiff = color1.getRed() - color2.getRed();
		diff = rdiff * rdiff;
		if (diff >= dist) {
			return null;
		}
		gdiff = color1.getGreen() - color2.getGreen();
		diff = diff + gdiff * gdiff;
		if (diff >= dist) {
			return null;
		}
		bdiff = color1.getBlue() - color2.getBlue();
		diff = diff + bdiff * bdiff;
		if (diff >= dist) {
			return null;
		}
		return new Integer(diff);
	}
	/**
	 * @param color java.awt.Color
	 * @return int
	 */
	public static int _GetAlpha(Color color) {
		ColorModel rgbColorModel = ColorModel.getRGBdefault();
		return rgbColorModel.getAlpha(color.getRGB());
	}
	/**
	 * @param color java.awt.Color
	 * @return float
	 */
	public static float _GetBrightness(Color color) {
		float[] values = new float[3];
		Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), values);
		return values[2];
	}
	/**
	 * Get the Coler by name.
	 * @param aColorName java.lang.String
	 * @return java.awt.Color
	 */
	public static Color _GetColorByName_(String colorName) {
		if (colorName.compareTo("black") == 0) {
			return Black;
		}
		if (colorName.compareTo("blue") == 0) {
			return Blue;
		}
		if (colorName.compareTo("brown") == 0) {
			return Brown;
		}
		if (colorName.compareTo("chartreuse") == 0) {
			return Chartreuse;
		}
		if (colorName.compareTo("cyan") == 0) {
			return Cyan;
		}
		if (colorName.compareTo("darkCyan") == 0) {
			return DarkCyan;
		}
		if (colorName.compareTo("darkGray") == 0) {
			return DarkGray;
		}
		if (colorName.compareTo("darkGreen") == 0) {
			return DarkGreen;
		}
		if (colorName.compareTo("darkMagenta") == 0) {
			return DarkMagenta;
		}
		if (colorName.compareTo("darkRed") == 0) {
			return DarkRed;
		}
		if (colorName.compareTo("gray") == 0) {
			return Gray;
		}
		if (colorName.compareTo("green") == 0) {
			return Green;
		}
		if (colorName.compareTo("lightGray") == 0) {
			return LightGray;
		}
		if (colorName.compareTo("lightCyan") == 0) {
			return LightCyan;
		}
		if (colorName.compareTo("lightYellow") == 0) {
			return LightYellow;
		}
		if (colorName.compareTo("magenta") == 0) {
			return Magenta;
		}
		if (colorName.compareTo("navy") == 0) {
			return Navy;
		}
		if (colorName.compareTo("olive") == 0) {
			return Olive;
		}
		if (colorName.compareTo("orange") == 0) {
			return Orange;
		}
		if (colorName.compareTo("orchid") == 0) {
			return Orchid;
		}
		if (colorName.compareTo("paleGreen") == 0) {
			return PaleGreen;
		}
		if (colorName.compareTo("pink") == 0) {
			return Pink;
		}
		if (colorName.compareTo("purple") == 0) {
			return Purple;
		}
		if (colorName.compareTo("red") == 0) {
			return Red;
		}
		if (colorName.compareTo("royalBlue") == 0) {
			return RoyalBlue;
		}
		if (colorName.compareTo("salmon") == 0) {
			return Salmon;
		}
		if (colorName.compareTo("springGreen") == 0) {
			return SpringGreen;
		}
		if (colorName.compareTo("veryDarkGray") == 0) {
			return VeryDarkGray;
		}
		if (colorName.compareTo("veryLightGray") == 0) {
			return VeryLightGray;
		}
		if (colorName.compareTo("white") == 0) {
			return White;
		}
		if (colorName.compareTo("yellow") == 0) {
			return Yellow;
		}
		return null;
	}
	/**
	 * @param color java.awt.Color
	 * @return float
	 */
	public static float _GetHue(Color color) {
		float[] values = new float[3];
		Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), values);
		return values[0];
	}
	/**
	 * @param color java.awt.Color
	 * @return double
	 */
	public static double _GetLuminance(Color color) {
		return _LuminanceScaleValue * _ScaledLuminance_(color);
	}
	/**
	 * @param color java.awt.Color
	 * @return float
	 */
	public static float _GetSaturation(Color color) {
		float[] values = new float[3];
		Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), values);
		return values[1];
	}
	/**
	 * @param color java.awt.Color
	 * @return booleanfloat
	 */
	public static boolean _IsGray(Color color) {
		return ((color.getRed() == color.getGreen()) && (color.getGreen() == color.getBlue()) && ((color.getRGB() >> 24 & 0xFF) != 0x00));
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return double
	 */
	public static int _MaxDistanceSquared() {
		if (_MaxDistanceSquared == -1) {
			_MaxDistanceSquared = _DistanceSquaredFrom(Color.black, Color.white);
		}
		return _MaxDistanceSquared;
	}
	/**
	 * @param float,float,float,float
	 * @return Color
	 */
	public static Color _NewColor(float red, float green, float blue, float alpha) {
		return _NewColor(red * 255, green * 255, blue * 255, alpha * 255);
	}
	/**
	 * @param int,int,int,int
	 * @return Color
	 */
	public static Color _NewColor(int red, int green, int blue, int alpha) {
		int pixel = alpha << 24 | red << 16 | green << 8 | blue << 0;
		return new Color(pixel);
	}
	/**
	 * @param color java.awt.Color
	 * @return float
	 */
	public static int _ScaledLuminance_(Color color) {
		return (299 * color.getRed()) + (587 * color.getGreen()) + (114 * color.getBlue());
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param b double
	 * @return java.awt.Color
	 */
	public static Color Brightness_(double b) {
		int sb = Math.round((float) (b * 255));
		if (sb >= 0 && sb <= 255) {
			return new Color(sb, sb, sb);
		} else {
			return Color.black;
		}
	}
	/**
	 * Return the names of all the constant color
	 *
	 * @return java.util.Vector
	 */
	public static Vector ConstantNames() {
		Vector colorNames = new Vector();
		colorNames.addElement($("black"));
		colorNames.addElement($("blue"));
		colorNames.addElement($("brown"));
		colorNames.addElement($("chartreuse"));
		colorNames.addElement($("cyan"));
		colorNames.addElement($("darkCyan"));
		colorNames.addElement($("darkGray"));
		colorNames.addElement($("darkGreen"));
		colorNames.addElement($("darkMagenta"));
		colorNames.addElement($("darkRed"));
		colorNames.addElement($("olive"));
		colorNames.addElement($("gray"));
		colorNames.addElement($("green"));
		colorNames.addElement($("lightYellow"));
		colorNames.addElement($("lightGray"));
		colorNames.addElement($("magenta"));
		colorNames.addElement($("navy"));
		colorNames.addElement($("orange"));
		colorNames.addElement($("orchid"));
		colorNames.addElement($("paleGreen"));
		colorNames.addElement($("pink"));
		colorNames.addElement($("purple"));
		colorNames.addElement($("red"));
		colorNames.addElement($("royalBlue"));
		colorNames.addElement($("salmon"));
		colorNames.addElement($("lightCyan"));
		colorNames.addElement($("springGreen"));
		colorNames.addElement($("veryDarkGray"));
		colorNames.addElement($("veryLightGray"));
		colorNames.addElement($("white"));
		colorNames.addElement($("yellow"));
		return colorNames;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param cyan double
	 * @param magenta double
	 * @param yellow double
	 * @return java.awt.Color
	 */
	public static Color Cyan_Magenta_Yellow_(double cyan, double magenta, double yellow) {
		return new Color((float) (1 - cyan), (float) (1 - magenta), (float) (1 - yellow));
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @param r int
	 * @param g int
	 * @param b int
	 * @return sra.smalltalk.StColorValue
	 */
	public static Color ScaledRed_ScaledGreen_ScaledBlue_(int r, int g, int b) {
		int scaledRed = Math.min(Math.max((r / 32), 0), 255);
		int scaledGreen = Math.min(Math.max((g / 32), 0), 255);
		int scaledBlue = Math.min(Math.max((b / 32), 0), 255);
		return new Color(scaledRed, scaledGreen, scaledBlue);
	}
}