package sra.smalltalk;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
/**
 * StCheckBoxMenuItem class
 * 
 * 	@author:    MATSUDA Ryouichi
 * 	@created:   1999/09/16 (by MATSUDA Ryouichi)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StCheckBoxMenuItem.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StCheckBoxMenuItem extends StMenuItem implements ItemSelectable {
	private Vector itemListeners;
	protected boolean selected = false;
	/**
	 * Creates a menuItem with text.
	 *
	 * @param text java.lang.String
	 */
	public StCheckBoxMenuItem(String text) {
		this(text, false);
	}
	/**
	 * Creates a menuItem with text.
	 *
	 * @param text java.lang.String
	 * @param selected boolean
	 */
	public StCheckBoxMenuItem(String text, boolean selected) {
		super(text);
		this.selected = selected;
	}
	/**
	 * adds an ItemListener to the checkbox
	 */
	public synchronized void addItemListener(ItemListener l) {
		if (itemListeners == null) {
			itemListeners = new Vector();
		}
		itemListeners.addElement(l);
	}
	/**
	 * Invoked when an item has been selected or deselected.
	 */    
	protected void fireItemStateChanged(ItemEvent event) {
		if (itemListeners == null) {
			return;
		}
		Vector copy;
		synchronized (itemListeners) {
			copy = (Vector) itemListeners.clone();
		}
		for (int i = 0; i < copy.size(); i++) {
			ItemListener l = (ItemListener) copy.elementAt(i);
			l.itemStateChanged(event);
		}
	}
	/**
	 * Returns the an array (length 1) containing the checkbox menu item
	 * label or null if the checkbox is not selected.
	 * @see ItemSelectable
	 */
	public synchronized Object[] getSelectedObjects() {
		if (isSelected()) {
			Object[] items = new Object[1];
			items[0] = label;
			return items;
		}
		return null;
	}
	/**
	 * @return boolean
	 */
	public boolean isSelected() {
		return selected;
	}
	/**
	 * removes an ItemListener from the button
	 */
	public void removeItemListener(ItemListener l) {
		itemListeners.removeElement(l);
	}
	/**
	 * @param aBoolean boolean
	 */
	protected void selected_(boolean aBoolean) {
		if (selected != aBoolean) {
			selected = aBoolean;
			StSymbol aspect = selected ? $("selected") : $("deselected");
			StMenuItem root = getRoot();
			if (root instanceof StMenuModel) {
				((StMenuModel) root).changed_with_(aspect, this);
			}
			this.fireItemStateChanged(new ItemEvent(
				this, ItemEvent.ITEM_STATE_CHANGED, this,
				selected ? ItemEvent.SELECTED : ItemEvent.DESELECTED));
		}
	}
	/**
	 * @param aBoolean boolean
	 */
	public void setSelected(boolean aBoolean) {
		this.selected_(aBoolean);
	}
}