package sra.smalltalk;

/**
 * StByteArrayTestExamples class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/16 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StByteArrayTestExamples.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StByteArrayTestExamples extends SmalltalkTestExamples {
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		StByteArray aByteArray = StByteArray.FromPackedString_("^24FS @a");
		return (int) aByteArray.at_(1) == 123
			&& (int) aByteArray.at_(2) == 45
			&& (int) aByteArray.at_(3) == 6
			&& (int) aByteArray.at_(4) == 78;
	}
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		byte[] bytes = new byte[] {123, 45, 6, 78};
		StByteArray aByteArray = new StByteArray(bytes);
		String packedString = aByteArray.asPackedString();
		System.out.println(packedString);
		return packedString.equals("^24FS @a");
	}
	/**
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		int[] bytes = new int[] {123, 45, 6, 78};
		StByteArray aByteArray = new StByteArray(bytes);
		String packedString = aByteArray.asPackedString();
		System.out.println(packedString);
		return packedString.equals("^24FS @a");
	}
	/**
	 * Execute all examples.
	 * @param args java.lang.String[]
	 */
	public static void main(String args[]) {
		new StByteArrayTestExamples();
	}
}