package sra.smalltalk;

/**
 * StBlockValue class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/15 (by nisinaka)
 * 	@updated:   1998/11/09 (by nisinaka)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StBlockValue.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StBlockValue extends StComputedValue {
	/**
	 * The block closure to evaluate.
	 */
	protected StBlockClosure block = null;

	/**
	 * The array of StObject, each of the object has a dependency.
	 */
	protected StObject[] arguments = null;

	/**
	 * The number of arguments block takes.
	 */
	protected int numArgs;
	/**
	 * Create a new StBlockValue with specified block and arguments.
	 *
	 * @return sra.smalltalk.StBlockValue
	 * @param aClass java.lang.Class
	 * @param aBlock sra.smalltalk.StBlockClosure
	 * @param anArray sra.smalltalk.StObject[]
	 */
	public static StBlockValue Block_arguments_(Class aClass, StBlockClosure aBlock, StObject[] anArray) {
		StBlockValue aBlockValue = (StBlockValue) _New(aClass);
		aBlockValue.setBlock_arguments_(aBlock, anArray);
		return aBlockValue;
	}
	/**
	 * Create a new StBlockValue with specified block and arguments.
	 *
	 * @return sra.smalltalk.StBlockValue
	 * @param aBlock sra.smalltalk.StBlockClosure
	 * @param anArray sra.smalltalk.StObject[]
	 */
	public static StBlockValue Block_arguments_(StBlockClosure aBlock, StObject[] anArray) {
		return Block_arguments_(StBlockValue.class, aBlock, anArray);
	}
	/**
	 * Compute a value for the receiver.
	 *
	 * @return java.lang.Object
	 */
	public Object computeValue() {
		switch (numArgs) {
			case 0 :
				return block.value();
			case 1 :
				return block.value_(arguments[0].perform_("value"));
			case 2 :
				return block.value_value_(arguments[0].perform_("value"), arguments[1].perform_("value"));
			case 3 :
				return block.value_value_value_(arguments[0].perform_("value"), arguments[1].perform_("value"), arguments[2].perform_("value"));
		}
		Object[] anArray = new StObject[Math.min(numArgs, arguments.length)];
		for (int i = 0; i < anArray.length; i++) {
			anArray[i] = arguments[i].perform_("value");
		}
		return block.valueWithArguments_(anArray);
	}
	/**
	 * Set the receiver's BlockClosure.
	 *
	 * @param aBlock sra.smalltalk.StBlockClosure
	 */
	protected void setBlock_(StBlockClosure aBlock) {
		block = aBlock;
		numArgs = aBlock.numArgs();
		cachedValue = UnassignedValue;
		arguments = new StObject[0];
	}
	/**
	 * Set the receiver's block and the arguments.
	 *
	 * @param aBlock sra.smalltalk.StBlockClosure
	 * @param anArray sra.smalltalk.StObject[]
	 */
	protected void setBlock_arguments_(StBlockClosure aBlock, StObject[] anArray) {
		this.setBlock_(aBlock);
		arguments = anArray;
		for (int i = 0; i < arguments.length; i++) {
			arguments[i].addDependent_(this);
		}
	}
}