package sra.smalltalk;

import java.lang.reflect.*;

/**
 * StBlockClosure class
 * 
 * 	@author:    He Weijie
 * 	@created:   1998/08/06 (by He Weijie)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StBlockClosure.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StBlockClosure extends StObject {

	/**
	 * Just return the number of arguments.
	 * @return int
	 */
	public int numArgs() {
		Class myClass = this.getClass();
		Method myMethods[] = myClass.getDeclaredMethods();
		if (myMethods.length != 1) {
			this.error_("There should be only one method defined for StBlockClosure.");
		}
		return myMethods[0].getParameterTypes().length;
	}
	/**
	 * This is a abstract method for value
	 * @return java.lang.Object
	 */
	public Object value() throws SmalltalkException {
		return null;
	}
	/**
	 * This is a abstract method for value:
	 * @param argument java.lang.Object
	 * @return java.lang.Object
	 */
	public Object value_(Object argument) throws SmalltalkException {
		return null;
	}
	/**
	 * This is a abstract method for value: value:
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 * @return java.lang.Object
	 */
	public Object value_value_(Object argument1, Object argument2) throws SmalltalkException {
		return null;
	}
	/**
	 * This is a abstract method for value: value: value:
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 * @param argument3 java.lang.Object
	 * @return java.lang.Object
	 */
	public Object value_value_value_(Object argument1, Object argument2, Object argument3) throws SmalltalkException {
		return null;
	}
	/**
	 * This is a abstract method for valueWithArguments:
	 * @param anArray java.lang.Object[]
	 * @return java.lang.Object
	 */
	public Object valueWithArguments_(Object anArray[]) {
		return null;
	}
}