package sra.smalltalk;

import java.io.*;

/**
 * StAssociation class
 * 
 * 	@author:    nisinaka
 * 	@created:   1999/06/23 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StAssociation.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class StAssociation extends StObject {
	/**
	 * The key object of the association.
	 */
	Object key = null;

	/**
	 * The value object of the association.
	 */
	Object value = null;
	/**
	 * Create a new instance of StAssociation.
	 *
	 * @param keyObject java.lang.Object
	 * @param valueObject java.lang.Object
	 */
	public StAssociation(Object keyObject, Object valueObject) {
		key = keyObject;
		value = valueObject;
	}
	/**
	 * Answer the key object of the receiver.
	 *
	 * @return java.lang.Object
	 */
	public final Object key() {
		return key;
	}
	/**
	 * Print my string representation on aWriter.
	 *
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(key + "->" + value);
	}
/**
 * Returns a String that represents the value of this object.
 * @return a string representation of the receiver
 */
public String toString() {
	// Insert code to print the receiver here.
	// This implementation forwards the message to super. You may replace or supplement this.
	return super.toString();
}
	/**
	 * Answer the value object of the receiver.
	 *
	 * @return java.lang.Object
	 */
	public final Object value() {
		return value;
	}
}