package sra.smalltalk;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.lang.reflect.*;
import java.util.Vector;

/**
 * StApplicationModel class
 * 
 * 	@author:    he weijie
 * 	@created:   1998/08/18 (by he weijie)
 * 	@updated:   1999/10/01 (by MATSUDA Ryouichi)
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: StApplicationModel.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public abstract class StApplicationModel extends StModel implements ActionListener, ItemListener {
	/**
	 * view mode
	 */
	public final static int VIEW_AWT = 0;
	public final static int VIEW_SWING = 1;
	public final static int VIEW_SWING_ONLY = 2;
	protected static int DefaultViewMode = VIEW_AWT;

	/**
	 *
	 */
	protected StUIBuilder builder = new StUIBuilder(this);
	/**
	 * create a panel with the border.
	 * @return java.awt.Panel 
	 */
	public static Panel _PanelWithBorder() {
		Panel aPanel = new Panel() {
			public Insets getInsets() {
				return new Insets(4, 4, 4, 4);
			}
			public void paint(Graphics graphics) {
				super.paint(graphics);
				Dimension size = this.getSize();
				// top
				graphics.setColor(Color.black);
				graphics.fillRect(1, 1, size.width - 4, 1);
				graphics.setColor(Color.gray);
				graphics.fillRect(2, 2, size.width - 4, 1);
				// bottom
				graphics.setColor(Color.lightGray);
				graphics.fillRect(1, size.height - 3, size.width - 4, 1);
				// left
				graphics.setColor(Color.black);
				graphics.fillRect(1, 1, 1, size.height - 4);
				graphics.setColor(Color.gray);
				graphics.fillRect(2, 2, 1, size.height - 4);
				// right
				graphics.setColor(Color.lightGray);
				graphics.fillRect(size.width - 3, 1, 1, size.height - 4);
			}
		};
		return aPanel;
	}
	/**
	 * Invoked when a menu item has been selected. 
	 *
	 * @param e java.awt.event.ActionEvent 
	 */
	public void actionPerformed(ActionEvent ev) {
		this.perform_(ev.getActionCommand());
	}
	/**
	 * 
	 * @return sra.smalltalk.StUIBuilder
	 */
	public final StUIBuilder builder() {
		return builder;
	}
	/**
	 * Create a StCheckBoxMenuItem and set a command.
	 *
	 * @param displayString java.lang.String
	 * @param commandString java.lang.String
	 * @return sra.smalltalk.StCheckBoxMenuItem
	 */
	protected StCheckBoxMenuItem createCheckBoxMenuItem(String displayString, String commandString) {
		StCheckBoxMenuItem item = new StCheckBoxMenuItem(displayString);
		item.setActionCommand(commandString);
		//item.addItemListener(this);
		item.addActionListener(this);
		return item;
	}
	/**
	 * Create a StMenuItem and set a command.
	 *
	 * @param displayString java.lang.String
	 * @param commandString java.lang.String
	 * @return sra.smalltalk.StMenuItem
	 */
	protected StMenuItem createMenuItem(String displayString, String commandString) {
		StMenuItem item = new StMenuItem(displayString);
		item.setActionCommand(commandString);
		item.addActionListener(this);
		return item;
	}
	/**
	 * Create a StRadioButtonMenuItem and set a command.
	 *
	 * @param displayString java.lang.String
	 * @param commandString java.lang.String
	 * @param radioGroup sra.smalltalk.StMenuRadioButtonGroup
	 * @return sra.smalltalk.StRadioButtonMenuItem
	 */
	protected StRadioButtonMenuItem createRadioButtonMenuItem(String displayString, String commandString, StButtonGroup radioGroup) {
		StRadioButtonMenuItem item = new StRadioButtonMenuItem(displayString);
		item.setActionCommand(commandString);
		//item.addItemListener(this);
		item.addActionListener(this);
		radioGroup.add(item);
		return item;
	}
	/**
	 * Create a view from class name.
	 *
	 * @return sra.smalltalk.StView
	 */
	protected static final StView CreateView(String className) {
		try {
			return (StView) Class.forName(className).newInstance();
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public abstract StView defaultView();
	/**
	 * Answer the default view mode.
	 *
	 * @return int
	 */
	public final static int GetDefaultViewMode() {
		return DefaultViewMode;
	}
	/**
	 * Is swing enabled.
	 *
	 * @return boolean
	 */
	public final static boolean IsSwingInstalled() {
		try {
			Class aClass = Class.forName("javax.swing.JComponent");
		} catch (ClassNotFoundException e) {
			// Can't find a swing package, the view mode is changed to AWT.
			return false;
		}
		return true;
	}
	/**
	 * Invoked when a checkbox item has been selected. 
	 *
	 * @param e java.awt.event.ActionEvent 
	 */
	public void itemStateChanged(ItemEvent ev) {
		String command;
		if (ev.getSource() instanceof StCheckBoxMenuItem) {
			command = ((StCheckBoxMenuItem) ev.getSource()).getActionCommand();
		} else {
			command = ((CheckboxMenuItem) ev.getSource()).getActionCommand();
		}
		this.perform_(command);
	}
	/**
	 * Answer a menu model.
	 * @return sra.smalltalk.StMenuModel
	 */
	public StMenuModel menuModel() {
		return null;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Frame open() {
		return this.openView_((StView) this.defaultView());
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Frame openView_(StView aView) {
		aView.model_(this);
		//
		int viewmode = VIEW_AWT;
		try {
			Class aClass = Class.forName("javax.swing.JComponent");
			if (aClass.isInstance(aView)) {
				viewmode = VIEW_SWING;
			}
		} catch (Exception e) {
		}
		//
		Frame aFrame;
		if (viewmode == VIEW_AWT) {
			aFrame = StMenuViewForAwt.CreateFrame(this, aView);
		} else {
			final String className = "sra.smalltalk.StMenuViewForSwing";
			final String methodName = "CreateJFrame";
			final Class[] parameterTypes = new Class[] {StApplicationModel.class, StView.class};
			try {
				Class aClass = Class.forName(className);
				Method aMethod = aClass.getMethod(methodName, parameterTypes);
				aFrame = (Frame) aMethod.invoke(aClass, new Object[] {this, aView});
			} catch (Exception e) {
				throw new SmalltalkException(e);
			}
		}
		//
		aFrame.show();
		return aFrame;
	}
	/**
	 * 
	 * @return boolean
	 */
	protected boolean requestForWindowClose() {
		return true;
	}
	/**
	 * Set the default view mode.
	 *
	 * @param mode int
	 */
	public final static boolean SetDefaultViewMode(int mode) {
		if (mode != VIEW_AWT && IsSwingInstalled() == false) {
			return false;
		} else {
			DefaultViewMode = mode;
			return true;
		}
	}
	/**
	 * Invoked when a window is in the process of being closed.
	 * The close operation can be overridden at this point.
	 */
	public void windowClosing(WindowEvent e) {
		this.builder().removeFrame_((Frame) e.getWindow());
		e.getWindow().setVisible(false);
		Thread.yield();
		e.getWindow().dispose();
	}
	/**
	 * Answer a window resizable.
	 * @return boolean
	 */
	protected boolean windowResizable() {
		return true;
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return this.toString();
	}
}
