package sra.smalltalk;

import java.lang.reflect.*;

/**
 * SmalltalkTestExamples class
 * 
 * 	@author:    nisinaka
 * 	@created:   1999/03/12 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: SmalltalkTestExamples.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public abstract class SmalltalkTestExamples {
	/**
	 * Execute all the methods which name begins with "Example".
	 */
	public SmalltalkTestExamples() {
		ExecuteMethods(this.getClass(), "Example");
	}
	/**
	 * Execute all the methods specified with the String.
	 *
	 * @param aString java.lang.String
	 */
	public SmalltalkTestExamples(String aString) {
		ExecuteMethods(this.getClass(), aString);
	}
	/**
	 * Execute all methods specified with the method name.
	 *
	 * @param methodName java.lang.String
	 */
	public final static void ExecuteMethods(Class aClass, String methodName) {
		try {
			Method methodList[] = aClass.getDeclaredMethods();
			for (int i = 0; i < methodList.length; i++) {
				Method method = methodList[i];
				if (method.getName().startsWith(methodName)) {
					System.out.println(method.getName());
					Boolean result = (Boolean) method.invoke(null, null);
					System.out.println("-> " + result);
				}
			}
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}
}