package sra.smalltalk;

/**
 * SmalltalkException class
 * 
 * 	@author:    nisinaka
 * 	@created:   1998/10/01 (by nisinaka)
 * 	@updated:   N/A
 * 	@version:   3.1
 * 	@JDK:       1.1.6 or higher
 * 	@copyright: 1999-2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: SmalltalkException.java,v 3.1 2000/04/07 05:41:09 nisinaka Exp $
 */
public class SmalltalkException extends RuntimeException {
	/**
	 * Constructs a <code>SmalltalkException</code> with no detail message.
	 */
	public SmalltalkException() {
		super();
		this.printStackTrace();
	}
	/**
	 * Constructs a <code>SmalltalkException</code> with the specified
	 * detail message.
	 *
	 * @param s java.lang.String
	 */
	public SmalltalkException(Exception e) {
		super();
		e.printStackTrace();
	}
	/**
	 * Constructs a <code>SmalltalkException</code> with the specified
	 * detail message.
	 *
	 * @param s java.lang.String
	 */
	public SmalltalkException(String s) {
		super(s);
		this.printStackTrace();
	}
	/**
	 * Constructs a <code>SmalltalkException</code> for Error.
	 *
	 * @return sra.smalltalk.SmalltalkException
	 */
	public static SmalltalkException Error(String aString) {
		return new SmalltalkException("Error: " + aString);
	}
	/**
	 * Constructs a <code>SmalltalkException</code> for Halt.
	 *
	 * @return sra.smalltalk.SmalltalkException
	 */
	public static SmalltalkException Halt(String aString) {
		return new SmalltalkException("Halt: " + aString);
	}
	/**
	 * Constructs a <code>SmalltalkException</code> for MessageNotUnderstood.
	 *
	 * @return sra.smalltalk.SmalltalkException
	 */
	public static SmalltalkException MessageNotUnderstood(String info) {
		return new SmalltalkException("message not understood - " + info);
	}
	/**
	 * Constructs a <code>SmalltalkException</code> for ShouldNotImplement.
	 *
	 * @return sra.smalltalk.SmalltalkException
	 */
	public static SmalltalkException ShouldNotImplement() {
		return Error("This message is not appropriate for this object");
	}
	/**
	 * Constructs a <code>SmalltalkException</code> for SubclassResponsibility.
	 *
	 * @return sra.smalltalk.SmalltalkException
	 */
	public static SmalltalkException SubclassResponsibility() {
		return new SmalltalkException("subclass responsibility");
	}
	/**
	 * Constructs a <code>SmalltalkException</code> for SubclassResponsibility.
	 *
	 * @return sra.smalltalk.SmalltalkException
	 */
	public static SmalltalkException SubclassResponsibility(String info) {
		return new SmalltalkException("subclass responsibility - " + info);
	}
}