package sra.isr.system.support;

import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;
import java.util.*;
import sra.smalltalk.*;
import sra.isr.interfaces.display.*;

/**
 * IsrTestExamples class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrTestExamples.java,v 1.12 2000/04/07 04:24:20 m-asada Exp $
 */
public class IsrTestExamples extends IsrDisplayModel {
	protected StMenuModel menuModel;
	/**
	 * 
	 */
	public IsrTestExamples() {
		super();
		this.visual_(IsrSystem.LogoImage());
		this.open();
	}
	/**
	 * Invoked when a menu item has been selected. 
	 *
	 * @param ev java.awt.event.ActionEvent 
	 */
	public void actionPerformed(ActionEvent ev) {
		String command = ev.getActionCommand();
		int index = command.indexOf("#");
		if (index < 0) {
			this.executeMethod(this, command);
			return;
		}
		String className = command.substring(0, index);
		String methodName = command.substring(index + 1, command.length());
		try {
			Class aClass = Class.forName(className);
			if (methodName.equals("All")) {
				String methodNames[] = GetStaticMethodNamesFor(aClass);
				for (int i = 0; i < methodNames.length; i++) {
					System.out.println(methodNames[i]);
					Boolean result = (Boolean) this.executeMethod(aClass, methodNames[i]);
					System.out.println("-> " + result);
				}
			} else {
				System.out.println(methodName);
				Boolean result = (Boolean) this.executeMethod(aClass, methodName);
				System.out.println("-> " + result);
			}
		} catch (ClassNotFoundException e) {
			new SmalltalkException(e);
		}
	}
	/**
	 * Create a default menu bar of the JunLauncher.
	 *
	 * @return java.awt.MenuBar
	 */
	protected StMenuModel defaultMenu() {
		String methodNames[] = GetStaticMethodNamesFor(this.getClass());
		String className = this.getClass().getName();
		StMenuModel menuModel = new StMenuModel();
		StMenu aMenu = new StMenu("Examples");
		menuModel.add(aMenu);
		StMenuItem anItem = new StMenuItem("All");
		anItem.setActionCommand(className + "#All");
		anItem.addActionListener(this);
		aMenu.add(anItem);
		aMenu.addSeparator();
		for (int i = 0; i < methodNames.length; i++) {
			String methodName = (String) methodNames[i];
			anItem = new StMenuItem(methodName);
			anItem.setActionCommand(className + "#" + methodName);
			anItem.addActionListener(this);
			aMenu.add(anItem);
		}
		//
		StMenu helpMenu = new StMenu("Help");
		StMenu viewMenu = new StMenu("Default View Mode");
		StButtonGroup viewGroup = new StButtonGroup();
		viewMenu.add(createRadioButtonMenuItem("Awt", "viewAwt", viewGroup));
		viewMenu.add(createRadioButtonMenuItem("Swing", "viewSwing", viewGroup));
		viewMenu.addSeparator();
		viewMenu.add(createRadioButtonMenuItem("Swing Only", "viewSwingOnly", viewGroup));
		for (int i = StApplicationModel.VIEW_AWT; i <= StApplicationModel.VIEW_SWING_ONLY; i++) {
			if (StApplicationModel.GetDefaultViewMode() == i) {
				StRadioButtonMenuItem menuItem = (StRadioButtonMenuItem) viewMenu.getItem(i);
				menuItem.setSelected(true);
			}
		}
		helpMenu.add(viewMenu);
		menuModel.add(helpMenu);
		//
		return menuModel;
	}
	/**
	 * Answer a default view.
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		IsrDisplayViewAwt aView = new IsrDisplayViewAwt();
		aView.model_(this);
		aView.setSize(176,64);
		aView.setResizable(true);
		return aView;
	}
	/**
	 * Execute all methods specified with the method name.
	 *
	 * @param methodName java.lang.String
	 */
	public Object executeMethod(Class aClass, String methodName) {
		Object anObject;
		Frame myFrames[] = this.builder().frames();
		Cursor savedCursors[] = new Cursor[myFrames.length];
		for (int i = 0; i < myFrames.length; i++) {
			savedCursors[i] = myFrames[i].getCursor();
			myFrames[i].setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		}
		try {
			anObject = StObject._Perform(aClass, methodName);
		} finally {
			for (int i = 0; i < myFrames.length; i++) {
				myFrames[i].setCursor(savedCursors[i]);
			}
		}
		return anObject;
	}
	/**
	 * Execute all methods specified with the method name.
	 *
	 * @param methodName java.lang.String
	 */
	public Object executeMethod(StObject anObject, String methodName) {
		Object answer;
		Frame myFrames[] = this.builder().frames();
		Cursor savedCursors[] = new Cursor[myFrames.length];
		for (int i = 0; i < myFrames.length; i++) {
			savedCursors[i] = myFrames[i].getCursor();
			myFrames[i].setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		}
		try {
			answer = anObject.perform_(methodName);
		} finally {
			for (int i = 0; i < myFrames.length; i++) {
				myFrames[i].setCursor(savedCursors[i]);
			}
		}
		return answer;
	}
	/**
	 * Execute all public methods.
	 */
	public final static void ExecuteMethods(Class aClass) {
		String methodNames[] = GetStaticMethodNamesFor(aClass);
		for (int i = 0; i < methodNames.length; i++) {
			System.out.println(methodNames[i]);
			Boolean result = (Boolean) StObject._Perform(aClass, methodNames[i]);
			System.out.println("-> " + result);
		}
	}
	/**
	 * Answer method names.
	 *
	 * @param aClass java.lang.Class
	 * @return java.lang.String[]
	 */
	public static final String[] GetStaticMethodNamesFor(Class aClass) {
		StBlockClosure sortBlock = new StBlockClosure() {
			public Object value_value_(Object e1, Object e2) {
				return new Boolean(e1.toString().compareTo(e2.toString()) < 0);
			}
		};
		StSortedCollection collection = new StSortedCollection(sortBlock);
		Method[] methods = aClass.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			Method aMethod = methods[i];
			if (aMethod.getParameterTypes().length == 0) {
				int modifiers = aMethod.getModifiers();
				if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
					collection.add_(aMethod.getName());
				}
			}
		}
		Object array[] = collection._asArray();
		String[] methodNames = new String[array.length];
		for (int i = 0; i < array.length; i++) {
			methodNames[i] = (String) array[i];
		}
		return methodNames;
	}
	/**
	 * Answer a menu model.
	 * @return sra.smalltalk.StMenuModel
	 */
	public StMenuModel menuModel() {
		if (menuModel == null) {
			menuModel = defaultMenu();
		}
		return menuModel;
	}
	/**
	 * 
	 */
	public void viewAwt() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_AWT);
	}
	/**
	 * 
	 */
	public void viewSwing() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_SWING);
	}
	/**
	 * 
	 */
	public void viewSwingOnly() {
		StApplicationModel.SetDefaultViewMode(StApplicationModel.VIEW_SWING_ONLY);
	}
	/**
	 * Invoked when a window is in the process of being closed.
	 *
	 * @param e java.awt.event.WindowEvent 
	 */
	public void windowClosing(WindowEvent e) {
		Window aWindow = e.getWindow();
		Point location = aWindow.getLocationOnScreen();
		Dimension size = aWindow.getSize();
		location = new Point(location.x + size.width, location.y);
		if (StDialog.Confirm_("Really quit?", false, location) == true) {
			System.exit(0);
		} else {
			aWindow.setVisible(true);
		}
	}
	/**
	 * 
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		String className = this.getClass().getName();
		return className.substring(className.lastIndexOf('.') + 1);
	}
}
