package sra.isr.system.support;

import java.awt.*;
import java.awt.image.*;
import sra.smalltalk.*;

/**
 * IsrSystem class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrSystem.java,v 1.7 2000/04/07 04:24:20 m-asada Exp $
 */
public class IsrSystem extends StModel {
	/**
	 * Answer the LogoImage bits.
	 *
	 * @return int[]
	 */
	public final static int[] _LogoImage_bits() {
		String packedString =
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@CL:W('>=?X@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@ON#(:W&S^+O_6@@C5BO_8=0@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L3(:L3(:N%:I78#5@@<:YX" +
			"'>=0@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C7W%4@@@@@@" +
			"@@@@@@@@@@@@@@@@@<:E#LVMC$4N#)^+X\"BN#(3N&S= /X@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@OT9W%9$\"Z7:=P@@@@@@@@@@@@@@@@@3N#L:MC(9D" +
			"C(9N#)^YM:HMAX3MC*H?X @@@@@@@@@@@@@=/T@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\\3" +
			"N#(:W%9^\"M7_U @@@@@@@@@@@@@@C#(PN <:C3(9MC(3N#)^W(#>YC(UMAY^\"_0+=" +
			"P@@@@@@A3JI7/_6@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 2N#(:N#(:N%9^W(&3>/ @@@@@@@@@" +
			"@@D3N#$4N#$4E#PUMAX9MC(:N%:H758PNSP:YKNAU @@@B0:N%9^,:76@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@GN#(:N#(:W#(:W#)^W(\"-7/\\@@@@@@@C5L3(UMAX9DC(4NSP:NSPVNSP:" +
			"W-:-?&PPN!T4N('^>?\\HN#(:N#)^\"X!]=P@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@=_T@@@@@@@@@@@@@@@@@@@@@@@@GN#(:MC(4NSP:N#(:W#)" +
			"^W&RI,?\\@@@@@@CPVN#P:L3(4NQX:ESPPNSPVN/7>+_7_ !T4MC$PNS*-?%8VL3(4" +
			"NS(:W-:,WP@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=#JI7/\\@@@" +
			"@@@@@@@@@@@@@@@OTGL3(:MC$:NS(:N#$:N#(:W#)^W%:H7*76@OT3N#LVL1X:C3(" +
			"4L3P:NS(PNSO^+];=,?:IC3(UMC(PW/;^?#(PNS(4N#(:N%:-,5X@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@A0 :N%:H7? @@@@@@@@@@EX+@@@@KFT:N#(:MC" +
			"(4NSP:MC(3N#(:N#)^W%9^\"J78L1XVN#P:NSP:NQX:ESPVL3(PW/7>?Z7^?U8:N#P" +
			"VNU;>?*6HN#$PN!T4NSP:N#*H7/'8@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"OX4N#(:N%:I,? @@@@@@@@3\"_76@OT9N#)^N#$:N#(:N#$:N#(:NS(:N#(:YO6I?-" +
			"?]NSP3N!T4E#$PMC$4N#L:EU;>7*7^,?6HDC$4NS(O\"Z7^,58OMC(9MC$4N#$4N#)" +
			"^\"Z5]J0@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C5E#(9MC(:N%:H+X +@@@@L3(:\"" +
			"_6BA5=^N#)^N#(:L3(4N#P9MC(4N#$:W*6-,?;^+_6-N!X3N#P9MC(9DC(UN!A^7:" +
			"7=?*7=,8$:N#(:DH#>?/7>W!X:C3(PN!X3N#(9MC(:W-6,\"@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OW6=/X+= @@@@@@@@@@" +
			"@@@@@@@@@@@@@@\\:MAX9MC$:N%9$+_76@@8:C3(9YKO=N%9^N#)^N#(:N#$:N#(9N" +
			"#(:W(#>?_:-?_7>7/44NQX3E#PUMC(9MCPUW/:-?-;=7*7=\"A@9MC%$+_;^+]8:L3" +
			"(:L3(3N!X3DC(:NS(:\"J7_@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@\\,L6U$\"];_U @@@@@@@@@@@@@@@@@@@@@GN!@9MC(ON#P:" +
			"N%9^\"_42DC(4N!@4W('=W#)^N#)^N#(:N#P9MC(OMH#>+];^?]:-7-:-?QX:MC(9N" +
			"#P9E#PUN%:3?];=\"];=+]83N#(:N/;^?Z7>W <4E#LVN!@9MC(:C3(PW(J3?*4@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 3N%8:W%9" +
			"^ (&3>P@@@@@@@@@@@@@@@@@@A3(4NSP:C3(3N#L:N#)^\"[NHN#$PNS(9N(#]\"C)^" +
			"W#(:W#(:N#(:MFRH7=;>?Z6-7/;=+_7^N#L:ESPPNQX4NS(O\"_:-78!^?];>?S(4N" +
			"QBH?*7^?[NHE#(3N#$4NSP9E#L:C5;>,?6-7 @@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@GN#(:N#)^N&Q^\"H'_U @@@@@@@@@@@@@@@@\\" +
			":MAT:E#L:N!X4ES(4N#)^\"J6HN#L:DCPVN(J-\"E8:W#(:N%8:N#M$7=>-+_7^?/6-" +
			"?];=?*43E#P:NS(4N#LVDH#>+_:HW*7>+_8:N#(P\"M>-?Z7>,584NQX4E#(PN!@9N" +
			"!A$?+N-?-;=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O" +
			"W6N#(:N#(:N%8:W%9^\"H'_U @@@@@@@@@@@@@GN#(:MCL:E#L4NS(4ES(9N#)^\"KN" +
			"-N#$:NSP9N%;>\"E8:W%8:N%;=7*7=+_;^+_6IYH#^+];=7#(3E#LPNQX3N >H+_;>" +
			"\"U9^7/7^?S(3N#*-?[O>7*7>YA@:NSP3N#$4NQ@3YNB-?]:-?[L@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C5L3(:MC(4N#(:N#)^N%9^\"H'_U " +
			"@@@@@@@@@@=SPUM@<:E#$4N!T4E#L:MCP:W-?>+_:HD@<:DC(ON#*I78!^N%847/:" +
			"-?*7^?/7]W%9^W(#=?*6HDC(4N#(:L1X:W+O>7( :W#+=+_6IN!X:\"O:-\"M;=?( 4" +
			"NSP:N#(UMAX:E%:-YE;^?Z63 P@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@HL#L:N#P9N#$:MC$:N#)^N%9^W(\"3>P@@@@@@@@@HN#P9N#(3MC(UMC" +
			"(3N <:EU;_?Z7^?($:N#P9MC(3N(\"-,59^N&R-7/7^?/6I\"E9^YE9$W*7^?#(:NS(" +
			"ON <4N%;_?*6HW%9^\"M;>7583N*3_,6RI?Z63\"C(:N#(3N#P9N#M^758:?Z7^?-?6" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L#(:N#(:NS(4N#(:N" +
			"#(:W#)^N%9$\"X\"3U @@@@@@C#(:ESPVL1X:C3(:C3(VN =^8J7>7/6-N#L:NQX:C3" +
			"*I?_;=W%8:+O:-?-:-?U9^W%9^W%;^?/6-N#LPNS(4N#$P?_:-\"E9^W#+^+_63W!Y" +
			"^7:6-W(\"3+_6IMC(9N#(:N#(PC=9^C8#_+_7^7?X@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@CH:W#(:N#P:N#$4NS(4N#$:N#)^N%9^W('_U @@@@ :M" +
			"CL:NSP:L3(:C3(:L3POYNB-?-:-?]43N#(4N#(4N[N-7/9^YE:I?]:-?]9^W#)$W&" +
			"Q^W*7^+_8:N#(PNQX3E(\"3?( :W$A^W/7>,58:N*7=?&Q^\"O63?( :N#P:MC$4NS*" +
			"HW!Y^,:7>7/;8@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@L%8:" +
			"N#(9N#(4N#(4N#$:MC(:N#(:W(\"H\"J7_U @HN#P9E#(PNQ@:C3(4E#LVN%;_?/7^?" +
			"_:-?QX4N#$4ES*-?/6-,?U^YH'>?/6IW%9$W%9^W&Q^?_63W <VL3(4NQBH?*6IW%" +
			"9^W%:H7*7_\"@?=?]:HYE:I,?6-N#(:N#$:N#(4\"J4:W->,7_6-+R,@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OX3N%8:W#(:NS(9N#$:MC(:N#P9N(\"I" +
			"7:63?Z7_WS(4NQX4MC$4N#$:L3(9MAU^?*6-7/6-7/7^L3(9MC)^7/7^+[O:@@C;?" +
			":7^YC)^N%9^YC)^W%;^7.A^E#L:N <:\"_;^?#)^W&Q^N('_?Z4:W-:3\"U:BYO6-7/" +
			"4:W#(:N#(:N#+>N >-78\"I?-?9@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@KFU^N#(:N#(4N#P:MC(9N#(9N(\"I?_:-?_;^?*7>C3(VL3(UMAX3DC(V" +
			"L1XP\"M?>7/6-?-:-?%8:N#P:C6S)7*7=72,@@OU^YE9^W%9$W%9^W&P:7/6-\"C(3N" +
			"!@9MC+=?*5$W%9$N%9^\"J7>YE;>+_6HYFRI+_6-?S(:N%8:N#P9+X O\"M>H\"_:-7?" +
			"$@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+YE9^W#)^N#(:N#(" +
			"9MC(3N%:-+_:3+_;^+_7^?[NHC3(:L3(9MC(9MC(:L1ZH+Z7=\"H'=+_;^MC$VNS)^" +
			"+_6-?-;_J0@@@CM^W%9$W%9^PE9^W%:H7?9$DC(9MAX9\"_;>YE8:W%9^W&S_?[NHW" +
			"->-YHJCW(#>7/7]N%8:N%8:N#+>YE;_+U:H7?6IC @@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@B1%N%8:W#(:W#$:N#(9DC+=+];>?Z7=7*7=7/6-,58" +
			":C3(PN!@9E#PUMAT4\"M?>76Q^+[O=7/4:MC(4E/;^?-;=+^@+@@@2YE9$W%9^YE9^" +
			"W&Q^W*6-,583N#PUMH'>,58:W%8:W#)^W/:-+S+_?/6IYH!$ -;>+Z1^N%8:N%8:+" +
			"X%^7?5^W('>?($4C D@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=U" +
			"9$W%9^N%8:N#(:MC)$?[O>?Z7^?[O>?_:-7/:-ESP:MC$4NS(4NSP9DH#>+Z6HW%;" +
			"]?_:-\"C(9N#%^?Z7^?Z63?OT@@B1%W%9^W%9^W&Q^W#*H?/:HDC(:N#+=?*5$W%9^" +
			"N%9^W%:I,?:I\"O:IYE9$ 6RI?*7^?#)^N%9^N%;=?]?_YE:H?*63\"AT4Y@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=U9^N%8:W#)^N#RH\"_:-?-;^?_" +
			":-YH\"I?-:-?]44NQ@9E#(PNQ@:E!BH7:63\"C)^W*7^+_8:MC(PW->3?Z7>7-=V@@@" +
			"@L%9^YE9$N%9^N%9$N('>7*49N#LPW-?^?S)^N%9^W#)^YO;=7/7_+X\"B\"X!$ (\"-" +
			"?/5^N%9^N#(:\"M>3+Z1^W&W>7/6-DE;_@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@=U9$W%8:N#*H?[O=,:7=+_7^W&Q^W&RI?_;^+A@:NSP3N#$4NS" +
			"P9\"M>-?&Q^W%:H?/7^?#(9DFS_+_:H\"_6-75X@@@]^YE9^W%9$W&Q^W%9$?]:-N#P" +
			":N#+=+_5^W%9^N%9^W#)^,:7=+_7]\"FRBYX!%\"O;]+S(:N%9^W#*H+_7]W&Q^\"J7=" +
			"7#%^7?4@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C6J0@@@@@@@E9$W%8:\"" +
			"J63?Z7^?-;=+VQ^W&Q^W(\"3?Z7^MAT4E#(VMAX:DE;_?]>HW%9^N(&3+_5$MC(4\"O" +
			";=\"U:I?/;_U @@J6U^W&Q^W%9^W&Q^W%:3?Z49N#$:?[N-YC)^N%9^YC)^W/;=+];" +
			">+VRB\"VRB\"E:H+_7>N#Q$?%8:\"M?>+X%$ &RI?/:-+]>-= @@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@GL%?^>P@@@@@@=U9$W%9$?*7^?*7=+X :W%9^W%9^\"J7>+" +
			"X UMC(:L3P9N <37Z7>+VP:W&Q^\"J7>758UN(#>+X%$W(\"-7-=V@@@2W%9^N%9^YE" +
			"9^W%9^\"_:-\"CP:DO6-78 :W%9^W%8:W%8:7*7^?/6I\"H&H\"H%$\"VS>7/4:N(#_W%:" +
			"I+[O9WX%%\"O6-7/7_?_X@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@BC(:N%;_" +
			">P@@@@@@=S)^N(\"-?/7^?[M$W%9^YE9$W&S_+];=E#P:C3(VNQ@3N-7=?-9^W%9^N" +
			"&R-?-;=YCP:?-;>YE:H,?:-75X@=VU^YE9^YE9^W&Q^N&S>7/8:N =^7/:-W%9^N%" +
			"8:W%9^N(\"-?/7^+VRHW(\"C\"HI$+Z7=+S*H8H%^YO7 >PC5WX&H+_;=7/ +@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\\:N#(:W&S_>P@@@@@@U6Q^,:7>7*7>YE9^" +
			"W%9^W%9^W+O=+_8:L3(:L3P:N!Z,+_;^W%9^YE9^\"KO=+X$:N(\"-+X\"BYH'=7/;;@" +
			"@C5W%9^YE9^W#)^W%9^W/:-?#(OYM?=7U8:W%9^YE8:W%9^7/7^+_6I\"H&HYX!$\"X" +
			"\"-?-;=N/;=YE9$8O$@@@C6=(\"37*4+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@HN#$4L3(:W(&3>P@@@@@@L8'>,;O=\"E9^W$A^YC)^YE9^?Z63\"C(VN <:ES(O" +
			"\"KO>+U9^YE9^W#*H+_;_\"@>H7?:IYFQ^\"O:-754@@@]$W%9^W%9^YE9$W&Q^7/9^E" +
			"%:-?*5^N%9^N%8:W%9^N(\"-,?7_J?VH\"X&H\"HNHYO:-7/:-7?$@WXD@@@@@@@@@=Z" +
			"5V@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A3(9MAX:N#P:W(#_J0@@@@@" +
			"@U8FA _$GYU9^W%9^W%9^W&S^?/8:NSP3N#(4C3*-?*5$W#)^N&Q^W(&-7/9^MM:-" +
			"?(!^ 6RI?*7_> @@W%9^YC)$W&Q^W%9^W/:-7584YO:3\"E9^W#)^W%9^N%8:\"_:-7" +
			"8#6@B/:\"H!%\"H&B7/6-7/:-=0@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@ :MA@:L3$PNS(:W-;:@@@@@@@@@@@@@B1^W&Q^W&Q^YC)^7*6" +
			"-?%84E#(ON <:?/:3\"C)^W%9^W#)$?/;=\"S+^?Z6HYH!$W(\"3?]?:@@A^W%9^W%9^" +
			"W%9^YE8:7/6HN&S=78%^W#)^W&P:W#)^W&S=?-; U @@@@@++X\"HYH\"-?-;=,?,@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@GN#(9N <:MC" +
			"(:L3(:W+NA@@@@@@@@@@C5W&Q^W#)^W#)^W%:-?];>N#(3N#(ON/;^+Z5^W#)^N%9" +
			"^W&S_7*6HW/;>7%:IW(\"I\"J7>,8D@L%9$W%9$W%9@W%9^W(\"-759^7=?:=S)^W#)^" +
			"W%9^W#)^\"KN-?/,@@@@@@@C7+X&H\"_7^+Z7== @@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@CH:L1X4N#LVNQ@:N#(:W+NA@@@@@@@@@@E$W%" +
			"9^YE9$W%9$W('>+VP3N#(9MC*-7/;=W#)^W#)^W#)^W/6-?U:-7*6HYHJIYE:I?*6" +
			"3 P@:W%9^W%9$W%9^YE9^7_;>YH\"-7?$@@@]^YE8:W#)^W#*I?[NH@@@@@@@@@@@@" +
			">H&I7/7=78 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@HN#(:MC$4E#$4N#L:L3)^W+NA@@@@@@@@=%9^YE9^W%9^W#*H,?7_\"A@:N#P:N/" +
			";=+U8:W%8:W%8:W%;_,?7^YO;=\"FRC\"FRB\"H#=7/:IN%9^YE9@W%9^YE9^W#*I?*7" +
			"_+]?9@@@@@OX:YE9^W%9^W/;>+_(@@@@@@@@@@@@@>U7>+]>H@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@CL:MC$VN!T4N!@9E#P:N#)^Y" +
			"NC8@@@@@@@2YE9^W&Q^W&Q^W('>?($:N#$4EU;=,8%^N%9^N%9^N%9^N/:-?-:-?-" +
			"6H 8!$ 6Q%\"_:-?( :N#)^W%9^W%9^W&P:YO6-?/7>? @@@@@@@B,2N%8:YC)$,:6" +
			"3@@@@@@@@@@@@@@@@@O+ ?@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@C6N#(:MC$4N!T4NSP9E#L:N#*-7//5@@@@@E=^W%8:W&Q^N%8:\"" +
			"KN-\"@<:N!Y^,:7>\"C)^W&Q^W&Q^N%:H,?6-?_:I\"H!$\"X!$ (\"H,?63\"CP:N(!^W&" +
			"Q^PE9^W%:I?-;^+];7@@@@@@@@@@@,YE9^W('=,? @@@@@@@@@@@@@@@@@@O#6@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C(:N#(:N#$:" +
			"MAT:DC(3E#P9+_6-8OT@@@@@W%9$W&Q^W%9^W(#_?]>HN#P9MH#>?(%^W%8:W#)^N" +
			"%9^N*6-7/:-,:5$ 8\"H (&HW8\"-?*6HN#&-7S)^W%9^W&Q^W(#=+_7>+_T@@@@@@@" +
			"@@@@@HN%9^?*7_= @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@W#(:N#L:MAX3N#P:L1X4\"M?^?+N,=P@@@@]$" +
			"W%9^W%9^W&P:\"J7>+VPON!A$+[NHW%9^N%9^W%9^W%9^7/;=+];;\"H&HYHI%\"E:H\"" +
			"_;^?($O\"_;^W&Q^YE9^W%9$7=;>+]8+@@@@@@@@@@@@@@C7N[O_8O @@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@:N#(9N#(9MC(VL1X:L8# +_6-7?\\@@@@@W%9^YE9^YC)$W%9$7:6HMC(:YO;>" +
			"?%8:W#)^W#)^N%8:N/7>?];=70C6\"H&H\"X\"H\"VRH?*7>YC*-?UX3YU9^W&Q^N(\"-+" +
			"_7_>P@@@@@@@@@@@@@@@@@@>_':J0@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@E9^N#(4N#(:L3(:L1ZI+VR" +
			"H,?7_=0@@@@@9W%9^N%9^W%9^W*7>?-83N#N-?+NIW%9^YC)^W&Q^W%8:\"]:-+[MV" +
			"@@C6\"H&H\"U:H 8'=7*6-\"M>-@OU]W%8:W%9^YM?=,8#5@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@W%9^N#(:MC(:L1X4N_4:N(&-7?(@@@@@@E9$W%9$W%9$W%9" +
			"$?-:-N#(V\"_:3U#L:W#)^W%8:W#)^N(#=?/6-7?X@@@C5\"H&H\"X\"H\"O:-?[O=,?X@" +
			"@OT:YE9$W&R-?*7_ P@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A$W#)^N#" +
			"(:NS(:MC&-N#(:?_;_>@@@@@@3W%9^YE9^W%9^W%;>+_89MH#=,8H@L&Q^W%8:W%9" +
			"^W%8:\"J7^7.C8@@@@@@C5?HJIYH\"I+];>+[N,=P@@@@A^YU9^W/7^,?,@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@H%$W%8:N#$4N#L:7( :L8\"3+_ @@@@@@C" +
			"M$W%9^W&Q^YE9$\"_;^\"AA^7:7_>@@@L%<:W%9^N%8:W%:I?/7_+OX@@@@@@@@@J8\"" +
			"I ('>?];=8B,@@@@@@OT2W&RI?*7_=P@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@U(%^W%8:N#(:E%;?N#P:+_7=A0@@@@@@L%=$W%8:W%9^W%;>7*4:N(#_?/" +
			" @@@@@L&P:W%9$W%8:YO;^+Z0+@@@@@@@@@@@@J8&H\"KN-?[NA@@@@@@@@@@@GW/;" +
			"^?/$@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C6\"VQ$W%8:N#P:?&P4E" +
			"U;_,3(:B@@@@B1^W%9$W&Q^W&Q^W-;=?%:I?*63=P@@@@@@L&Q^N%8:W%9^7?63  " +
			"@@@@@@@@@@@@@@=(&I?/:-75X@@@@@@@@@@@C6?Z7_J0@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@C7\"U9^N%8:N%; W =^,?9^MC(:A0@@L&Q$W%9^W%9^N" +
			"%9$+_:I?_7^?\",@@@@@@@@@L6Q^W%9^W/:-?*4@@@@@@@@@@@@@@@@@A?7_,;O:@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@C9" +
			"\"VQ^W#(:?/9^N->-W!X9N#(,@@@,W%9^W&Q^YE9$W-;=,5;]+^AV@@@@@@@@@@@@L" +
			"%8:W#)$7/7^> @@@@@@@@@@@@@@@@@@=8JA>P@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@B.H\"U9^W(\"3\"E:3?U8:N#P:L3(H" +
			"@CI%W&P:W%9^W%9^+_:-?/63+OX@@@@@@@@@@@@@L&U^W(\"-?-?5@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@OZHYFP:+_6I+]=^N#(:N#(:N(':@C%^W%9^W%9$W#+=7/:-,:35" +
			"@@@@@@@@@@@@@@@@L&P:?*63>P@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@OZIW%;=,?;" +
			">YE9^W#(9MC*H7?,@L&U^YE9$W%9^\"M;=+];>  @@@@@@@@@@@@@@@@@@L5;^?-<+" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=X\"IYJ6-7*6HW%8:W%9$?->A@@@@L%=^W%9" +
			"^N%:I?-;=?[L@@@@@@@@@@@@@@@@@@@@,>;O >P@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@=XJI?_7=?+NI\"H#^?]?  _T@@@@@L&U^W&Q^N(\"-+];_> @@@@@@@@@@@@@" +
			"@@@@@@@@@>_'7@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=U637-;>+_63?*7_\"O" +
			"_5@@@@@@@@L&Q^W%:H,?;=7?$@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@>+N-+Z7^?*63+_0@@@@@@@@@@@@GYU9^N('>+];_>@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ " +
			"-?>7=?_7?76@@@@@@@@@@@@@@@,YE9^\"O;^?/$@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@>/+:>_':=0@@@@@@@@@@@@@@@" +
			"@@2YE:I+_:-=0@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@,Y_;=,8 @@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@C8,?:-=P@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
			"@@@@b";
		return StByteArray.FromPackedString_(packedString)._asInts();
	}
	/**
	 * Answer the ColorModel
	 *
	 * @return java.awt.image.ColorModel
	 */
	public final static ColorModel _LogoImage_colorModel() {
		Color[] colors = new Color[256];
		colors[0] = new Color(255, 255, 255);
		colors[1] = new Color(255, 255, 204);
		colors[2] = new Color(255, 255, 153);
		colors[3] = new Color(255, 255, 102);
		colors[4] = new Color(255, 255, 51);
		colors[5] = new Color(255, 255, 0);
		colors[6] = new Color(255, 204, 255);
		colors[7] = new Color(255, 204, 204);
		colors[8] = new Color(255, 204, 153);
		colors[9] = new Color(255, 204, 102);
		colors[10] = new Color(255, 204, 51);
		colors[11] = new Color(255, 204, 0);
		colors[12] = new Color(255, 153, 255);
		colors[13] = new Color(255, 153, 204);
		colors[14] = new Color(255, 153, 153);
		colors[15] = new Color(255, 153, 102);
		colors[16] = new Color(255, 153, 51);
		colors[17] = new Color(255, 153, 0);
		colors[18] = new Color(255, 102, 255);
		colors[19] = new Color(255, 102, 204);
		colors[20] = new Color(255, 102, 153);
		colors[21] = new Color(255, 102, 102);
		colors[22] = new Color(255, 102, 51);
		colors[23] = new Color(255, 102, 0);
		colors[24] = new Color(255, 51, 255);
		colors[25] = new Color(255, 51, 204);
		colors[26] = new Color(255, 51, 153);
		colors[27] = new Color(255, 51, 102);
		colors[28] = new Color(255, 51, 51);
		colors[29] = new Color(255, 51, 0);
		colors[30] = new Color(255, 0, 255);
		colors[31] = new Color(255, 0, 204);
		colors[32] = new Color(255, 0, 153);
		colors[33] = new Color(255, 0, 102);
		colors[34] = new Color(255, 0, 51);
		colors[35] = new Color(255, 0, 0);
		colors[36] = new Color(204, 255, 255);
		colors[37] = new Color(204, 255, 204);
		colors[38] = new Color(204, 255, 153);
		colors[39] = new Color(204, 255, 102);
		colors[40] = new Color(204, 255, 51);
		colors[41] = new Color(204, 255, 0);
		colors[42] = new Color(204, 204, 255);
		colors[43] = new Color(204, 204, 204);
		colors[44] = new Color(204, 204, 153);
		colors[45] = new Color(204, 204, 102);
		colors[46] = new Color(204, 204, 51);
		colors[47] = new Color(204, 204, 0);
		colors[48] = new Color(204, 153, 255);
		colors[49] = new Color(204, 153, 204);
		colors[50] = new Color(204, 153, 153);
		colors[51] = new Color(204, 153, 102);
		colors[52] = new Color(204, 153, 51);
		colors[53] = new Color(204, 153, 0);
		colors[54] = new Color(204, 102, 255);
		colors[55] = new Color(204, 102, 204);
		colors[56] = new Color(204, 102, 153);
		colors[57] = new Color(204, 102, 102);
		colors[58] = new Color(204, 102, 51);
		colors[59] = new Color(204, 102, 0);
		colors[60] = new Color(204, 51, 255);
		colors[61] = new Color(204, 51, 204);
		colors[62] = new Color(204, 51, 153);
		colors[63] = new Color(204, 51, 102);
		colors[64] = new Color(204, 51, 51);
		colors[65] = new Color(204, 51, 0);
		colors[66] = new Color(204, 0, 255);
		colors[67] = new Color(204, 0, 204);
		colors[68] = new Color(204, 0, 153);
		colors[69] = new Color(204, 0, 102);
		colors[70] = new Color(204, 0, 51);
		colors[71] = new Color(204, 0, 0);
		colors[72] = new Color(153, 255, 255);
		colors[73] = new Color(153, 255, 204);
		colors[74] = new Color(153, 255, 153);
		colors[75] = new Color(153, 255, 102);
		colors[76] = new Color(153, 255, 51);
		colors[77] = new Color(153, 255, 0);
		colors[78] = new Color(153, 204, 255);
		colors[79] = new Color(153, 204, 204);
		colors[80] = new Color(153, 204, 153);
		colors[81] = new Color(153, 204, 102);
		colors[82] = new Color(153, 204, 51);
		colors[83] = new Color(153, 204, 0);
		colors[84] = new Color(153, 153, 255);
		colors[85] = new Color(153, 153, 204);
		colors[86] = new Color(153, 153, 153);
		colors[87] = new Color(153, 153, 102);
		colors[88] = new Color(153, 153, 51);
		colors[89] = new Color(153, 153, 0);
		colors[90] = new Color(153, 102, 255);
		colors[91] = new Color(153, 102, 204);
		colors[92] = new Color(153, 102, 153);
		colors[93] = new Color(153, 102, 102);
		colors[94] = new Color(153, 102, 51);
		colors[95] = new Color(153, 102, 0);
		colors[96] = new Color(153, 51, 255);
		colors[97] = new Color(153, 51, 204);
		colors[98] = new Color(153, 51, 153);
		colors[99] = new Color(153, 51, 102);
		colors[100] = new Color(153, 51, 51);
		colors[101] = new Color(153, 51, 0);
		colors[102] = new Color(153, 0, 255);
		colors[103] = new Color(153, 0, 204);
		colors[104] = new Color(153, 0, 153);
		colors[105] = new Color(153, 0, 102);
		colors[106] = new Color(153, 0, 51);
		colors[107] = new Color(153, 0, 0);
		colors[108] = new Color(102, 255, 255);
		colors[109] = new Color(102, 255, 204);
		colors[110] = new Color(102, 255, 153);
		colors[111] = new Color(102, 255, 102);
		colors[112] = new Color(102, 255, 51);
		colors[113] = new Color(102, 255, 0);
		colors[114] = new Color(102, 204, 255);
		colors[115] = new Color(102, 204, 204);
		colors[116] = new Color(102, 204, 153);
		colors[117] = new Color(102, 204, 102);
		colors[118] = new Color(102, 204, 51);
		colors[119] = new Color(102, 204, 0);
		colors[120] = new Color(102, 153, 255);
		colors[121] = new Color(102, 153, 204);
		colors[122] = new Color(102, 153, 153);
		colors[123] = new Color(102, 153, 102);
		colors[124] = new Color(102, 153, 51);
		colors[125] = new Color(102, 153, 0);
		colors[126] = new Color(102, 102, 255);
		colors[127] = new Color(102, 102, 204);
		colors[128] = new Color(102, 102, 153);
		colors[129] = new Color(102, 102, 102);
		colors[130] = new Color(102, 102, 51);
		colors[131] = new Color(102, 102, 0);
		colors[132] = new Color(102, 51, 255);
		colors[133] = new Color(102, 51, 204);
		colors[134] = new Color(102, 51, 153);
		colors[135] = new Color(102, 51, 102);
		colors[136] = new Color(102, 51, 51);
		colors[137] = new Color(102, 51, 0);
		colors[138] = new Color(102, 0, 255);
		colors[139] = new Color(102, 0, 204);
		colors[140] = new Color(102, 0, 153);
		colors[141] = new Color(102, 0, 102);
		colors[142] = new Color(102, 0, 51);
		colors[143] = new Color(102, 0, 0);
		colors[144] = new Color(51, 255, 255);
		colors[145] = new Color(51, 255, 204);
		colors[146] = new Color(51, 255, 153);
		colors[147] = new Color(51, 255, 102);
		colors[148] = new Color(51, 255, 51);
		colors[149] = new Color(51, 255, 0);
		colors[150] = new Color(51, 204, 255);
		colors[151] = new Color(51, 204, 204);
		colors[152] = new Color(51, 204, 153);
		colors[153] = new Color(51, 204, 102);
		colors[154] = new Color(51, 204, 51);
		colors[155] = new Color(51, 204, 0);
		colors[156] = new Color(51, 153, 255);
		colors[157] = new Color(51, 153, 204);
		colors[158] = new Color(51, 153, 153);
		colors[159] = new Color(51, 153, 102);
		colors[160] = new Color(51, 153, 51);
		colors[161] = new Color(51, 153, 0);
		colors[162] = new Color(51, 102, 255);
		colors[163] = new Color(51, 102, 204);
		colors[164] = new Color(51, 102, 153);
		colors[165] = new Color(51, 102, 102);
		colors[166] = new Color(51, 102, 51);
		colors[167] = new Color(51, 102, 0);
		colors[168] = new Color(51, 51, 255);
		colors[169] = new Color(51, 51, 204);
		colors[170] = new Color(51, 51, 153);
		colors[171] = new Color(51, 51, 102);
		colors[172] = new Color(51, 51, 51);
		colors[173] = new Color(51, 51, 0);
		colors[174] = new Color(51, 0, 255);
		colors[175] = new Color(51, 0, 204);
		colors[176] = new Color(51, 0, 153);
		colors[177] = new Color(51, 0, 102);
		colors[178] = new Color(51, 0, 51);
		colors[179] = new Color(51, 0, 0);
		colors[180] = new Color(0, 255, 255);
		colors[181] = new Color(0, 255, 204);
		colors[182] = new Color(0, 255, 153);
		colors[183] = new Color(0, 255, 102);
		colors[184] = new Color(0, 255, 51);
		colors[185] = new Color(0, 255, 0);
		colors[186] = new Color(0, 204, 255);
		colors[187] = new Color(0, 204, 204);
		colors[188] = new Color(0, 204, 153);
		colors[189] = new Color(0, 204, 102);
		colors[190] = new Color(0, 204, 51);
		colors[191] = new Color(0, 204, 0);
		colors[192] = new Color(0, 153, 255);
		colors[193] = new Color(0, 153, 204);
		colors[194] = new Color(0, 153, 153);
		colors[195] = new Color(0, 153, 102);
		colors[196] = new Color(0, 153, 51);
		colors[197] = new Color(0, 153, 0);
		colors[198] = new Color(0, 102, 255);
		colors[199] = new Color(0, 102, 204);
		colors[200] = new Color(0, 102, 153);
		colors[201] = new Color(0, 102, 102);
		colors[202] = new Color(0, 102, 51);
		colors[203] = new Color(0, 102, 0);
		colors[204] = new Color(0, 51, 255);
		colors[205] = new Color(0, 51, 204);
		colors[206] = new Color(0, 51, 153);
		colors[207] = new Color(0, 51, 102);
		colors[208] = new Color(0, 51, 51);
		colors[209] = new Color(0, 51, 0);
		colors[210] = new Color(0, 0, 255);
		colors[211] = new Color(0, 0, 204);
		colors[212] = new Color(0, 0, 153);
		colors[213] = new Color(0, 0, 102);
		colors[214] = new Color(0, 0, 51);
		colors[215] = new Color(238, 0, 0);
		colors[216] = new Color(221, 0, 0);
		colors[217] = new Color(187, 0, 0);
		colors[218] = new Color(170, 0, 0);
		colors[219] = new Color(136, 0, 0);
		colors[220] = new Color(119, 0, 0);
		colors[221] = new Color(85, 0, 0);
		colors[222] = new Color(68, 0, 0);
		colors[223] = new Color(34, 0, 0);
		colors[224] = new Color(17, 0, 0);
		colors[225] = new Color(0, 238, 0);
		colors[226] = new Color(0, 221, 0);
		colors[227] = new Color(0, 187, 0);
		colors[228] = new Color(0, 170, 0);
		colors[229] = new Color(0, 136, 0);
		colors[230] = new Color(0, 119, 0);
		colors[231] = new Color(0, 85, 0);
		colors[232] = new Color(0, 68, 0);
		colors[233] = new Color(0, 34, 0);
		colors[234] = new Color(0, 17, 0);
		colors[235] = new Color(0, 0, 238);
		colors[236] = new Color(0, 0, 221);
		colors[237] = new Color(0, 0, 187);
		colors[238] = new Color(0, 0, 170);
		colors[239] = new Color(0, 0, 136);
		colors[240] = new Color(0, 0, 119);
		colors[241] = new Color(0, 0, 85);
		colors[242] = new Color(0, 0, 68);
		colors[243] = new Color(0, 0, 34);
		colors[244] = new Color(0, 0, 17);
		colors[245] = new Color(238, 238, 238);
		colors[246] = new Color(221, 221, 221);
		colors[247] = new Color(187, 187, 187);
		colors[248] = new Color(170, 170, 170);
		colors[249] = new Color(136, 136, 136);
		colors[250] = new Color(119, 119, 119);
		colors[251] = new Color(85, 85, 85);
		colors[252] = new Color(68, 68, 68);
		colors[253] = new Color(34, 34, 34);
		colors[254] = new Color(17, 17, 17);
		colors[255] = new Color(0, 0, 0);
		byte[] rPalette = new byte[256];
		byte[] gPalette = new byte[256];
		byte[] bPalette = new byte[256];
		for (int index = 0; index < 256; index++) {
			rPalette[index] = ((byte) colors[index].getRed());
			gPalette[index] = ((byte) colors[index].getGreen());
			bPalette[index] = ((byte) colors[index].getBlue());
		};
		return new IndexColorModel(8, 256, rPalette, gPalette, bPalette);
	}
	/**
	 * return Isr copyright string
	 *
	 * @return string
	 */
	public static final String Copyright() {
		return "Based on " + System() + Version() + " (" + (new java.util.Date()) + ") Copyright 2000 Software Research Associates, Inc.";
	}
	/**
	 * Create a Jun logo image.
	 *
	 * @return java.awt.Image
	 */
	public final static Image LogoImage() {
		int width = 176;
		int height = 64;
		int[] pixels = _LogoImage_bits();
		MemoryImageSource source = new MemoryImageSource(width, height, _LogoImage_colorModel(), pixels, 0, width);
		return Toolkit.getDefaultToolkit().createImage(source);
	}
	/**
	 * return Isr system string
	 *
	 * @return string
	 */
	public final static String System() {
		return "Isr";
	}
	/**
	 * return Jun version string
	 *
	 * @return string
	 */
	public final static String Version() {
		return "019";
	}
}
