package sra.isr.interfaces.spot;

import java.awt.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.geometry.basic.*;
import sra.isr.interfaces.button.*;

/**
 * IsrSpotViewAwt class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrSpotViewAwt.java,v 1.3 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrSpotViewAwt extends StViewCanvas implements IsrSpotView {
	protected IsrSpotController controller;
	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setSize(this.plateArea().width + 22, this.plateArea().height + 22);
		// controller
		controller = this.defaultController();
		controller.view_(this);
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StController
	 */
	protected IsrSpotController defaultController() {
		return new IsrSpotController();
	}
	/**
	 * Answer a default model.
	 *
	 * @return sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new IsrSpotModel();
	}
	/**
	 * paint this border rectangle.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		this.displayPlateOn_(aGraphics);
		this.displayXYOn_(aGraphics);
	}
	/**
	 * Display the plate using the Graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayPlateOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		Rectangle box = this.plateArea();
		aGraphics.clipRect(box.x - 1, box.y - 1, box.width + 2, box.height + 2);
		this.plate().displayOn_at_(aGraphics, box.getLocation());
		aGraphics.setColor(Color.black);
		aGraphics.drawRect(box.x - 1, box.y - 1, box.width + 1, box.height + 1);
	}
	/**
	 * Display the point using the Graphics.
	 *
	 * @param graphics java.awt.Graphics
	 */
	public void displayXYOn_(Graphics aGraphics) {
		if (!this.isShowing())
			return;
		Rectangle box = this.plateArea();
		aGraphics.clipRect(box.x - 1, box.y - 1, box.width + 2, box.height + 2);
		Point point = new Point((int) (this.xy().x() * (box.width - 1)), (int) (this.xy().y() * (box.height - 1)));
		Point globalPoint = new Point(point);
		globalPoint.translate(box.x, box.y);
		aGraphics.setColor(Color.white);
		for (int i = 0; i < 360; i += 15) {
			aGraphics.drawArc(globalPoint.x - 4, globalPoint.y - 4, 8, 8, i, 15);
			if (aGraphics.getColor() == Color.white) {
				aGraphics.setColor(Color.black);
			} else {
				aGraphics.setColor(Color.white);
			}
		}
	}
	/**
	 * Answer a Model.
	 *
	 * @return sra.isr.interfaces.spot.IsrSpotModel
	 */
	public IsrSpotModel getModel() {
		return (IsrSpotModel) this.model();
	}
	/**
	 * get the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public StImage plate() {
		return this.getModel().plate();
	}
	/**
	 * get the plate bounds.
	 *
	 * @return java.awt.Rectangle
	 */
	public Rectangle plateArea() {
		Rectangle imageRect = this.plate().bounds();
		imageRect.translate(10, 10);
		return imageRect;
	}
	/**
	 * model property accessing.
	 *
	 * @param aModel sra.isr.interfaces.spot.IsrSpotModel
	 */
	public void setModel(IsrSpotModel aModel) {
		this.model_(aModel);
	}
	/**
	 * Update the receiver according to the change notification from the model.
	 *
	 * @param evt sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing())
			return;
		if (evt.getAspect() == $("xy")) {
			Graphics gc = this.getGraphics();
			try {
				this.displayPlateOn_(gc);
				this.displayXYOn_(gc);
			} finally {
				gc.dispose();
			}
		}
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 *
	 * @return sra.isr.geometry.basic.Jun2dPoint
	 */
	public Isr2dPoint xy() {
		return this.getModel().xy();
	}
}