package sra.isr.interfaces.spot;

import java.awt.*;
import java.io.*;
import sra.smalltalk.*;
import sra.isr.system.support.*;
import sra.isr.geometry.basic.*;

/**
 * IsrSpotModel class
 * 
 * 	@author:        Mitsuhiro Asada
 * 	@created:       1999/12/21 (by Mitsuhiro Asada)
 * 	@updated:       2000/02/16 (by Mitsuhiro Asada)
 * 	@ImageSearcher: 019
 * 	@JDK:           1.1.6 or higher
 * 	@copyright:     2000 SRA (Software Research Associates, Inc.)
 * 
 * 	$Id: IsrSpotModel.java,v 1.12 2000/04/07 04:24:19 m-asada Exp $
 */
public class IsrSpotModel extends StApplicationModel {
	protected Isr2dPoint xy;
	protected static StImage Plate = null;
	private boolean accepted = false;
	/**
	 * Construsctor
	 */
	public IsrSpotModel() {
		super();
		initialize();
	}
	/**
	 * defines OK/Cancel dialog buttons.
	 *
	 * @return Panel
	 */
	public Panel _okCancelButtons(final Dialog target) {
		Panel panel = new Panel();
		final IsrSpotModel this_ = this;
		panel.add("West", new Button("OK") {
			public boolean action(Event ev, Object what) {
				this_.accept();
				target.dispose();
				return true;
			}
		});
		panel.add("East", new Button("Cancel") {
			public boolean action(Event ev, Object what) {
				this_.cancel();
				target.dispose();
				return true;
			}
		});
		return panel;
	}
	/**
	 * accept button pressed action(in dialog mode)
	 */
	public void accept() {
		this.accepted = true;
	}
	/**
	 * accept button pressed action(in dialog mode). do nothing.
	 */
	public void cancel() {
	}
	/**
	 * Answer a default view.
	 *
	 * @return sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new IsrSpotViewAwt();
		} else {
			return this.CreateView("sra.isr.interfaces.spot.IsrSpotViewSwing");
		}
	}
	/**
	 * Initialize this object.
	 */
	public IsrSpotModel initialize() {
		this.xy();
		return this;
	}
	/**
	 * the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	public StImage plate() {
		return this.Plate();
	}
	/**
	 * the plate image.
	 *
	 * @return sra.smalltalk.StImage
	 */
	static StImage Plate() {
		if (Plate == null) {
			int x, y;
			Color color;
			int interval = 101;
			int width, height;
			StImage image = new StImage(interval, interval);
			width = image.width();
			height = image.height();
			color = Color.getHSBColor((float) 0.0, (float) 0.0, (float) 0.82);
			for (y = 0; y < height; y++) {
				for (x = 0; x < width; x++) {
					image.atX_y_put_(x, y, color.getRGB());
				}
			}
			color = Color.black;
			for (y = 0; y < height; y++) {
				for (x = 0; x < width; x++) {
					if ((x % 10 == 0) && (y % 10 == 0)) {
						image.atX_y_put_(x, y, color.getRGB());
						if ((x == ((width - 1) / 2)) && (y == ((height - 1) / 2))) {
							Point[] array = {new Point(-1, 0), new Point(0, 1), new Point(1, 0), new Point(0, -1)};
							for (int i = 0; i < array.length; i++) {
								image.atX_y_put_(x + array[i].x, y + array[i].y, color.getRGB());
							}
						}
					}
				}
			}
			Plate = image;
		}
		return Plate;
	}
	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		aWriter.write(this.xy().toString());
	}
	/**
	 * Create the Dialog for IsrSpotModel with initial value.
	 *
	 * @return sra.isr.geometry.basic.Isr2dPoint or null
	 */
	public static Isr2dPoint Request_() {
		return Request_(new Isr2dPoint(0.0, 0.0));
	}
	/**
	 * Create the Dialog for IsrSpotModel with value.
	 *
	 * @return sra.isr.geometry.basic.Jun2dPoint or null
	 * @param aPoint sra.isr.geometry.basic.Jun2dPoint
	 */
	public static Isr2dPoint Request_(Isr2dPoint aPoint) {
		IsrSpotModel spotModel = new IsrSpotModel();
		if (aPoint == null) {
			spotModel.xy_(new Isr2dPoint(0.0, 0.0));
		} else {
			spotModel.xy_(aPoint);
		}
		Isr2dPoint result = null;
		Frame parent = new Frame();
		IsrSpotView view = (IsrSpotView) spotModel.defaultView();
		view.setModel(spotModel);
		Dialog dialog = new Dialog(parent, "Area", true);
		dialog.setResizable(false);
		dialog.add("Center", (Component) view);
		dialog.add("South", spotModel._okCancelButtons(dialog));
		dialog.pack();
		try {
			Thread.sleep(0);
		} catch (Exception e) {
		}
		spotModel.changed();
		dialog.show();
		if (spotModel.accepted) {
			result = spotModel.xy();
		}
		return result;
	}
	/**
	 * Answer a view.
	 *
	 * @return sra.sMMa.interfaces.spot.IsrSpotViewAwt
	 */
	public IsrSpotViewAwt spotView() {
		IsrSpotViewAwt view = new IsrSpotViewAwt();
		view.model_(this);
		return view;
	}
	/**
	 * Answer a window title.
	 * @return java.lang.String
	 */
	protected String windowTitle() {
		return "Spot";
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public Isr2dPoint xy() {
		if (xy == null) {
			xy = new Isr2dPoint(0, 0);
		}
		return xy;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public static IsrSpotModel Xy_(Isr2dPoint aPoint) {
		IsrSpotModel model = new IsrSpotModel();
		model.xy_(aPoint);
		return model;
	}
	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void xy_(Isr2dPoint aPoint) {
		if (xy != aPoint) {
			xy = aPoint;
			this.changed_(StObject.$("xy"));
		}
	}
}
